/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.model;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.openid.connect.model.WhitelistedSite;

@Entity
@Table(name="approved_site")
@NamedQueries(value={@NamedQuery(name="ApprovedSite.getAll", query="select a from ApprovedSite a"), @NamedQuery(name="ApprovedSite.getByUserId", query="select a from ApprovedSite a where a.userId = :userId"), @NamedQuery(name="ApprovedSite.getByClientId", query="select a from ApprovedSite a where a.clientId = :clientId"), @NamedQuery(name="ApprovedSite.getByClientIdAndUserId", query="select a from ApprovedSite a where a.clientId = :clientId and a.userId = :userId")})
public class ApprovedSite {
    private Long id;
    private String userId;
    private String clientId;
    private Date creationDate;
    private Date accessDate;
    private Date timeoutDate;
    private Set<String> allowedScopes;
    private WhitelistedSite whitelistedSite;
    private Set<OAuth2AccessTokenEntity> approvedAccessTokens = Sets.newHashSet();

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name="user_id")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Basic
    @Column(name="client_id")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_date")
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="access_date")
    public Date getAccessDate() {
        return this.accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this.accessDate = accessDate;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="approved_site_scope", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="scope")
    public Set<String> getAllowedScopes() {
        return this.allowedScopes;
    }

    public void setAllowedScopes(Set<String> allowedScopes) {
        this.allowedScopes = allowedScopes;
    }

    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="timeout_date")
    public Date getTimeoutDate() {
        return this.timeoutDate;
    }

    public void setTimeoutDate(Date timeoutDate) {
        this.timeoutDate = timeoutDate;
    }

    @Transient
    public Boolean getIsWhitelisted() {
        return this.whitelistedSite != null;
    }

    @ManyToOne
    @JoinColumn(name="whitelisted_site_id")
    public WhitelistedSite getWhitelistedSite() {
        return this.whitelistedSite;
    }

    public void setWhitelistedSite(WhitelistedSite whitelistedSite) {
        this.whitelistedSite = whitelistedSite;
    }

    @Transient
    public boolean isExpired() {
        if (this.getTimeoutDate() != null) {
            Date now = new Date();
            return now.after(this.getTimeoutDate());
        }
        return false;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="approved_site_id")
    public Set<OAuth2AccessTokenEntity> getApprovedAccessTokens() {
        return this.approvedAccessTokens;
    }

    public void setApprovedAccessTokens(Set<OAuth2AccessTokenEntity> approvedAccessTokens) {
        this.approvedAccessTokens = approvedAccessTokens;
    }
}

