/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.mitre.openid.connect.model.UserInfo;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class OIDCAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 22100073066377804L;
    private final ImmutableMap<String, String> principal;
    private final String idTokenValue;
    private final String accessTokenValue;
    private final String refreshTokenValue;
    private final String issuer;
    private final String sub;
    private final transient ServerConfiguration serverConfiguration;
    private final UserInfo userInfo;

    public OIDCAuthenticationToken(String subject, String issuer, UserInfo userInfo, Collection<? extends GrantedAuthority> authorities, String idTokenValue, String accessTokenValue, String refreshTokenValue) {
        super(authorities);
        this.principal = ImmutableMap.of((Object)"sub", (Object)subject, (Object)"iss", (Object)issuer);
        this.userInfo = userInfo;
        this.sub = subject;
        this.issuer = issuer;
        this.idTokenValue = idTokenValue;
        this.accessTokenValue = accessTokenValue;
        this.refreshTokenValue = refreshTokenValue;
        this.serverConfiguration = null;
        this.setAuthenticated(true);
    }

    public OIDCAuthenticationToken(String subject, String issuer, ServerConfiguration serverConfiguration, String idTokenValue, String accessTokenValue, String refreshTokenValue) {
        super(new ArrayList(0));
        this.principal = ImmutableMap.of((Object)"sub", (Object)subject, (Object)"iss", (Object)issuer);
        this.sub = subject;
        this.issuer = issuer;
        this.idTokenValue = idTokenValue;
        this.accessTokenValue = accessTokenValue;
        this.refreshTokenValue = refreshTokenValue;
        this.userInfo = null;
        this.serverConfiguration = serverConfiguration;
        this.setAuthenticated(false);
    }

    public Object getCredentials() {
        return this.accessTokenValue;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getSub() {
        return this.sub;
    }

    public String getIdTokenValue() {
        return this.idTokenValue;
    }

    public String getAccessTokenValue() {
        return this.accessTokenValue;
    }

    public String getRefreshTokenValue() {
        return this.refreshTokenValue;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }
}

