/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.view;

import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="jwkKeyList")
public class JwkKeyListView
extends AbstractView {
    public static final String VIEWNAME = "jwkKeyList";
    private static Logger logger = LoggerFactory.getLogger(JwkKeyListView.class);

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        Map keys = (Map)model.get("keys");
        JWKSet jwkSet = new JWKSet(new ArrayList(keys.values()));
        try {
            PrintWriter out = response.getWriter();
            ((Writer)out).write(jwkSet.toString());
        }
        catch (IOException e) {
            logger.error("IOException in JwkKeyListView.java: ", (Throwable)e);
        }
    }
}

