/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.view.RedirectView;

public class UserInfoInterceptor
extends HandlerInterceptorAdapter {
    private Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(GrantedAuthority.class, (Object)new JsonSerializer<GrantedAuthority>(){

        public JsonElement serialize(GrantedAuthority src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getAuthority());
        }
    }).create();
    @Autowired(required=false)
    private UserInfoService userInfoService;

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView != null && !modelAndView.getModel().containsKey("userInfo") && !(modelAndView.getView() instanceof RedirectView)) {
            UserInfo user;
            Principal p = request.getUserPrincipal();
            if (p instanceof Authentication && !modelAndView.getModel().containsKey("userAuthorities")) {
                Authentication auth = (Authentication)p;
                modelAndView.addObject("userAuthorities", (Object)this.gson.toJson((Object)auth.getAuthorities()));
            }
            if (p instanceof OIDCAuthenticationToken) {
                OIDCAuthenticationToken oidc = (OIDCAuthenticationToken)((Object)p);
                if (oidc.getUserInfo() != null) {
                    modelAndView.addObject("userInfo", (Object)oidc.getUserInfo());
                    modelAndView.addObject("userInfoJson", (Object)oidc.getUserInfo().toJson());
                } else {
                    modelAndView.addObject("userInfo", null);
                    modelAndView.addObject("userInfoJson", (Object)"null");
                }
            } else if (p != null && p.getName() != null && this.userInfoService != null && (user = this.userInfoService.getByUsername(p.getName())) != null) {
                modelAndView.addObject("userInfo", (Object)user);
                modelAndView.addObject("userInfoJson", (Object)user.toJson());
            }
        }
    }
}

