/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashSet;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

@Service(value="uriEncodedClientUserDetailsService")
public class UriEncodedClientUserDetailsService
implements UserDetailsService {
    private static GrantedAuthority ROLE_CLIENT = new SimpleGrantedAuthority("ROLE_CLIENT");
    @Autowired
    private ClientDetailsEntityService clientDetailsService;

    public UserDetails loadUserByUsername(String clientId) throws UsernameNotFoundException {
        try {
            String decodedClientId = UriUtils.decode((String)clientId, (String)"UTF-8");
            ClientDetailsEntity client = this.clientDetailsService.loadClientByClientId(decodedClientId);
            if (client != null) {
                String encodedPassword = UriUtils.encodeQueryParam((String)Strings.nullToEmpty((String)client.getClientSecret()), (String)"UTF-8");
                if (client.getTokenEndpointAuthMethod() != null && (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_JWT))) {
                    encodedPassword = new BigInteger(512, new SecureRandom()).toString(16);
                }
                boolean enabled = true;
                boolean accountNonExpired = true;
                boolean credentialsNonExpired = true;
                boolean accountNonLocked = true;
                HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>(client.getAuthorities());
                authorities.add(ROLE_CLIENT);
                return new User(decodedClientId, encodedPassword, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
            }
            throw new UsernameNotFoundException("Client not found: " + clientId);
        }
        catch (UnsupportedEncodingException | InvalidClientException e) {
            throw new UsernameNotFoundException("Client not found: " + clientId);
        }
    }

    public ClientDetailsEntityService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public void setClientDetailsService(ClientDetailsEntityService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

