/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.config;

import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.i18n.AbstractLocaleContextResolver;

@Component(value="localeResolver")
public class ConfigurationBeanLocaleResolver
extends AbstractLocaleContextResolver {
    @Autowired
    private ConfigurationPropertiesBean config;

    protected Locale getDefaultLocale() {
        if (this.config.getLocale() != null) {
            return this.config.getLocale();
        }
        return super.getDefaultLocale();
    }

    public LocaleContext resolveLocaleContext(HttpServletRequest request) {
        return new TimeZoneAwareLocaleContext(){

            public Locale getLocale() {
                return ConfigurationBeanLocaleResolver.this.getDefaultLocale();
            }

            public TimeZone getTimeZone() {
                return ConfigurationBeanLocaleResolver.this.getDefaultTimeZone();
            }
        };
    }

    public void setLocaleContext(HttpServletRequest request, HttpServletResponse response, LocaleContext localeContext) {
        throw new UnsupportedOperationException("Cannot change fixed locale - use a different locale resolution strategy");
    }
}

