/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http.relay;

import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpDecoder {
    protected static final Logger logger = LoggerFactory.getLogger(BasicHttpDecoder.class);
    private final ByteBuf byteBuf;
    private Integer contentLength = null;
    private int contentStart;

    public BasicHttpDecoder(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
        this.readContentLength();
        byteBuf.release();
    }

    private String readLine() {
        StringBuilder stringBuffer = new StringBuilder();
        while (this.byteBuf.isReadable()) {
            char nextCharacter = (char)this.byteBuf.readByte();
            if (nextCharacter == '\r' || nextCharacter == '\n') {
                if (!this.byteBuf.isReadable()) break;
                this.byteBuf.readByte();
                break;
            }
            stringBuffer.append(nextCharacter);
        }
        return stringBuffer.toString();
    }

    private void readContentLength() {
        while (this.byteBuf.isReadable()) {
            String line = this.readLine();
            if (line.startsWith("Content-Length")) {
                this.contentLength = Integer.parseInt(line.split(":")[1].trim());
            }
            if (this.contentLength == null || !line.isEmpty()) continue;
            this.contentStart = this.byteBuf.readerIndex();
            break;
        }
    }

    public Integer getContentLength() {
        return this.contentLength;
    }

    public int getContentStart() {
        return this.contentStart;
    }
}

