/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.StringBody;
import org.mockserver.url.URLParser;

public class MockServerRequestDecoder
extends MessageToMessageDecoder<FullHttpRequest> {
    private final boolean isSecure;

    public MockServerRequestDecoder(boolean isSecure) {
        this.isSecure = isSecure;
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest fullHttpResponse, List<Object> out) {
        HttpRequest httpRequest = new HttpRequest();
        if (fullHttpResponse != null) {
            this.setMethod(httpRequest, fullHttpResponse);
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(fullHttpResponse.getUri());
            this.setPath(httpRequest, queryStringDecoder);
            this.setQueryString(httpRequest, queryStringDecoder);
            this.setBody(httpRequest, fullHttpResponse);
            this.setHeaders(httpRequest, fullHttpResponse);
            this.setCookies(httpRequest, fullHttpResponse);
            httpRequest.setKeepAlive(HttpHeaders.isKeepAlive((HttpMessage)fullHttpResponse));
            httpRequest.setSecure(this.isSecure);
        }
        out.add(httpRequest);
    }

    private void setMethod(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        httpRequest.withMethod(fullHttpResponse.getMethod().name());
    }

    private void setPath(HttpRequest httpRequest, QueryStringDecoder queryStringDecoder) {
        httpRequest.withPath(URLParser.returnPath((String)queryStringDecoder.path()));
    }

    private void setQueryString(HttpRequest httpRequest, QueryStringDecoder queryStringDecoder) {
        httpRequest.withQueryStringParameters(queryStringDecoder.parameters());
    }

    private void setBody(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        if (fullHttpResponse.content() != null && fullHttpResponse.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpResponse.content().readableBytes()];
            fullHttpResponse.content().readBytes(bodyBytes);
            if (bodyBytes.length > 0) {
                if (ContentTypeMapper.isBinary((String)fullHttpResponse.headers().get("Content-Type"))) {
                    httpRequest.withBody((Body)new BinaryBody(bodyBytes));
                } else {
                    httpRequest.withBody((Body)new StringBody(new String(bodyBytes, Charsets.UTF_8), bodyBytes));
                }
            }
        }
    }

    private void setHeaders(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        HttpHeaders headers = fullHttpResponse.headers();
        for (String headerName : headers.names()) {
            httpRequest.withHeader(new Header(headerName, (Collection)headers.getAll(headerName)));
        }
    }

    private void setCookies(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        for (String cookieHeader : fullHttpResponse.headers().getAll("Cookie")) {
            for (String cookie : Splitter.on((String)";").split((CharSequence)cookieHeader)) {
                if (cookie.trim().isEmpty()) continue;
                httpRequest.withCookie(new Cookie(StringUtils.substringBefore((String)cookie, (String)"=").trim(), StringUtils.substringAfter((String)cookie, (String)"=").trim()));
            }
        }
    }
}

