/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.mockserver.configuration.Configuration;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.httpclient.NettyHttpClient;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.http.HttpActionHandler;
import org.mockserver.model.BinaryMessage;
import org.mockserver.model.BinaryProxyListener;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.uuid.UUIDService;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class BinaryRequestProxyingHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final Configuration configuration;
    private final MockServerLogger mockServerLogger;
    private final Scheduler scheduler;
    private final NettyHttpClient httpClient;
    private final BinaryProxyListener binaryExchangeCallback;

    public BinaryRequestProxyingHandler(Configuration configuration, MockServerLogger mockServerLogger, Scheduler scheduler, NettyHttpClient httpClient) {
        super(true);
        this.configuration = configuration;
        this.mockServerLogger = mockServerLogger;
        this.scheduler = scheduler;
        this.httpClient = httpClient;
        this.binaryExchangeCallback = configuration.binaryProxyListener();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) {
        BinaryMessage binaryRequest = BinaryMessage.bytes((byte[])ByteBufUtil.getBytes((ByteBuf)byteBuf));
        String logCorrelationId = UUIDService.getUUID();
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RECEIVED_REQUEST).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("received binary request:{}").setArguments(new Object[]{ByteBufUtil.hexDump((byte[])binaryRequest.getBytes())}));
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress((ChannelHandlerContext)ctx);
        if (remoteAddress != null) {
            this.sendMessage(ctx, binaryRequest, logCorrelationId, remoteAddress);
        } else {
            if (MockServerLogger.isEnabled((Level)Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP, found request in binary: {} in utf8 text: {}").setArguments(new Object[]{ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), new String(binaryRequest.getBytes(), StandardCharsets.UTF_8)}));
            }
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])"unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP".getBytes(StandardCharsets.UTF_8)));
            ctx.close();
        }
    }

    private void sendMessage(ChannelHandlerContext ctx, BinaryMessage binaryRequest, String logCorrelationId, InetSocketAddress remoteAddress) {
        CompletableFuture binaryResponseFuture = this.httpClient.sendRequest(binaryRequest, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), remoteAddress, this.configuration.socketConnectionTimeoutInMillis());
        if (this.configuration.forwardBinaryRequestsWithoutWaitingForResponse().booleanValue()) {
            this.processNotWaitingForResponse(ctx, binaryRequest, logCorrelationId, remoteAddress, binaryResponseFuture);
        } else {
            this.processWaitingForResponse(ctx, binaryRequest, logCorrelationId, remoteAddress, binaryResponseFuture);
        }
    }

    private void processNotWaitingForResponse(ChannelHandlerContext ctx, BinaryMessage binaryRequest, String logCorrelationId, InetSocketAddress remoteAddress, CompletableFuture<BinaryMessage> binaryResponseFuture) {
        if (this.binaryExchangeCallback != null) {
            this.binaryExchangeCallback.onProxy(binaryRequest, binaryResponseFuture, (SocketAddress)remoteAddress, ctx.channel().remoteAddress());
        }
        this.scheduler.submit(binaryResponseFuture, () -> {
            try {
                BinaryMessage binaryResponse = (BinaryMessage)binaryResponseFuture.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                if (binaryResponse != null) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.FORWARDED_REQUEST).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("returning binary response:{}from:{}for forwarded binary request:{}").setArguments(new Object[]{StringFormatter.formatBytes((byte[])binaryResponse.getBytes()), remoteAddress, StringFormatter.formatBytes((byte[])binaryRequest.getBytes())}));
                    ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryResponse.getBytes()));
                }
            }
            catch (Throwable throwable) {
                if (MockServerLogger.isEnabled((Level)Level.WARN)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setCorrelationId(logCorrelationId).setMessageFormat("exception " + throwable.getMessage() + " sending hex{}to{}closing connection").setArguments(new Object[]{ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), remoteAddress}).setThrowable(throwable));
                }
                ctx.close();
            }
        }, false);
    }

    private void processWaitingForResponse(ChannelHandlerContext ctx, BinaryMessage binaryRequest, String logCorrelationId, InetSocketAddress remoteAddress, CompletableFuture<BinaryMessage> binaryResponseFuture) {
        this.scheduler.submit(binaryResponseFuture, () -> {
            try {
                BinaryMessage binaryResponse = (BinaryMessage)binaryResponseFuture.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.FORWARDED_REQUEST).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("returning binary response:{}from:{}for forwarded binary request:{}").setArguments(new Object[]{StringFormatter.formatBytes((byte[])binaryResponse.getBytes()), remoteAddress, StringFormatter.formatBytes((byte[])binaryRequest.getBytes())}));
                if (this.binaryExchangeCallback != null) {
                    this.binaryExchangeCallback.onProxy(binaryRequest, binaryResponseFuture, (SocketAddress)remoteAddress, ctx.channel().remoteAddress());
                }
                ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryResponse.getBytes()));
            }
            catch (Throwable throwable) {
                if (MockServerLogger.isEnabled((Level)Level.WARN)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setCorrelationId(logCorrelationId).setMessageFormat("exception " + throwable.getMessage() + " sending hex{}to{}closing connection").setArguments(new Object[]{ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), remoteAddress}).setThrowable(throwable));
                }
                ctx.close();
            }
        }, false);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception caught by " + ((Object)((Object)this)).getClass() + " handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

