/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.api.monitor;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.api.monitor.DurationActivity;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.monitor.History;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.monitor.Window;

public interface RepositoryMonitor {
    public static final Set<DurationMetric> ALL_DURATION_METRICS = Collections.unmodifiableSet(EnumSet.allOf(DurationMetric.class));
    public static final Set<ValueMetric> ALL_VALUE_METRICS = Collections.unmodifiableSet(EnumSet.allOf(ValueMetric.class));
    public static final Set<Window> ALL_WINDOWS = Collections.unmodifiableSet(EnumSet.allOf(Window.class));
    public static final RepositoryMonitor EMPTY_MONITOR = new RepositoryMonitor(){

        @Override
        public Set<DurationMetric> getAvailableDurationMetrics() {
            return ALL_DURATION_METRICS;
        }

        @Override
        public Set<ValueMetric> getAvailableValueMetrics() {
            return ALL_VALUE_METRICS;
        }

        @Override
        public Set<Window> getAvailableWindows() {
            return ALL_WINDOWS;
        }

        @Override
        public History getHistory(ValueMetric metric, Window windowInTime) {
            return History.NO_HISTORY;
        }

        @Override
        public History getHistory(DurationMetric metric, Window windowInTime) {
            return History.NO_HISTORY;
        }

        @Override
        public DurationActivity[] getLongestRunning(DurationMetric metric) {
            return DurationActivity.NO_DURATION_RECORDS;
        }
    };

    public Set<ValueMetric> getAvailableValueMetrics();

    public Set<DurationMetric> getAvailableDurationMetrics();

    public Set<Window> getAvailableWindows();

    public History getHistory(ValueMetric var1, Window var2) throws AccessDeniedException, RepositoryException;

    public History getHistory(DurationMetric var1, Window var2) throws AccessDeniedException, RepositoryException;

    public DurationActivity[] getLongestRunning(DurationMetric var1) throws AccessDeniedException, RepositoryException;
}

