/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.mapdb.Serializer;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.index.local.MapDB;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.RowExtractors;
import org.modeshape.jcr.query.engine.process.BufferedRows;
import org.modeshape.jcr.query.engine.process.DelegatingSequence;
import org.modeshape.jcr.query.model.TypeSystem;

public abstract class BufferingSequence
extends DelegatingSequence {
    protected static final Logger logger = Logger.getLogger(BufferingSequence.class);
    protected static final boolean trace = logger.isTraceEnabled();
    protected final BufferManager.SortingBuffer<Object, BufferedRows.BufferedRow> buffer;
    protected final BufferedRows.BufferedRowFactory<? extends BufferedRows.BufferedRow> rowFactory;
    protected final RowExtractors.ExtractFromRow extractor;
    protected final CachedNodeSupplier cache;
    protected final int width;
    protected final String workspaceName;
    protected final AtomicLong remainingRowCount = new AtomicLong();
    protected final AtomicLong rowsLeftInBatch = new AtomicLong();

    protected BufferingSequence(String workspaceName, NodeSequence delegate, RowExtractors.ExtractFromRow extractor, BufferManager bufferMgr, CachedNodeSupplier nodeCache, boolean pack, boolean useHeap, boolean allowDuplicates) {
        super(delegate);
        assert (extractor != null);
        this.workspaceName = workspaceName;
        this.width = delegate.width();
        this.cache = nodeCache;
        this.extractor = extractor;
        this.rowFactory = BufferedRows.serializer(nodeCache, this.width);
        BufferManager.SortingBuffer<?, ? extends BufferedRows.BufferedRow> buffer = null;
        TypeSystem.TypeFactory<?> keyType = extractor.getType();
        if (allowDuplicates) {
            Serializer<?> keySerializer = bufferMgr.serializerFor(keyType);
            buffer = bufferMgr.createSortingWithDuplicatesBuffer(keySerializer, extractor.getType().getComparator(), this.rowFactory).keepSize(true).useHeap(useHeap).make();
        } else {
            Object keySerializer = bufferMgr.bTreeKeySerializerFor(keyType, pack);
            if (keySerializer instanceof MapDB.KeySerializerWithComparator) {
                keySerializer = ((MapDB.KeySerializerWithComparator)keySerializer).withComparator(extractor.getType().getComparator());
            }
            buffer = bufferMgr.createSortingBuffer(keySerializer, this.rowFactory).keepSize(true).useHeap(useHeap).make();
        }
        this.buffer = buffer;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    protected long rowCount() {
        return this.buffer.size();
    }

    protected BufferedRows.BufferedRow createRow(NodeSequence.Batch currentRow) {
        return this.rowFactory.createRow(currentRow);
    }

    protected int loadAll(NodeSequence sequence, RowExtractors.ExtractFromRow extractor, BufferManager.DistinctBuffer<BufferedRows.BufferedRow> rowsWithNullKey) {
        NodeSequence.Batch batch = sequence.nextBatch();
        int batchSize = 0;
        Object value = null;
        boolean firstBatchCounted = false;
        while (batch != null) {
            while (batch.hasNext()) {
                batch.nextRow();
                value = extractor.getValueInRow(batch);
                if (value instanceof Object[]) {
                    for (Object v : (Object[])value) {
                        this.buffer.put(v, this.createRow(batch));
                    }
                } else if (value != null) {
                    this.buffer.put(value, this.createRow(batch));
                } else if (rowsWithNullKey != null) {
                    rowsWithNullKey.addIfAbsent(this.createRow(batch));
                }
                if (firstBatchCounted) continue;
                ++batchSize;
            }
            firstBatchCounted = true;
            batch = sequence.nextBatch();
        }
        return batchSize;
    }

    protected NodeSequence.Batch batchFrom(final Iterator<BufferedRows.BufferedRow> rows, long maxBatchSize) {
        if (rows == null || !rows.hasNext()) {
            return null;
        }
        if (maxBatchSize == 0L || this.remainingRowCount.get() <= 0L) {
            return NodeSequence.emptyBatch(this.workspaceName, this.width);
        }
        final long rowsInBatch = Math.min(maxBatchSize, this.remainingRowCount.get());
        this.rowsLeftInBatch.set(rowsInBatch);
        return new NodeSequence.Batch(){
            private BufferedRows.BufferedRow current;

            @Override
            public int width() {
                return BufferingSequence.this.width;
            }

            @Override
            public long rowCount() {
                return rowsInBatch;
            }

            @Override
            public String getWorkspaceName() {
                return BufferingSequence.this.workspaceName;
            }

            @Override
            public boolean isEmpty() {
                return rowsInBatch <= 0L;
            }

            @Override
            public boolean hasNext() {
                return BufferingSequence.this.rowsLeftInBatch.get() > 0L && rows.hasNext();
            }

            @Override
            public void nextRow() {
                this.current = (BufferedRows.BufferedRow)rows.next();
                BufferingSequence.this.remainingRowCount.decrementAndGet();
                BufferingSequence.this.rowsLeftInBatch.decrementAndGet();
            }

            @Override
            public CachedNode getNode() {
                return this.current.getNode();
            }

            @Override
            public CachedNode getNode(int index) {
                return this.current.getNode(index);
            }

            @Override
            public float getScore() {
                return this.current.getScore();
            }

            @Override
            public float getScore(int index) {
                return this.current.getScore(index);
            }

            public String toString() {
                return "(buffered-batch size=" + rowsInBatch + " )";
            }
        };
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.buffer.close();
        }
    }
}

