/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSingleNodeIterator;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.NodeKeyReference;

@NotThreadSafe
abstract class AbstractJcrProperty
extends AbstractJcrItem
implements org.modeshape.jcr.api.Property,
Comparable<org.modeshape.jcr.api.Property> {
    private final AbstractJcrNode node;
    private final Name name;
    private int propertyType;
    private volatile CachedDefinition cachedDefn;

    AbstractJcrProperty(AbstractJcrNode node, Name name, int propertyType) {
        super(node.session());
        assert (node != null);
        assert (name != null);
        this.node = node;
        this.name = name;
        this.propertyType = propertyType;
    }

    final void setPropertyDefinitionId(PropertyDefinitionId propDefnId, int nodeTypesVersion) {
        this.cachedDefn = new CachedDefinition(propDefnId, nodeTypesVersion);
    }

    final void releasePropertyDefinitionId() {
        this.cachedDefn = null;
    }

    final PropertyDefinitionId propertyDefinitionId() throws ItemNotFoundException, ConstraintViolationException, InvalidItemStateException {
        CachedDefinition defn = this.cachedDefn;
        NodeTypes nodeTypes = this.session.nodeTypes();
        if (defn == null || nodeTypes.getVersion() > defn.nodeTypesVersion) {
            Name primaryType = this.node.getPrimaryTypeName();
            Set<Name> mixinTypes = this.node.getMixinTypeNames();
            PropertyDefinitionId id = this.node.propertyDefinitionFor(this.property(), primaryType, mixinTypes, nodeTypes).getId();
            this.setPropertyDefinitionId(id, nodeTypes.getVersion());
            return id;
        }
        return defn.propDefnId;
    }

    final JcrPropertyDefinition propertyDefinition() throws ItemNotFoundException, ConstraintViolationException, InvalidItemStateException {
        CachedDefinition defn = this.cachedDefn;
        NodeTypes nodeTypes = this.session.nodeTypes();
        if (defn == null || nodeTypes.getVersion() > defn.nodeTypesVersion) {
            Name primaryType = this.node.getPrimaryTypeName();
            Set<Name> mixinTypes = this.node.getMixinTypeNames();
            JcrPropertyDefinition propDefn = this.node.propertyDefinitionFor(this.property(), primaryType, mixinTypes, nodeTypes);
            PropertyDefinitionId id = propDefn.getId();
            this.setPropertyDefinitionId(id, nodeTypes.getVersion());
            return propDefn;
        }
        return nodeTypes.getPropertyDefinition(defn.propDefnId);
    }

    final CachedNode cachedNode() throws ItemNotFoundException, InvalidItemStateException {
        return this.node.node();
    }

    final MutableCachedNode mutable() {
        return this.node.mutable();
    }

    final SessionCache sessionCache() {
        return this.node.sessionCache();
    }

    final PropertyFactory propertyFactory() {
        return this.node.session().propertyFactory();
    }

    final Property property() throws ItemNotFoundException, InvalidItemStateException {
        return this.cachedNode().getProperty(this.name, this.sessionCache());
    }

    final JcrValue createValue(Object value) {
        return new JcrValue(this.session().context().getValueFactories(), this.propertyType, value);
    }

    final JcrValue createValue(Object value, int propertyType) throws javax.jcr.ValueFormatException {
        try {
            return new JcrValue(this.session().context().getValueFactories(), propertyType, value);
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException((Throwable)e);
        }
    }

    public JcrSession getSession() {
        return this.node.getSession();
    }

    protected final void checkForLock() throws LockException, RepositoryException {
        Lock parentLock;
        if (this.getParent().isLockedByAnotherSession() && (parentLock = this.getParent().getLock()) != null && parentLock.getLockToken() == null) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.node.location()}));
        }
    }

    protected final void checkForCheckedOut() throws VersionException, RepositoryException {
        JcrPropertyDefinition defn;
        if (!this.node.isCheckedOut() && (defn = this.getDefinition()).getOnParentVersion() != 5) {
            String path = this.getParent().getPath();
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{path}));
        }
    }

    protected final void checkModifyPermission() throws AccessDeniedException {
        this.session.checkPermission(this.node, "set_property");
    }

    public final void accept(ItemVisitor visitor) throws RepositoryException {
        CheckArg.isNotNull((Object)visitor, (String)"visitor");
        this.checkSession();
        visitor.visit((javax.jcr.Property)this);
    }

    final Name name() {
        return this.name;
    }

    @Override
    Path path() throws RepositoryException {
        return this.session().pathFactory().create(this.node.path(), this.name);
    }

    public int getType() throws RepositoryException {
        this.checkSession();
        return this.propertyType;
    }

    public final JcrPropertyDefinition getDefinition() throws RepositoryException {
        this.checkSession();
        return this.propertyDefinition();
    }

    public final String getName() {
        return this.name.getString(this.namespaces());
    }

    @Override
    public final AbstractJcrNode getParent() {
        return this.node;
    }

    public final String getPath() throws RepositoryException {
        return this.path().getString(this.namespaces());
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public String getNamespaceURI() {
        return this.name.getNamespaceUri();
    }

    public final boolean isModified() {
        try {
            this.checkSession();
            CachedNode node = this.cachedNode();
            return node instanceof MutableCachedNode && ((MutableCachedNode)node).isPropertyModified(this.sessionCache(), this.name);
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final boolean isNew() {
        try {
            this.checkSession();
            CachedNode node = this.cachedNode();
            return node instanceof MutableCachedNode && ((MutableCachedNode)node).isPropertyNew(this.sessionCache(), this.name);
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final boolean isNode() {
        return false;
    }

    public final boolean isSame(Item otherItem) throws RepositoryException {
        this.checkSession();
        if (otherItem instanceof javax.jcr.Property) {
            javax.jcr.Property otherProperty = (javax.jcr.Property)otherItem;
            if (!this.getParent().isSame((Item)otherProperty.getParent())) {
                return false;
            }
            return this.getName().equals(otherProperty.getName());
        }
        return false;
    }

    public void refresh(boolean keepChanges) {
        throw new UnsupportedOperationException();
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        Lock parentLock;
        this.checkSession();
        this.checkNotProtected();
        this.checkForLock();
        this.checkForCheckedOut();
        this.session.checkPermission(this, "remove");
        AbstractJcrNode parentNode = this.getParent();
        if (parentNode.isLockedByAnotherSession() && (parentLock = parentNode.getLock()) != null && !parentLock.isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.getPath()}));
        }
        if (!parentNode.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{this.getPath()}));
        }
        this.node.removeProperty(this);
    }

    private void checkNotProtected() throws RepositoryException {
        if (this.getDefinition().isProtected()) {
            throw new ConstraintViolationException(JcrI18n.propertyIsProtected.text(new Object[]{this.getPath()}));
        }
    }

    public abstract JcrValue[] getValues() throws javax.jcr.ValueFormatException, RepositoryException;

    public abstract JcrValue getValue() throws javax.jcr.ValueFormatException, RepositoryException;

    public void save() throws RepositoryException {
        this.checkSession();
        this.getParent().save();
    }

    @Override
    public int compareTo(org.modeshape.jcr.api.Property that) {
        if (that == this) {
            return 0;
        }
        try {
            return this.getName().compareTo(that.getName());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected Node valueToNode(Object value) throws RepositoryException {
        ValueFactories factories = this.context().getValueFactories();
        try {
            String valueString;
            if (value instanceof Reference) {
                NodeKey key = null;
                if (!(value instanceof NodeKeyReference)) {
                    throw new IllegalArgumentException("Unknown reference type: " + value.getClass().getSimpleName());
                }
                key = ((NodeKeyReference)value).getNodeKey();
                return this.session().node(key, null);
            }
            if (value instanceof String && NodeKey.isValidFormat(valueString = (String)value)) {
                return this.session().node(new NodeKey(valueString), null);
            }
            Path path = (Path)factories.getPathFactory().create(value);
            return path.isAbsolute() ? this.session().node(path) : this.session().node(this.getParent().node(), path);
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
        catch (PathNotFoundException pathNotFound) {
            throw new ItemNotFoundException(pathNotFound.getMessage(), (Throwable)pathNotFound);
        }
    }

    public String toString() {
        StringFactory stringFactory = this.session().context().getValueFactories().getStringFactory();
        StringBuilder sb = new StringBuilder();
        try {
            Property property = this.cachedNode().getProperty(this.name, this.sessionCache());
            sb.append(this.getName()).append('=');
            if (this.isMultiple()) {
                sb.append('[');
                Iterator iter = property.iterator();
                while (iter.hasNext()) {
                    Object value = iter.next();
                    this.appendValueToString(stringFactory, sb, value);
                    if (!iter.hasNext()) continue;
                    sb.append(',');
                }
                sb.append(']');
            } else {
                Object value = property.getFirstValue();
                this.appendValueToString(stringFactory, sb, value);
            }
        }
        catch (RepositoryException e) {
            sb.append(" on deleted node ").append(this.node.key());
        }
        return sb.toString();
    }

    private void appendValueToString(ValueFactory<String> stringFactory, StringBuilder sb, Object value) {
        if (value instanceof Binary) {
            sb.append("**binary-value-not-shown**");
        } else {
            sb.append(stringFactory.create(value));
        }
    }

    public <T> T getAs(Class<T> type, int index) throws IndexOutOfBoundsException, javax.jcr.ValueFormatException, RepositoryException {
        Object convertedValue;
        block14: {
            this.checkSession();
            Object value = this.property().getValue(index);
            convertedValue = null;
            try {
                if (String.class.equals(type)) {
                    convertedValue = this.context().getValueFactories().getStringFactory().create(value);
                    break block14;
                }
                if (Long.class.equals(type)) {
                    convertedValue = this.context().getValueFactories().getLongFactory().create(value);
                    break block14;
                }
                if (Boolean.class.equals(type)) {
                    convertedValue = this.context().getValueFactories().getBooleanFactory().create(value);
                    break block14;
                }
                if (Date.class.equals(type)) {
                    Calendar calendar = ((DateTime)this.context().getValueFactories().getDateFactory().create(value)).toCalendar();
                    convertedValue = calendar.getTime();
                    break block14;
                }
                if (Calendar.class.equals(type)) {
                    convertedValue = ((DateTime)this.context().getValueFactories().getDateFactory().create(value)).toCalendar();
                    break block14;
                }
                if (DateTime.class.equals(type)) {
                    convertedValue = this.context().getValueFactories().getDateFactory().create(value);
                    break block14;
                }
                if (Double.class.equals(type)) {
                    convertedValue = this.context().getValueFactories().getDoubleFactory().create(value);
                    break block14;
                }
                if (BigDecimal.class.equals(type)) {
                    convertedValue = this.context().getValueFactories().getDecimalFactory().create(value);
                    break block14;
                }
                if (InputStream.class.equals(type)) {
                    BinaryValue binary = (BinaryValue)this.context().getValueFactories().getBinaryFactory().create(value);
                    convertedValue = binary.getStream();
                    break block14;
                }
                if (Binary.class.isAssignableFrom(type)) {
                    convertedValue = this.context().getValueFactories().getBinaryFactory().create(value);
                    break block14;
                }
                if (Node.class.equals(type)) {
                    convertedValue = this.valueToNode(value);
                    break block14;
                }
                if (NodeIterator.class.equals(type)) {
                    convertedValue = new JcrSingleNodeIterator((AbstractJcrNode)this.getNode());
                    break block14;
                }
                throw new javax.jcr.ValueFormatException(JcrI18n.unableToConvertPropertyValueAtIndexToType.text(new Object[]{this.getPath(), index, type}));
            }
            catch (ValueFormatException e) {
                throw new javax.jcr.ValueFormatException((Throwable)e);
            }
        }
        return type.cast(convertedValue);
    }

    @Immutable
    private static final class CachedDefinition {
        protected final PropertyDefinitionId propDefnId;
        protected final int nodeTypesVersion;

        protected CachedDefinition(PropertyDefinitionId propDefnId, int nodeTypesVersion) {
            this.propDefnId = propDefnId;
            this.nodeTypesVersion = nodeTypesVersion;
        }
    }
}

