/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.LanguageObject;
import org.modeshape.jcr.query.model.NullOrder;
import org.modeshape.jcr.query.model.Order;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class Ordering
implements LanguageObject,
org.modeshape.jcr.api.query.qom.Ordering {
    private static final long serialVersionUID = 1L;
    private final DynamicOperand operand;
    private final Order order;
    private final NullOrder nullOrder;

    public Ordering(DynamicOperand operand, Order order, NullOrder nullOrder) {
        CheckArg.isNotNull((Object)operand, (String)"operand");
        CheckArg.isNotNull((Object)order, (String)"order");
        CheckArg.isNotNull((Object)nullOrder, (String)"nullOrder");
        this.operand = operand;
        this.order = order;
        this.nullOrder = nullOrder;
    }

    public DynamicOperand getOperand() {
        return this.operand;
    }

    public Order order() {
        return this.order;
    }

    public NullOrder nullOrder() {
        return this.nullOrder;
    }

    public boolean isDefaultNullOrder() {
        return NullOrder.defaultOrder(this.order) == this.nullOrder;
    }

    public String getOrder() {
        switch (this.order()) {
            case ASCENDING: {
                return "jcr.order.ascending";
            }
            case DESCENDING: {
                return "jcr.order.descending";
            }
        }
        assert (false);
        return null;
    }

    public String getNullOrder() {
        switch (this.nullOrder()) {
            case NULLS_FIRST: {
                return "jcr.order.nulls.first";
            }
            case NULLS_LAST: {
                return "jcr.order.nulls.last";
            }
        }
        assert (false);
        return null;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.operand.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Ordering) {
            Ordering that = (Ordering)obj;
            if (this.order != that.order) {
                return false;
            }
            return this.operand.equals(that.operand);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

