/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.kotlin;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u0000 0*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u00010B#\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c2\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0004H\u00c2\u0003J7\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0004H\u00c6\u0001J\u001d\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0016J\t\u0010(\u001a\u00020\u000eH\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001J)\u0010+\u001a\u00028\u00002\u001a\u0010,\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u00010-j\n\u0012\u0006\u0012\u0004\u0018\u00018\u0001`.H\u0002\u00a2\u0006\u0002\u0010/R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/bson/codecs/kotlin/ArrayCodec;", "R", "", "V", "Lorg/bson/codecs/Codec;", "kClass", "Lkotlin/reflect/KClass;", "codec", "(Lkotlin/reflect/KClass;Lorg/bson/codecs/Codec;)V", "isPrimitiveArray", "", "arrayOfNulls", "", "size", "", "(I)[Ljava/lang/Object;", "boxed", "", "arrayValue", "(Ljava/lang/Object;)Ljava/lang/Iterable;", "component1", "component2", "copy", "decode", "reader", "Lorg/bson/BsonReader;", "decoderContext", "Lorg/bson/codecs/DecoderContext;", "(Lorg/bson/BsonReader;Lorg/bson/codecs/DecoderContext;)Ljava/lang/Object;", "encode", "", "writer", "Lorg/bson/BsonWriter;", "encoderContext", "Lorg/bson/codecs/EncoderContext;", "(Lorg/bson/BsonWriter;Ljava/lang/Object;Lorg/bson/codecs/EncoderContext;)V", "equals", "other", "getEncoderClass", "Ljava/lang/Class;", "hashCode", "toString", "", "unboxed", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "(Ljava/util/ArrayList;)Ljava/lang/Object;", "Companion", "bson-kotlin"})
@SourceDebugExtension(value={"SMAP\nArrayCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayCodec.kt\norg/bson/codecs/kotlin/ArrayCodec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1855#2,2:130\n*S KotlinDebug\n*F\n+ 1 ArrayCodec.kt\norg/bson/codecs/kotlin/ArrayCodec\n*L\n61#1:130,2\n*E\n"})
public final class ArrayCodec<R, V>
implements Codec<R> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<R> kClass;
    @NotNull
    private final Codec<V> codec;
    private final boolean isPrimitiveArray;

    public ArrayCodec(@NotNull KClass<R> kClass, @NotNull Codec<V> codec) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        this.kClass = kClass;
        this.codec = codec;
        Class<?> clazz = JvmClassMappingKt.getJavaClass(this.kClass).getComponentType();
        Class<?> clazz2 = JvmClassMappingKt.getJavaClass(this.kClass).getComponentType();
        Intrinsics.checkNotNullExpressionValue(clazz2, (String)"kClass.java.componentType");
        this.isPrimitiveArray = !Intrinsics.areEqual(clazz, (Object)JvmClassMappingKt.getJavaObjectType((KClass)JvmClassMappingKt.getKotlinClass(clazz2)));
    }

    public void encode(@NotNull BsonWriter writer, @NotNull R arrayValue, @NotNull EncoderContext encoderContext) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(arrayValue, (String)"arrayValue");
        Intrinsics.checkNotNullParameter((Object)encoderContext, (String)"encoderContext");
        writer.writeStartArray();
        Iterable<V> $this$forEach$iv = this.boxed(arrayValue);
        boolean $i$f$forEach = false;
        Iterator<V> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            V element$iv;
            V it = element$iv = iterator.next();
            boolean bl = false;
            if (it == null) {
                writer.writeNull();
                continue;
            }
            encoderContext.encodeWithChildContext((Encoder)this.codec, writer, it);
        }
        writer.writeEndArray();
    }

    @NotNull
    public Class<R> getEncoderClass() {
        return JvmClassMappingKt.getJavaClass(this.kClass);
    }

    @NotNull
    public R decode(@NotNull BsonReader reader, @NotNull DecoderContext decoderContext) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)decoderContext, (String)"decoderContext");
        reader.readStartArray();
        ArrayList<Object> data = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                data.add(null);
                continue;
            }
            data.add(decoderContext.decodeWithChildContext((Decoder)this.codec, reader));
        }
        reader.readEndArray();
        return this.unboxed(data);
    }

    @NotNull
    public final Iterable<V> boxed(@NotNull R arrayValue) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(arrayValue, (String)"arrayValue");
        if (!this.isPrimitiveArray) {
            iterable = ArraysKt.asIterable((Object[])((Object[])arrayValue));
        } else if (arrayValue instanceof boolean[]) {
            iterable = ArraysKt.asIterable((boolean[])((boolean[])arrayValue));
        } else if (arrayValue instanceof byte[]) {
            iterable = ArraysKt.asIterable((byte[])((byte[])arrayValue));
        } else if (arrayValue instanceof char[]) {
            iterable = ArraysKt.asIterable((char[])((char[])arrayValue));
        } else if (arrayValue instanceof double[]) {
            iterable = ArraysKt.asIterable((double[])((double[])arrayValue));
        } else if (arrayValue instanceof float[]) {
            iterable = ArraysKt.asIterable((float[])((float[])arrayValue));
        } else if (arrayValue instanceof int[]) {
            iterable = ArraysKt.asIterable((int[])((int[])arrayValue));
        } else if (arrayValue instanceof long[]) {
            iterable = ArraysKt.asIterable((long[])((long[])arrayValue));
        } else if (arrayValue instanceof short[]) {
            iterable = ArraysKt.asIterable((short[])((short[])arrayValue));
        } else {
            throw new IllegalArgumentException("Unsupported array type " + arrayValue.getClass());
        }
        Iterable boxedValue = iterable;
        Intrinsics.checkNotNull((Object)boxedValue, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<V of org.bson.codecs.kotlin.ArrayCodec?>");
        return boxedValue;
    }

    private final R unboxed(ArrayList<V> data) {
        Object object;
        KClass<R> kClass = this.kClass;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(boolean[].class))) {
            Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Boolean>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Boolean> }");
            boolean[] blArray = CollectionsKt.toBooleanArray((Collection)data);
            Intrinsics.checkNotNull((Object)blArray, (String)"null cannot be cast to non-null type R of org.bson.codecs.kotlin.ArrayCodec");
            object = blArray;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
            Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Byte>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Byte> }");
            byte[] byArray = CollectionsKt.toByteArray((Collection)data);
            Intrinsics.checkNotNull((Object)byArray, (String)"null cannot be cast to non-null type R of org.bson.codecs.kotlin.ArrayCodec");
            object = byArray;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(char[].class))) {
            Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Char>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Char> }");
            char[] cArray = CollectionsKt.toCharArray((Collection)data);
            Intrinsics.checkNotNull((Object)cArray, (String)"null cannot be cast to non-null type R of org.bson.codecs.kotlin.ArrayCodec");
            object = cArray;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(double[].class))) {
            Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Double>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Double> }");
            double[] dArray = CollectionsKt.toDoubleArray((Collection)data);
            Intrinsics.checkNotNull((Object)dArray, (String)"null cannot be cast to non-null type R of org.bson.codecs.kotlin.ArrayCodec");
            object = dArray;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(float[].class))) {
            Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Float>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Float> }");
            float[] fArray = CollectionsKt.toFloatArray((Collection)data);
            Intrinsics.checkNotNull((Object)fArray, (String)"null cannot be cast to non-null type R of org.bson.codecs.kotlin.ArrayCodec");
            object = fArray;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(int[].class))) {
            Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Int>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Int> }");
            int[] nArray = CollectionsKt.toIntArray((Collection)data);
            Intrinsics.checkNotNull((Object)nArray, (String)"null cannot be cast to non-null type R of org.bson.codecs.kotlin.ArrayCodec");
            object = nArray;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(long[].class))) {
            Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Long>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Long> }");
            long[] lArray = CollectionsKt.toLongArray((Collection)data);
            Intrinsics.checkNotNull((Object)lArray, (String)"null cannot be cast to non-null type R of org.bson.codecs.kotlin.ArrayCodec");
            object = lArray;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(short[].class))) {
            Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Short>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Short> }");
            short[] sArray = CollectionsKt.toShortArray((Collection)data);
            Intrinsics.checkNotNull((Object)sArray, (String)"null cannot be cast to non-null type R of org.bson.codecs.kotlin.ArrayCodec");
            object = sArray;
        } else {
            V[] VArray = data.toArray(this.arrayOfNulls(data.size()));
            Intrinsics.checkNotNull(VArray, (String)"null cannot be cast to non-null type R of org.bson.codecs.kotlin.ArrayCodec");
            object = VArray;
        }
        return (R)object;
    }

    private final V[] arrayOfNulls(int size) {
        Object object = Array.newInstance(this.codec.getEncoderClass(), size);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<V of org.bson.codecs.kotlin.ArrayCodec?>");
        return (Object[])object;
    }

    private final KClass<R> component1() {
        return this.kClass;
    }

    private final Codec<V> component2() {
        return this.codec;
    }

    @NotNull
    public final ArrayCodec<R, V> copy(@NotNull KClass<R> kClass, @NotNull Codec<V> codec) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        return new ArrayCodec<R, V>(kClass, codec);
    }

    public static /* synthetic */ ArrayCodec copy$default(ArrayCodec arrayCodec, KClass kClass, Codec codec, int n, Object object) {
        if ((n & 1) != 0) {
            kClass = arrayCodec.kClass;
        }
        if ((n & 2) != 0) {
            codec = arrayCodec.codec;
        }
        return arrayCodec.copy(kClass, codec);
    }

    @NotNull
    public String toString() {
        return "ArrayCodec(kClass=" + this.kClass + ", codec=" + this.codec + ')';
    }

    public int hashCode() {
        int result = this.kClass.hashCode();
        result = result * 31 + this.codec.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArrayCodec)) {
            return false;
        }
        ArrayCodec arrayCodec = (ArrayCodec)other;
        if (!Intrinsics.areEqual(this.kClass, arrayCodec.kClass)) {
            return false;
        }
        return Intrinsics.areEqual(this.codec, arrayCodec.codec);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0002\u0010\u0005*\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/bson/codecs/kotlin/ArrayCodec$Companion;", "", "()V", "create", "Lorg/bson/codecs/Codec;", "R", "kClass", "Lkotlin/reflect/KClass;", "typeArguments", "", "Ljava/lang/reflect/Type;", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "create$bson_kotlin", "bson-kotlin"})
    @SourceDebugExtension(value={"SMAP\nArrayCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayCodec.kt\norg/bson/codecs/kotlin/ArrayCodec$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <R> Codec<R> create$bson_kotlin(@NotNull KClass<R> kClass, @NotNull List<? extends Type> typeArguments, @NotNull CodecRegistry codecRegistry) {
            Pair pair;
            Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
            Intrinsics.checkNotNullParameter(typeArguments, (String)"typeArguments");
            Intrinsics.checkNotNullParameter((Object)codecRegistry, (String)"codecRegistry");
            boolean bl = JvmClassMappingKt.getJavaObjectType(kClass).isArray();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ArrayCodec$Companion$create$22 = false;
                String $i$a$-assert-ArrayCodec$Companion$create$22 = kClass + " must be an array type";
                throw new AssertionError((Object)$i$a$-assert-ArrayCodec$Companion$create$22);
            }
            if (typeArguments.isEmpty()) {
                Class<?> clazz = JvmClassMappingKt.getJavaClass(kClass).getComponentType();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"kClass.java.componentType");
                Class clazz2 = JvmClassMappingKt.getJavaObjectType((KClass)JvmClassMappingKt.getKotlinClass(clazz));
                Intrinsics.checkNotNull((Object)clazz2, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
                pair = new Pair((Object)clazz2, (Object)CollectionsKt.emptyList());
            } else {
                Type pType = typeArguments.get(0);
                if (pType instanceof Class) {
                    pair = new Pair((Object)((Class)pType), (Object)CollectionsKt.emptyList());
                } else if (pType instanceof ParameterizedType) {
                    Type type = ((ParameterizedType)pType).getRawType();
                    Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
                    Class clazz = (Class)type;
                    Type[] typeArray = ((ParameterizedType)pType).getActualTypeArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"pType.actualTypeArguments");
                    pair = new Pair((Object)clazz, (Object)ArraysKt.toList((Object[])typeArray));
                } else {
                    pair = new Pair(Object.class, (Object)CollectionsKt.emptyList());
                }
            }
            Pair pair2 = pair;
            Class valueClass = (Class)pair2.component1();
            List nestedTypes = (List)pair2.component2();
            Codec codec = nestedTypes.isEmpty() ? codecRegistry.get(valueClass) : codecRegistry.get(valueClass, nestedTypes);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"codec");
            return new ArrayCodec(kClass, codec);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

