/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBMessage;
import com.mongodb.DBPortPool;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.util.ThreadUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBPort {
    public static final int PORT = 27017;
    static final boolean USE_NAGLE = false;
    static final long CONN_RETRY_TIME_MS = 15000L;
    final int _hashCode;
    final InetSocketAddress _addr;
    final DBPortPool _pool;
    final MongoOptions _options;
    final Logger _logger;
    private final ByteBuffer[] _array = new ByteBuffer[]{ByteBuffer.wrap(new byte[DBMessage.HEADER_LENGTH]), null};
    private SocketChannel _sock;
    private Socket _socket;
    private InputStream _in;
    private boolean _inauth = false;
    private Map<DB, Boolean> _authed = Collections.synchronizedMap(new WeakHashMap());
    private static Logger _rootLogger = Logger.getLogger("com.mongodb.port");

    public DBPort(InetSocketAddress addr) throws IOException {
        this(addr, null, new MongoOptions());
    }

    DBPort(InetSocketAddress addr, DBPortPool pool, MongoOptions options) throws IOException {
        this._options = options;
        this._addr = addr;
        this._pool = pool;
        this._array[0].order(Bytes.ORDER);
        this._hashCode = this._addr.hashCode();
        this._logger = Logger.getLogger(_rootLogger.getName() + "." + addr.toString());
    }

    DBMessage call(DBMessage msg, ByteBuffer response) throws IOException {
        return this.go(msg, response);
    }

    void say(DBMessage msg) throws IOException {
        this.go(msg, null);
    }

    private synchronized DBMessage go(DBMessage msg, ByteBuffer response) throws IOException {
        if (this._sock == null) {
            this._open();
        }
        this._reset(this._array[0]);
        msg.putHeader(this._array[0]);
        this._array[0].flip();
        this._array[1] = msg.getData();
        this._sock.write(this._array);
        if (this._pool != null) {
            this._pool._everWorked = true;
        }
        if (response == null) {
            return null;
        }
        this._reset(this._array[0]);
        this._read(this._array[0]);
        this._array[0].flip();
        DBMessage msgResponse = new DBMessage(this._array[0], response);
        this._reset(response);
        if (msgResponse._len <= DBMessage.HEADER_LENGTH) {
            throw new IllegalArgumentException("db sent invalid length : " + msgResponse._len);
        }
        int bodySize = msgResponse._len - DBMessage.HEADER_LENGTH;
        if (bodySize > response.capacity()) {
            throw new IllegalArgumentException("db message size is too big (" + bodySize + ") max is (" + response.capacity() + ")");
        }
        response.limit(bodySize);
        while (response.remaining() > 0) {
            this._read(response);
        }
        if (response.position() < response.limit()) {
            throw new MongoInternalException("buffer not fully filled");
        }
        return msgResponse;
    }

    void _reset(ByteBuffer buf) {
        buf.position(0);
        buf.limit(buf.capacity());
    }

    public void ensureOpen() throws IOException {
        if (this._sock != null) {
            return;
        }
        this._open();
    }

    void _open() throws IOException {
        long sleepTime = 100L;
        long start = System.currentTimeMillis();
        while (true) {
            IOException lastError = null;
            try {
                this._sock = SocketChannel.open();
                this._socket = this._sock.socket();
                this._socket.connect(this._addr, this._options.connectTimeout);
                this._socket.setTcpNoDelay(true);
                this._socket.setSoTimeout(this._options.socketTimeout);
                this._in = this._socket.getInputStream();
                return;
            }
            catch (IOException ioe) {
                lastError = new IOException("couldn't connect to [" + this._addr + "] bc:" + ioe);
                this._logger.log(Level.INFO, "connect fail to : " + this._addr, ioe);
                if (!this._options.autoConnectRetry || this._pool != null && !this._pool._everWorked) {
                    throw lastError;
                }
                long sleptSoFar = System.currentTimeMillis() - start;
                if (sleptSoFar >= 15000L) {
                    throw lastError;
                }
                if (sleepTime + sleptSoFar > 15000L) {
                    sleepTime = 15000L - sleptSoFar;
                }
                this._logger.severe("going to sleep and retry.  total sleep time after = " + (sleptSoFar + sleptSoFar) + "ms  this time:" + sleepTime + "ms");
                ThreadUtil.sleep(sleepTime);
                sleepTime *= 2L;
                continue;
            }
            break;
        }
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String host() {
        return this._addr.toString();
    }

    public String toString() {
        return "{DBPort  " + this.host() + "}";
    }

    protected void finalize() {
        if (this._sock != null) {
            try {
                this._sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._in = null;
            this._socket = null;
            this._sock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAuth(DB db) {
        if (db._username == null) {
            return;
        }
        if (this._authed.containsKey(db)) {
            return;
        }
        if (this._inauth) {
            return;
        }
        this._inauth = true;
        try {
            if (db.reauth()) {
                this._authed.put(db, true);
                return;
            }
        }
        finally {
            this._inauth = false;
        }
        throw new MongoInternalException("can't reauth!");
    }

    private void _read(ByteBuffer buf) throws IOException {
        int x = this._in.read(buf.array(), buf.position(), buf.remaining());
        buf.position(buf.position() + x);
    }
}

