/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBAddress;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBMessage;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.DBPortPool;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.RawDBObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBTCPConnector
implements DBConnector {
    static Logger _logger = Logger.getLogger(Bytes.LOGGER.getName() + ".tcp");
    static Logger _createLogger = Logger.getLogger(_logger.getName() + ".connect");
    final Mongo _mongo;
    private DBAddress _curAddress;
    private DBPortPool _curPortPool;
    private DBPortPool.Holder _portHolder;
    private final List<DBAddress> _allHosts;
    private final ThreadLocal<MyPort> _threadPort = new ThreadLocal<MyPort>(){

        @Override
        protected MyPort initialValue() {
            return new MyPort();
        }
    };
    private static final DBObject _isMaster = BasicDBObjectBuilder.start().add("ismaster", 1).get();

    public DBTCPConnector(Mongo m, DBAddress addr) throws MongoException {
        this._mongo = m;
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(addr);
        _createLogger.info(addr.toString());
        if (addr.isPaired()) {
            this._allHosts = new ArrayList<DBAddress>(addr.getPairedAddresses());
            this._validatePairs(this._allHosts);
            _createLogger.info("switch to paired mode : " + this._allHosts + " -> " + this._curAddress);
        } else {
            this._set(addr);
            this._allHosts = null;
        }
    }

    public DBTCPConnector(Mongo m, DBAddress ... all) throws MongoException {
        this(m, Arrays.asList(all));
    }

    public DBTCPConnector(Mongo m, List<DBAddress> all) throws MongoException {
        this._mongo = m;
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(all);
        this._validatePairs(all);
        this._allHosts = new ArrayList<DBAddress>(all);
        _createLogger.info(all + " -> " + this._curAddress);
    }

    private void _validatePairs(List<DBAddress> all) {
        String name = all.get((int)0)._name;
        for (int i = 1; i < all.size(); ++i) {
            if (all.get((int)i)._name.equals(name)) continue;
            throw new IllegalArgumentException(" names don't match [" + all.get((int)i)._name + "] != [" + name + "]");
        }
    }

    private static DBAddress _checkAddress(DBAddress addr) {
        if (addr == null) {
            throw new NullPointerException("address can't be null");
        }
        return addr;
    }

    private static DBAddress _checkAddress(List<DBAddress> addrs) {
        if (addrs == null) {
            throw new NullPointerException("addresses can't be null");
        }
        if (addrs.size() == 0) {
            throw new IllegalArgumentException("need to specify at least 1 address");
        }
        return addrs.get(0);
    }

    public void requestStart() {
        this._threadPort.get().requestStart();
    }

    public void requestDone() {
        this._threadPort.get().requestDone();
    }

    public void requestEnsureConnection() {
        this._threadPort.get().requestEnsureConnection();
    }

    @Override
    public void say(DB db, int op, ByteBuffer buf, DB.WriteConcern concern) throws MongoException {
        MyPort mp = this._threadPort.get();
        DBPort port = mp.get(true);
        port.checkAuth(db);
        try {
            DBObject e;
            Object foo;
            port.say(new DBMessage(op, buf));
            if (concern == DB.WriteConcern.STRICT && (foo = (e = this._mongo.getDB("admin").getLastError()).get("err")) != null) {
                int code = -1;
                if (e.get("code") instanceof Number) {
                    code = ((Number)e.get("code")).intValue();
                }
                String s = foo.toString();
                if (code == 11000 || code == 11001 || s.startsWith("E11000") || s.startsWith("E11001")) {
                    throw new MongoException.DuplicateKey(code, s);
                }
                throw new MongoException(code, s);
            }
            mp.done(port);
        }
        catch (IOException ioe) {
            mp.error(ioe);
            this._error();
            if (concern == DB.WriteConcern.NONE) {
                return;
            }
            throw new MongoException.Network("can't say something", ioe);
        }
    }

    @Override
    public int call(DB db, int op, ByteBuffer out, ByteBuffer in) throws MongoException {
        return this._call(db, op, out, in, 2);
    }

    private int _call(DB db, int op, ByteBuffer out, ByteBuffer in, int retries) throws MongoException {
        MyPort mp = this._threadPort.get();
        DBPort port = mp.get(false);
        port.checkAuth(db);
        try {
            DBMessage a = new DBMessage(op, out);
            DBMessage b = port.call(a, in);
            mp.done(port);
            String err = this._getError(in);
            if (err != null && "not master".equals(err)) {
                this._pickCurrent();
                if (retries <= 0) {
                    throw new MongoException("not talking to master and retries used up");
                }
                in.position(0);
                return this._call(db, op, out, in, retries - 1);
            }
            return b.dataLen();
        }
        catch (IOException ioe) {
            mp.error(ioe);
            if (this._error() && retries > 0) {
                in.position(0);
                return this._call(db, op, out, in, retries - 1);
            }
            throw new MongoException.Network("can't call something", ioe);
        }
    }

    public DBAddress getAddress() {
        return this._curAddress;
    }

    public String getConnectPoint() {
        return this._curAddress.toString();
    }

    boolean _error() throws MongoException {
        if (this._allHosts != null) {
            this._pickCurrent();
        }
        return true;
    }

    String _getError(ByteBuffer buf) {
        DBApiLayer.QueryHeader header = new DBApiLayer.QueryHeader(buf, 0);
        if (header._num != 1) {
            return null;
        }
        RawDBObject obj = new RawDBObject(buf, header.headerSize());
        Object err = obj.get("$err");
        if (err == null) {
            return null;
        }
        return err.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _pickInitial() throws MongoException {
        if (this._curAddress != null) {
            return;
        }
        this._pickCurrent();
        try {
            System.out.println(this._curAddress);
            DBCollection collection = this._mongo.getDB("admin").getCollection("$cmd");
            Iterator<DBObject> i = collection.find(_isMaster, null, 0, 1, 0);
            if (i == null || !i.hasNext()) {
                throw new MongoException("no result for ismaster query?");
            }
            DBObject res = i.next();
            if (i.hasNext()) {
                throw new MongoException("what's going on");
            }
            int ismaster = ((Number)res.get("ismaster")).intValue();
            if (1 == ismaster) {
                return;
            }
            if (res.get("remote") == null) {
                throw new MongoException("remote not sent back!");
            }
            String remote = res.get("remote").toString();
            List<DBAddress> list = this._allHosts;
            synchronized (list) {
                for (DBAddress a : this._allHosts) {
                    if (!a.sameHost(remote)) continue;
                    System.out.println("remote [" + remote + "] -> [" + a + "]");
                    this._set(a);
                    return;
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "can't pick initial master, using random one", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _pickCurrent() throws MongoException {
        if (this._allHosts == null) {
            throw new MongoException("got master/slave issue but not in master/slave mode on the client side");
        }
        List<DBAddress> list = this._allHosts;
        synchronized (list) {
            Collections.shuffle(this._allHosts);
            for (int i = 0; i < this._allHosts.size(); ++i) {
                DBAddress a = this._allHosts.get(i);
                if (a == this._curAddress) continue;
                if (this._curAddress != null) {
                    _logger.info("switching from [" + this._curAddress + "] to [" + a + "]");
                }
                this._set(a);
                return;
            }
        }
        throw new MongoException("couldn't find a new host to swtich too");
    }

    private boolean _set(DBAddress addr) {
        if (this._curAddress == addr) {
            return false;
        }
        this._curAddress = addr;
        this._curPortPool = this._portHolder.get(this._curAddress.getSocketAddress());
        return true;
    }

    public String debugString() {
        StringBuilder buf = new StringBuilder("DBTCPConnector: ");
        if (this._allHosts != null) {
            buf.append("paired : ").append(this._allHosts);
        } else {
            buf.append(this._curAddress).append(" ").append(this._curAddress._addr);
        }
        return buf.toString();
    }

    class MyPort {
        int _internalStack = 0;
        DBPort _port;
        DBPort _last;
        boolean _inRequest;

        MyPort() {
        }

        DBPort get(boolean keep) {
            ++this._internalStack;
            if (this._internalStack > 1) {
                if (this._last == null) {
                    System.err.println("_internalStack > 1 and _last is null!");
                } else {
                    return this._last;
                }
            }
            if (this._port != null) {
                return this._port;
            }
            DBPort p = DBTCPConnector.this._curPortPool.get();
            if (keep && this._inRequest) {
                this._port = p;
            }
            this._last = p;
            return p;
        }

        void done(DBPort p) {
            --this._internalStack;
            if (p != this._port && this._internalStack <= 0) {
                DBTCPConnector.this._curPortPool.done(p);
            }
            if (this._internalStack < 0) {
                System.err.println("_internalStack < 0 : " + this._internalStack);
                this._internalStack = 0;
            }
        }

        void error(Exception e) {
            this._port = null;
            DBTCPConnector.this._curPortPool.gotError(e);
            this._internalStack = 0;
            this._last = null;
        }

        void requestEnsureConnection() {
            if (!this._inRequest) {
                return;
            }
            if (this._port != null) {
                return;
            }
            this._port = DBTCPConnector.this._curPortPool.get();
        }

        void requestStart() {
            this._inRequest = true;
            if (this._port != null) {
                this._port = null;
                System.err.println("ERROR.  somehow _port was not null at requestStart");
            }
        }

        void requestDone() {
            if (this._port != null) {
                DBTCPConnector.this._curPortPool.done(this._port);
            }
            this._port = null;
            this._inRequest = false;
            if (this._internalStack > 0) {
                System.err.println("_internalStack in requestDone should be 0");
                this._internalStack = 0;
            }
        }
    }
}

