/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BulkWriteRequestBuilder;
import com.mongodb.BulkWriteResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.InsertRequest;
import com.mongodb.WriteConcern;
import com.mongodb.WriteRequest;
import java.util.ArrayList;
import java.util.List;

public class BulkWriteOperation {
    private final boolean ordered;
    private final DBCollection collection;
    private final List<WriteRequest> requests = new ArrayList<WriteRequest>();

    BulkWriteOperation(boolean ordered, DBCollection collection) {
        this.ordered = ordered;
        this.collection = collection;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void insert(DBObject document) {
        this.addRequest(new InsertRequest(document));
    }

    public BulkWriteRequestBuilder find(DBObject query) {
        return new BulkWriteRequestBuilder(this, query);
    }

    public BulkWriteResult execute() {
        return this.collection.executeBulkWriteOperation(this.ordered, this.requests);
    }

    public BulkWriteResult execute(WriteConcern writeConcern) {
        return this.collection.executeBulkWriteOperation(this.ordered, this.requests, writeConcern);
    }

    void addRequest(WriteRequest request) {
        this.requests.add(request);
    }
}

