/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBPort;
import com.mongodb.DBPortPool;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.OutMessage;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.ServerError;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBTCPConnector
implements DBConnector {
    static Logger _logger = Logger.getLogger(Bytes.LOGGER.getName() + ".tcp");
    static Logger _createLogger = Logger.getLogger(_logger.getName() + ".connect");
    final Mongo _mongo;
    private ServerAddress _curMaster;
    private DBPortPool _curPortPool;
    private DBPortPool.Holder _portHolder;
    private final List<ServerAddress> _allHosts;
    private final ReplicaSetStatus _rsStatus;
    private boolean _closed = false;
    private final ThreadLocal<MyPort> _myPort = new ThreadLocal<MyPort>(){

        @Override
        protected MyPort initialValue() {
            return new MyPort();
        }
    };

    public DBTCPConnector(Mongo m, ServerAddress addr) throws MongoException {
        this._mongo = m;
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(addr);
        _createLogger.info(addr.toString());
        if (addr.isPaired()) {
            this._allHosts = new ArrayList<ServerAddress>(addr.explode());
            this._rsStatus = new ReplicaSetStatus(m, this._allHosts);
            _createLogger.info("switching to replica set mode : " + this._allHosts + " -> " + this._curMaster);
        } else {
            this._set(addr);
            this._allHosts = null;
            this._rsStatus = null;
        }
    }

    public DBTCPConnector(Mongo m, ServerAddress ... all) throws MongoException {
        this(m, Arrays.asList(all));
    }

    public DBTCPConnector(Mongo m, List<ServerAddress> all) throws MongoException {
        this._mongo = m;
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(all);
        this._allHosts = new ArrayList<ServerAddress>(all);
        this._rsStatus = new ReplicaSetStatus(m, this._allHosts);
        _createLogger.info(all + " -> " + this._curMaster);
    }

    private static ServerAddress _checkAddress(ServerAddress addr) {
        if (addr == null) {
            throw new NullPointerException("address can't be null");
        }
        return addr;
    }

    private static ServerAddress _checkAddress(List<ServerAddress> addrs) {
        if (addrs == null) {
            throw new NullPointerException("addresses can't be null");
        }
        if (addrs.size() == 0) {
            throw new IllegalArgumentException("need to specify at least 1 address");
        }
        return addrs.get(0);
    }

    @Override
    public void requestStart() {
        this._myPort.get().requestStart();
    }

    @Override
    public void requestDone() {
        this._myPort.get().requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this._myPort.get().requestEnsureConnection();
    }

    void _checkClosed() {
        if (this._closed) {
            throw new IllegalStateException("this Mongo has been closed");
        }
    }

    WriteResult _checkWriteError(DB db, MyPort mp, DBPort port, WriteConcern concern) throws MongoException {
        CommandResult e = port.runCommand(db, concern.getCommand());
        mp.done(port);
        Object foo = e.get("err");
        if (foo == null) {
            return new WriteResult(e, concern);
        }
        int code = -1;
        if (e.get("code") instanceof Number) {
            code = ((Number)e.get("code")).intValue();
        }
        String s = foo.toString();
        if (code == 11000 || code == 11001 || s.startsWith("E11000") || s.startsWith("E11001")) {
            throw new MongoException.DuplicateKey(code, s);
        }
        throw new MongoException(code, s);
    }

    @Override
    public WriteResult say(DB db, OutMessage m, WriteConcern concern) throws MongoException {
        this._checkClosed();
        MyPort mp = this._myPort.get();
        DBPort port = mp.get(true, false);
        port.checkAuth(db);
        try {
            port.say(m);
            if (concern.callGetLastError()) {
                WriteResult writeResult = this._checkWriteError(db, mp, port, concern);
                return writeResult;
            }
            mp.done(port);
            WriteResult writeResult = new WriteResult(db, port, concern);
            return writeResult;
        }
        catch (IOException ioe) {
            mp.error(port, ioe);
            this._error(ioe);
            if (concern.raiseNetworkErrors()) {
                throw new MongoException.Network("can't say something", ioe);
            }
            CommandResult res = new CommandResult();
            res.put("ok", (Object)false);
            res.put("$err", (Object)"NETWORK ERROR");
            WriteResult writeResult = new WriteResult(res, concern);
            return writeResult;
        }
        catch (MongoException me) {
            throw me;
        }
        catch (RuntimeException re) {
            mp.error(port, re);
            throw re;
        }
        finally {
            m.doneWithMessage();
        }
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m) throws MongoException {
        return this.call(db, coll, m, 2);
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, int retries) throws MongoException {
        this._checkClosed();
        MyPort mp = this._myPort.get();
        DBPort port = mp.get(false, m.hasOption(4));
        port.checkAuth(db);
        Response res = null;
        try {
            res = port.call(m, coll);
            mp.done(port);
        }
        catch (IOException ioe) {
            boolean shoulRetry = this._error(ioe) && !coll._name.equals("$cmd") && retries > 0;
            mp.error(port, ioe);
            if (shoulRetry) {
                return this.call(db, coll, m, retries - 1);
            }
            throw new MongoException.Network("can't call something", ioe);
        }
        catch (RuntimeException re) {
            mp.error(port, re);
            throw re;
        }
        ServerError err = res.getError();
        if (err != null && err.isNotMasterError()) {
            this.checkMaster();
            if (retries <= 0) {
                throw new MongoException("not talking to master and retries used up");
            }
            return this.call(db, coll, m, retries - 1);
        }
        m.doneWithMessage();
        return res;
    }

    public ServerAddress getAddress() {
        return this._curMaster;
    }

    public List<ServerAddress> getAllAddress() {
        return this._allHosts;
    }

    public String getConnectPoint() {
        return this._curMaster.toString();
    }

    boolean _error(Throwable t) throws MongoException {
        if (this._allHosts != null) {
            _logger.log(Level.WARNING, "replica set mode, switching master", t);
            this.checkMaster();
        }
        return true;
    }

    void checkMaster() {
        if (this._rsStatus == null) {
            return;
        }
        ReplicaSetStatus.Node n = this._rsStatus.ensureMaster();
        if (n == null) {
            throw new MongoInternalException("can't find a master");
        }
        this._set(n._addr);
    }

    private boolean _set(ServerAddress addr) {
        if (this._curMaster == addr) {
            return false;
        }
        this._curMaster = addr;
        this._curPortPool = this._portHolder.get(addr);
        return true;
    }

    public String debugString() {
        StringBuilder buf = new StringBuilder("DBTCPConnector: ");
        if (this._allHosts != null) {
            buf.append("replica set : ").append(this._allHosts);
        } else {
            buf.append(this._curMaster).append(" ").append(this._curMaster._addr);
        }
        return buf.toString();
    }

    public void close() {
        this._closed = true;
        this._portHolder.close();
        this._rsStatus.close();
    }

    class MyPort {
        DBPort _port;
        DBPortPool _pool;
        boolean _inRequest;

        MyPort() {
        }

        DBPort get(boolean keep, boolean slaveOk) {
            ServerAddress slave;
            if (slaveOk && DBTCPConnector.this._rsStatus != null && (slave = DBTCPConnector.this._rsStatus.getASecondary()) != null) {
                this._pool = DBTCPConnector.this._portHolder.get(slave);
                this._port = this._pool.get();
                return this._port;
            }
            if (this._port != null) {
                if (this._pool == DBTCPConnector.this._curPortPool) {
                    return this._port;
                }
                this._pool.done(this._port);
                this._port = null;
                this._pool = null;
            }
            this._pool = DBTCPConnector.this._curPortPool;
            DBPort p = this._pool.get();
            if (keep && this._inRequest) {
                this._port = p;
            }
            return p;
        }

        void done(DBPort p) {
            if (p != this._port) {
                this._pool.done(p);
            }
        }

        void error(DBPort p, Exception e) {
            this._pool.done(p);
            p.close();
            this._port = null;
            _logger.log(Level.SEVERE, "MyPort.error called", e);
        }

        void requestEnsureConnection() {
            if (!this._inRequest) {
                return;
            }
            if (this._port != null) {
                return;
            }
            this._port = this._pool.get();
        }

        void requestStart() {
            this._inRequest = true;
        }

        void requestDone() {
            if (this._port != null) {
                this._pool.done(this._port);
            }
            this._port = null;
            this._inRequest = false;
        }
    }
}

