/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.Mongo;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplicaSetStatus {
    static final Logger _rootLogger = Logger.getLogger("com.mongodb.ReplicaSetStatus");
    final List<Node> _all;
    Updater _updater;
    String _setName = null;
    Logger _logger = _rootLogger;
    String _lastPrimarySignal;
    boolean _closed = false;
    final Random _random = new Random();
    static final MongoOptions _mongoOptions = new MongoOptions();
    static final DBObject _isMasterCmd;

    ReplicaSetStatus(List<ServerAddress> initial) {
        this._all = Collections.synchronizedList(new ArrayList());
        for (ServerAddress addr : initial) {
            this._all.add(new Node(addr));
        }
        this._updater = new Updater();
        this._updater.start();
    }

    boolean ready() {
        return this._setName != null;
    }

    void _checkClosed() {
        if (this._closed) {
            throw new IllegalStateException("ReplicaSetStatus closed");
        }
    }

    ServerAddress getMaster() {
        Node n = this.getMasterNode();
        if (n == null) {
            return null;
        }
        return n._addr;
    }

    Node getMasterNode() {
        this._checkClosed();
        for (int i = 0; i < this._all.size(); ++i) {
            Node n = this._all.get(i);
            if (!n.master()) continue;
            return n;
        }
        return null;
    }

    ServerAddress getASecondary() {
        this._checkClosed();
        Node best = null;
        double badBeforeBest = 0.0;
        int start = this._random.nextInt(this._all.size());
        double mybad = 0.0;
        for (int i = 0; i < this._all.size(); ++i) {
            Node n = this._all.get((start + i) % this._all.size());
            if (!n.secondary()) {
                mybad += 1.0;
                continue;
            }
            if (best == null) {
                best = n;
                badBeforeBest = mybad;
                mybad = 0.0;
                continue;
            }
            long diff = best._pingTime - n._pingTime;
            if (diff <= 15L && !((badBeforeBest - mybad) / (double)(this._all.size() - 1) > this._random.nextDouble())) continue;
            best = n;
            badBeforeBest = mybad;
            mybad = 0.0;
        }
        if (best == null) {
            return null;
        }
        return best._addr;
    }

    Node ensureMaster() {
        Node n = this.getMasterNode();
        if (n != null) {
            n.update();
            if (n._isMaster) {
                return n;
            }
        }
        if (this._lastPrimarySignal != null) {
            n = this.findNode(this._lastPrimarySignal);
            n.update();
            if (n._isMaster) {
                return n;
            }
        }
        this.updateAll();
        return this.getMasterNode();
    }

    void updateAll() {
        for (int i = 0; i < this._all.size(); ++i) {
            Node n = this._all.get(i);
            n.update();
        }
    }

    void _addIfNotHere(String host) {
        Node n = this.findNode(host);
        if (n == null) {
            try {
                this._all.add(new Node(new ServerAddress(host)));
            }
            catch (UnknownHostException un) {
                this._logger.log(Level.WARNING, "couldn't resolve host [" + host + "]");
            }
        }
    }

    Node findNode(String host) {
        for (int i = 0; i < this._all.size(); ++i) {
            if (!this._all.get((int)i)._names.contains(host)) continue;
            return this._all.get(i);
        }
        ServerAddress addr = null;
        try {
            addr = new ServerAddress(host);
        }
        catch (UnknownHostException un) {
            this._logger.log(Level.WARNING, "couldn't resolve host [" + host + "]");
            return null;
        }
        for (int i = 0; i < this._all.size(); ++i) {
            if (!this._all.get((int)i)._addr.equals(addr)) continue;
            this._all.get((int)i)._names.add(host);
            return this._all.get(i);
        }
        return null;
    }

    void printStatus() {
        for (int i = 0; i < this._all.size(); ++i) {
            System.out.println(this._all.get(i));
        }
    }

    void close() {
        this._closed = true;
    }

    public static void main(String[] args) throws Exception {
        LinkedList<ServerAddress> addrs = new LinkedList<ServerAddress>();
        addrs.add(new ServerAddress("localhost", 27017));
        addrs.add(new ServerAddress("localhost", 27018));
        Mongo m = new Mongo(addrs);
        ReplicaSetStatus status = new ReplicaSetStatus(addrs);
        System.out.println(status.ensureMaster()._addr);
        while (true) {
            System.out.println(status.ready());
            if (status.ready()) {
                status.printStatus();
                System.out.println("master: " + status.getMaster() + "\t secondary: " + status.getASecondary());
            }
            System.out.println("-----------------------");
            Thread.sleep(5000L);
        }
    }

    static {
        ReplicaSetStatus._mongoOptions.connectTimeout = 20000;
        ReplicaSetStatus._mongoOptions.socketTimeout = 20000;
        _isMasterCmd = new BasicDBObject("ismaster", (Object)1);
    }

    class Updater
    extends Thread {
        Updater() {
            super("ReplicaSetStatus:Updater");
            this.setDaemon(true);
        }

        public void run() {
            while (!ReplicaSetStatus.this._closed) {
                try {
                    ReplicaSetStatus.this.updateAll();
                }
                catch (Exception e) {
                    ReplicaSetStatus.this._logger.log(Level.WARNING, "couldn't do update pass", e);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class Node {
        final ServerAddress _addr;
        final Set<String> _names = Collections.synchronizedSet(new HashSet());
        final DBPort _port;
        boolean _ok = false;
        long _lastCheck = 0L;
        long _pingTime = 0L;
        boolean _isMaster = false;
        boolean _isSecondary = false;
        double _priority = 0.0;

        Node(ServerAddress addr) {
            this._addr = addr;
            this._port = new DBPort(addr, null, _mongoOptions);
            this._names.add(addr.toString());
        }

        synchronized void update() {
            try {
                long start = System.currentTimeMillis();
                CommandResult res = this._port.runCommand("admin", _isMasterCmd);
                this._lastCheck = System.currentTimeMillis();
                this._pingTime = this._lastCheck - start;
                if (res == null) {
                    this._ok = false;
                    return;
                }
                this._ok = true;
                this._isMaster = res.getBoolean("ismaster", false);
                this._isSecondary = res.getBoolean("secondary", false);
                ReplicaSetStatus.this._lastPrimarySignal = res.getString("primary");
                if (res.containsKey("hosts")) {
                    for (Object x : (List)res.get("hosts")) {
                        ReplicaSetStatus.this._addIfNotHere(x.toString());
                    }
                }
            }
            catch (MongoInternalException e) {
                Throwable root = e;
                if (e.getCause() != null) {
                    root = e.getCause();
                }
                ReplicaSetStatus.this._logger.log(Level.FINE, "node down: " + this._addr + " " + root);
                this._ok = false;
            }
            catch (Exception e) {
                ReplicaSetStatus.this._logger.log(Level.SEVERE, "can't update node: " + this._addr, e);
                this._ok = false;
            }
            if (!this._isMaster) {
                return;
            }
            try {
                DBObject config = this._port.findOne("local.system.replset", new BasicDBObject());
                if (config != null) {
                    String setName = config.get("_id").toString();
                    if (ReplicaSetStatus.this._setName == null) {
                        ReplicaSetStatus.this._setName = setName;
                        ReplicaSetStatus.this._logger = Logger.getLogger(_rootLogger.getName() + "." + setName);
                    } else if (!ReplicaSetStatus.this._setName.equals(setName)) {
                        ReplicaSetStatus.this._logger.log(Level.SEVERE, "mis match set name old: " + ReplicaSetStatus.this._setName + " new: " + setName);
                        return;
                    }
                }
            }
            catch (MongoInternalException e) {
                if (ReplicaSetStatus.this._setName == null) {
                    ReplicaSetStatus.this._logger.log(Level.SEVERE, "can't get intial config from node: " + this._addr, e);
                }
            }
            catch (Exception e) {
                ReplicaSetStatus.this._logger.log(Level.SEVERE, "unexpected error getting config from node: " + this._addr, e);
            }
        }

        public boolean master() {
            return this._ok && this._isMaster;
        }

        public boolean secondary() {
            return this._ok && this._isSecondary;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Replica Set Node: ").append(this._addr).append("\n");
            buf.append("\t ok \t").append(this._ok).append("\n");
            buf.append("\t ping \t").append(this._pingTime).append("\n");
            buf.append("\t master \t").append(this._isMaster).append("\n");
            buf.append("\t secondary \t").append(this._isSecondary).append("\n");
            buf.append("\t priority \t").append(this._priority).append("\n");
            return buf.toString();
        }
    }
}

