/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONCallback
extends BasicBSONCallback {
    private String _lastName;
    private boolean _lastArray = false;

    @Override
    public BSONObject create() {
        return new BasicDBObject();
    }

    @Override
    public BSONObject create(boolean array, List<String> path) {
        if (array) {
            return new BasicDBList();
        }
        return new BasicDBObject();
    }

    @Override
    public void objectStart(boolean array, String name) {
        this._lastName = name;
        this._lastArray = array;
        super.objectStart(array, name);
    }

    @Override
    public Object objectDone() {
        Object o = super.objectDone();
        BSONObject b = (BSONObject)o;
        if (!this._lastArray) {
            if (b.containsField("$oid")) {
                o = new ObjectId((String)b.get("$oid"));
                if (!this.isStackEmpty()) {
                    this.gotObjectId(this._lastName, (ObjectId)o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$date")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                o = format.parse((String)b.get("$date"), new ParsePosition(0));
                if (!this.isStackEmpty()) {
                    this.cur().put(this._lastName, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$regex")) {
                o = Pattern.compile((String)b.get("$regex"), BSON.regexFlags((String)b.get("$options")));
                if (!this.isStackEmpty()) {
                    this.cur().put(this._lastName, o);
                } else {
                    this.setRoot(o);
                }
            }
        }
        return o;
    }
}

