/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.AggregateIterableImpl;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.DistinctIterableImpl;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.FindIterableImpl;
import com.mongodb.async.client.ListIndexesIterable;
import com.mongodb.async.client.ListIndexesIterableImpl;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.async.client.MapReduceIterableImpl;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.IndexRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexesOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.RenameCollectionOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MongoCollectionImpl<TDocument>
implements MongoCollection<TDocument> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final ReadConcern readConcern;
    private final AsyncOperationExecutor executor;

    MongoCollectionImpl(MongoNamespace namespace, Class<TDocument> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, ReadConcern readConcern, AsyncOperationExecutor executor) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.documentClass;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> newDocumentClass) {
        return new MongoCollectionImpl<NewTDocument>(this.namespace, newDocumentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, codecRegistry, this.readPreference, this.writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, readPreference, this.writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, this.writeConcern, readConcern, this.executor);
    }

    @Override
    public void count(SingleResultCallback<Long> callback) {
        this.count((Bson)new BsonDocument(), new CountOptions(), callback);
    }

    @Override
    public void count(Bson filter, SingleResultCallback<Long> callback) {
        this.count(filter, new CountOptions(), callback);
    }

    @Override
    public void count(Bson filter, CountOptions options, SingleResultCallback<Long> callback) {
        CountOperation operation = new CountOperation(this.namespace).filter(this.toBsonDocument(filter)).skip((long)options.getSkip()).limit((long)options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        if (options.getHint() != null) {
            operation.hint((BsonValue)this.toBsonDocument(options.getHint()));
        } else if (options.getHintString() != null) {
            operation.hint((BsonValue)new BsonString(options.getHintString()));
        }
        this.executor.execute((AsyncReadOperation)operation, this.readPreference, callback);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctIterableImpl<TDocument, TResult>(this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, fieldName, filter);
    }

    @Override
    public FindIterable<TDocument> find() {
        return this.find((Bson)new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Class<TResult> resultClass) {
        return this.find((Bson)new BsonDocument(), resultClass);
    }

    @Override
    public FindIterable<TDocument> find(Bson filter) {
        return this.find(filter, this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Bson filter, Class<TResult> resultClass) {
        return new FindIterableImpl<TDocument, TResult>(this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, filter, new FindOptions());
    }

    @Override
    public AggregateIterable<TDocument> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, this.documentClass);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregateIterableImpl<TDocument, TResult>(this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, pipeline);
    }

    @Override
    public MapReduceIterable<TDocument> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, this.documentClass);
    }

    @Override
    public <TResult> MapReduceIterable<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return new MapReduceIterableImpl<TDocument, TResult>(this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, mapFunction, reduceFunction);
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, SingleResultCallback<BulkWriteResult> callback) {
        this.bulkWrite(requests, new BulkWriteOptions(), callback);
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options, SingleResultCallback<BulkWriteResult> callback) {
        ArrayList<InsertRequest> writeRequests = new ArrayList<InsertRequest>(requests.size());
        for (WriteModel<TDocument> writeModel : requests) {
            InsertRequest writeRequest;
            if (writeModel instanceof InsertOneModel) {
                Object document = ((InsertOneModel)writeModel).getDocument();
                if (this.getCodec() instanceof CollectibleCodec) {
                    ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
                }
                writeRequest = new InsertRequest(this.documentToBsonDocument(document));
            } else if (writeModel instanceof ReplaceOneModel) {
                ReplaceOneModel replaceOneModel = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(replaceOneModel.getFilter()), this.documentToBsonDocument(replaceOneModel.getReplacement()), WriteRequest.Type.REPLACE).upsert(replaceOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateOneModel) {
                UpdateOneModel updateOneModel = (UpdateOneModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(updateOneModel.getFilter()), this.toBsonDocument(updateOneModel.getUpdate()), WriteRequest.Type.UPDATE).multi(false).upsert(updateOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateManyModel) {
                UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(updateManyModel.getFilter()), this.toBsonDocument(updateManyModel.getUpdate()), WriteRequest.Type.UPDATE).multi(true).upsert(updateManyModel.getOptions().isUpsert());
            } else if (writeModel instanceof DeleteOneModel) {
                DeleteOneModel deleteOneModel = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(this.toBsonDocument(deleteOneModel.getFilter())).multi(false);
            } else if (writeModel instanceof DeleteManyModel) {
                DeleteManyModel deleteManyModel = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(this.toBsonDocument(deleteManyModel.getFilter())).multi(true);
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            writeRequests.add(writeRequest);
        }
        this.executor.execute((AsyncWriteOperation)new MixedBulkWriteOperation(this.namespace, writeRequests, options.isOrdered(), this.writeConcern).bypassDocumentValidation(options.getBypassDocumentValidation()), callback);
    }

    @Override
    public void insertOne(TDocument document, SingleResultCallback<Void> callback) {
        this.insertOne(document, new InsertOneOptions(), callback);
    }

    @Override
    public void insertOne(TDocument document, InsertOneOptions options, final SingleResultCallback<Void> callback) {
        TDocument insertDocument = document;
        if (this.getCodec() instanceof CollectibleCodec) {
            ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(insertDocument);
        }
        this.executeSingleWriteRequest((WriteRequest)new InsertRequest(this.documentToBsonDocument(insertDocument)), options.getBypassDocumentValidation(), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                callback.onResult(null, t);
            }
        });
    }

    @Override
    public void insertMany(List<? extends TDocument> documents, SingleResultCallback<Void> callback) {
        this.insertMany(documents, new InsertManyOptions(), callback);
    }

    @Override
    public void insertMany(List<? extends TDocument> documents, InsertManyOptions options, final SingleResultCallback<Void> callback) {
        ArrayList<InsertRequest> requests = new ArrayList<InsertRequest>(documents.size());
        for (Object document : documents) {
            if (this.getCodec() instanceof CollectibleCodec) {
                document = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
            }
            requests.add(new InsertRequest(this.documentToBsonDocument(document)));
        }
        this.executor.execute((AsyncWriteOperation)new MixedBulkWriteOperation(this.namespace, requests, options.isOrdered(), this.writeConcern).bypassDocumentValidation(options.getBypassDocumentValidation()), ErrorHandlingResultCallback.errorHandlingCallback((SingleResultCallback)new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                callback.onResult(null, t);
            }
        }));
    }

    @Override
    public void deleteOne(Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.delete(filter, false, callback);
    }

    @Override
    public void deleteMany(Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.delete(filter, true, callback);
    }

    @Override
    public void replaceOne(Bson filter, TDocument replacement, SingleResultCallback<UpdateResult> callback) {
        this.replaceOne(filter, replacement, new UpdateOptions(), callback);
    }

    @Override
    public void replaceOne(Bson filter, TDocument replacement, UpdateOptions options, final SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest((WriteRequest)new UpdateRequest(this.toBsonDocument(filter), this.documentToBsonDocument(replacement), WriteRequest.Type.REPLACE).upsert(options.isUpsert()), options.getBypassDocumentValidation(), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)MongoCollectionImpl.this.toUpdateResult(result), null);
                }
            }
        });
    }

    @Override
    public void updateOne(Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateOne(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateOne(Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.update(filter, update, options, false, callback);
    }

    @Override
    public void updateMany(Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateMany(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateMany(Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.update(filter, update, options, true, callback);
    }

    @Override
    public void findOneAndDelete(Bson filter, SingleResultCallback<TDocument> callback) {
        this.findOneAndDelete(filter, new FindOneAndDeleteOptions(), callback);
    }

    @Override
    public void findOneAndDelete(Bson filter, FindOneAndDeleteOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute((AsyncWriteOperation)new FindAndDeleteOperation(this.namespace, this.writeConcern, this.getCodec()).filter(this.toBsonDocument(filter)).projection(this.toBsonDocument(options.getProjection())).sort(this.toBsonDocument(options.getSort())).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), callback);
    }

    @Override
    public void findOneAndReplace(Bson filter, TDocument replacement, SingleResultCallback<TDocument> callback) {
        this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions(), callback);
    }

    @Override
    public void findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute((AsyncWriteOperation)new FindAndReplaceOperation(this.namespace, this.writeConcern, this.getCodec(), this.documentToBsonDocument(replacement)).filter(this.toBsonDocument(filter)).projection(this.toBsonDocument(options.getProjection())).sort(this.toBsonDocument(options.getSort())).returnOriginal(options.getReturnDocument() == ReturnDocument.BEFORE).upsert(options.isUpsert()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options.getBypassDocumentValidation()), callback);
    }

    @Override
    public void findOneAndUpdate(Bson filter, Bson update, SingleResultCallback<TDocument> callback) {
        this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions(), callback);
    }

    @Override
    public void findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute((AsyncWriteOperation)new FindAndUpdateOperation(this.namespace, this.writeConcern, this.getCodec(), this.toBsonDocument(update)).filter(this.toBsonDocument(filter)).projection(this.toBsonDocument(options.getProjection())).sort(this.toBsonDocument(options.getSort())).returnOriginal(options.getReturnDocument() == ReturnDocument.BEFORE).upsert(options.isUpsert()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options.getBypassDocumentValidation()), callback);
    }

    @Override
    public void drop(SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new DropCollectionOperation(this.namespace), callback);
    }

    @Override
    public void createIndex(Bson key, SingleResultCallback<String> callback) {
        this.createIndex(key, new IndexOptions(), callback);
    }

    @Override
    public void createIndex(Bson key, IndexOptions indexOptions, final SingleResultCallback<String> callback) {
        this.createIndexes(Collections.singletonList(new IndexModel(key, indexOptions)), new SingleResultCallback<List<String>>(){

            public void onResult(List<String> result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)result.get(0), null);
                }
            }
        });
    }

    @Override
    public void createIndexes(List<IndexModel> indexes, final SingleResultCallback<List<String>> callback) {
        Assertions.notNull((String)"indexes", indexes);
        ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>(indexes.size());
        for (IndexModel model : indexes) {
            indexRequests.add(new IndexRequest(this.toBsonDocument(model.getKeys())).name(model.getOptions().getName()).background(model.getOptions().isBackground()).unique(model.getOptions().isUnique()).sparse(model.getOptions().isSparse()).expireAfter(model.getOptions().getExpireAfter(TimeUnit.SECONDS), TimeUnit.SECONDS).version(model.getOptions().getVersion()).weights(this.toBsonDocument(model.getOptions().getWeights())).defaultLanguage(model.getOptions().getDefaultLanguage()).languageOverride(model.getOptions().getLanguageOverride()).textVersion(model.getOptions().getTextVersion()).sphereVersion(model.getOptions().getSphereVersion()).bits(model.getOptions().getBits()).min(model.getOptions().getMin()).max(model.getOptions().getMax()).bucketSize(model.getOptions().getBucketSize()).storageEngine(this.toBsonDocument(model.getOptions().getStorageEngine())));
        }
        final CreateIndexesOperation createIndexesOperation = new CreateIndexesOperation(this.getNamespace(), indexRequests);
        this.executor.execute((AsyncWriteOperation)createIndexesOperation, (SingleResultCallback)new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)createIndexesOperation.getIndexNames(), null);
                }
            }
        });
    }

    @Override
    public ListIndexesIterable<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> resultClass) {
        return new ListIndexesIterableImpl<TResult>(this.namespace, resultClass, this.codecRegistry, this.readPreference, this.executor);
    }

    @Override
    public void dropIndex(String indexName, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new DropIndexOperation(this.namespace, indexName), callback);
    }

    @Override
    public void dropIndex(Bson keys, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new DropIndexOperation(this.namespace, keys.toBsonDocument(BsonDocument.class, this.codecRegistry)), callback);
    }

    @Override
    public void dropIndexes(SingleResultCallback<Void> callback) {
        this.dropIndex("*", callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, SingleResultCallback<Void> callback) {
        this.renameCollection(newCollectionNamespace, new RenameCollectionOptions(), callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new RenameCollectionOperation(this.getNamespace(), newCollectionNamespace).dropTarget(options.isDropTarget()), callback);
    }

    private void delete(Bson filter, boolean multi, final SingleResultCallback<DeleteResult> callback) {
        this.executeSingleWriteRequest((WriteRequest)new DeleteRequest(this.toBsonDocument(filter)).multi(multi), null, new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (result.wasAcknowledged()) {
                    callback.onResult((Object)DeleteResult.acknowledged((long)result.getDeletedCount()), null);
                } else {
                    callback.onResult((Object)DeleteResult.unacknowledged(), null);
                }
            }
        });
    }

    private void update(Bson filter, Bson update, UpdateOptions updateOptions, boolean multi, final SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest((WriteRequest)new UpdateRequest(this.toBsonDocument(filter), this.toBsonDocument(update), WriteRequest.Type.UPDATE).upsert(updateOptions.isUpsert()).multi(multi), updateOptions.getBypassDocumentValidation(), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)MongoCollectionImpl.this.toUpdateResult(result), null);
                }
            }
        });
    }

    private void executeSingleWriteRequest(final WriteRequest request, Boolean bypassDocumentValidation, final SingleResultCallback<BulkWriteResult> callback) {
        this.executor.execute((AsyncWriteOperation)new MixedBulkWriteOperation(this.namespace, Collections.singletonList(request), true, this.writeConcern).bypassDocumentValidation(bypassDocumentValidation), (SingleResultCallback)new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t instanceof MongoBulkWriteException) {
                    MongoBulkWriteException e = (MongoBulkWriteException)t;
                    if (e.getWriteErrors().isEmpty()) {
                        callback.onResult(null, (Throwable)new MongoWriteConcernException(e.getWriteConcernError(), MongoCollectionImpl.this.translateBulkWriteResult(request, e.getWriteResult()), e.getServerAddress()));
                    } else {
                        callback.onResult(null, (Throwable)new MongoWriteException(new WriteError((WriteError)e.getWriteErrors().get(0)), e.getServerAddress()));
                    }
                } else {
                    callback.onResult((Object)result, t);
                }
            }
        });
    }

    private WriteConcernResult translateBulkWriteResult(WriteRequest request, BulkWriteResult writeResult) {
        switch (request.getType()) {
            case INSERT: {
                return WriteConcernResult.acknowledged((int)writeResult.getInsertedCount(), (boolean)false, null);
            }
            case DELETE: {
                return WriteConcernResult.acknowledged((int)writeResult.getDeletedCount(), (boolean)false, null);
            }
            case UPDATE: 
            case REPLACE: {
                return WriteConcernResult.acknowledged((int)(writeResult.getMatchedCount() + writeResult.getUpserts().size()), (writeResult.getMatchedCount() > 0 ? 1 : 0) != 0, writeResult.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)writeResult.getUpserts().get(0)).getId());
            }
        }
        throw new MongoInternalException("Unhandled write request type: " + request.getType());
    }

    private UpdateResult toUpdateResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            Long modifiedCount = result.isModifiedCountAvailable() ? Long.valueOf(result.getModifiedCount()) : null;
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)result.getUpserts().get(0)).getId();
            return UpdateResult.acknowledged((long)result.getMatchedCount(), (Long)modifiedCount, (BsonValue)upsertedId);
        }
        return UpdateResult.unacknowledged();
    }

    private Codec<TDocument> getCodec() {
        return this.getCodec(this.documentClass);
    }

    private <TResult> Codec<TResult> getCodec(Class<TResult> resultClass) {
        return this.codecRegistry.get(resultClass);
    }

    private BsonDocument documentToBsonDocument(TDocument document) {
        return BsonDocumentWrapper.asBsonDocument(document, (CodecRegistry)this.codecRegistry);
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(this.documentClass, this.codecRegistry);
    }
}

