/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateToCollectionThenFindOperation;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.async.client.MongoIterableImpl;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.MapReduceAsyncBatchCursor;
import com.mongodb.operation.MapReduceStatistics;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.session.ClientSession;
import java.util.concurrent.TimeUnit;
import org.bson.BsonJavaScript;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MapReduceIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements MapReduceIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final String mapFunction;
    private final String reduceFunction;
    private boolean inline = true;
    private String collectionName;
    private String finalizeFunction;
    private Bson scope;
    private Bson filter;
    private Bson sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose = true;
    private long maxTimeMS;
    private MapReduceAction action = MapReduceAction.REPLACE;
    private String databaseName;
    private boolean sharded;
    private boolean nonAtomic;
    private Boolean bypassDocumentValidation;
    private Collation collation;

    MapReduceIterableImpl(ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, AsyncOperationExecutor executor, String mapFunction, String reduceFunction) {
        super(clientSession, executor, readConcern, readPreference);
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.mapFunction = (String)Assertions.notNull((String)"mapFunction", (Object)mapFunction);
        this.reduceFunction = (String)Assertions.notNull((String)"reduceFunction", (Object)reduceFunction);
    }

    @Override
    public MapReduceIterable<TResult> collectionName(String collectionName) {
        this.collectionName = (String)Assertions.notNull((String)"collectionName", (Object)collectionName);
        this.inline = false;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> scope(Bson scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> sort(Bson sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReduceIterable<TResult> action(MapReduceAction action) {
        this.action = action;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> sharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> nonAtomic(boolean nonAtomic) {
        this.nonAtomic = nonAtomic;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public MapReduceIterable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public void toCollection(SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"callback", callback);
        if (this.inline) {
            throw new IllegalStateException("The options must specify a non-inline result");
        }
        this.getExecutor().execute((AsyncWriteOperation)this.createMapReduceToCollectionOperation(), callback);
    }

    @Override
    ReadPreference getReadPreference() {
        if (this.inline) {
            return super.getReadPreference();
        }
        return ReadPreference.primary();
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation() {
        if (this.inline) {
            return this.createMapReduceInlineOperation();
        }
        return new AggregateToCollectionThenFindOperation<TResult>(this.createMapReduceToCollectionOperation(), this.createFindOperation());
    }

    private WrappedMapReduceReadOperation<TResult> createMapReduceInlineOperation() {
        MapReduceWithInlineResultsOperation operation = new MapReduceWithInlineResultsOperation(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), (Decoder)this.codecRegistry.get(this.resultClass)).filter(this.toBsonDocumentOrNull(this.filter, this.documentClass, this.codecRegistry)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.toBsonDocumentOrNull(this.scope, this.documentClass, this.codecRegistry)).sort(this.toBsonDocumentOrNull(this.sort, this.documentClass, this.codecRegistry)).verbose(this.verbose).readConcern(this.getReadConcern()).collation(this.collation);
        if (this.finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
        }
        return new WrappedMapReduceReadOperation(operation);
    }

    private WrappedMapReduceWriteOperation createMapReduceToCollectionOperation() {
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), this.collectionName, this.writeConcern).filter(this.toBsonDocumentOrNull(this.filter, this.documentClass, this.codecRegistry)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.toBsonDocumentOrNull(this.scope, this.documentClass, this.codecRegistry)).sort(this.toBsonDocumentOrNull(this.sort, this.documentClass, this.codecRegistry)).verbose(this.verbose).action(this.action.getValue()).nonAtomic(this.nonAtomic).sharded(this.sharded).databaseName(this.databaseName).bypassDocumentValidation(this.bypassDocumentValidation).collation(this.collation);
        if (this.finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
        }
        return new WrappedMapReduceWriteOperation(operation);
    }

    private FindOperation<TResult> createFindOperation() {
        String dbName = this.databaseName != null ? this.databaseName : this.namespace.getDatabaseName();
        return new FindOperation(new MongoNamespace(dbName, this.collectionName), (Decoder)this.codecRegistry.get(this.resultClass)).collation(this.collation).batchSize(this.getBatchSize() == null ? 0 : this.getBatchSize());
    }

    static class WrappedMapReduceWriteOperation
    implements AsyncWriteOperation<Void> {
        private final AsyncWriteOperation<MapReduceStatistics> operation;

        AsyncWriteOperation<MapReduceStatistics> getOperation() {
            return this.operation;
        }

        WrappedMapReduceWriteOperation(MapReduceToCollectionOperation operation) {
            this.operation = operation;
        }

        public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
            this.operation.executeAsync(binding, (SingleResultCallback)new SingleResultCallback<MapReduceStatistics>(){

                public void onResult(MapReduceStatistics result, Throwable t) {
                    callback.onResult(null, t);
                }
            });
        }
    }

    static class WrappedMapReduceReadOperation<TResult>
    implements AsyncReadOperation<AsyncBatchCursor<TResult>> {
        private final AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> operation;

        AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> getOperation() {
            return this.operation;
        }

        WrappedMapReduceReadOperation(MapReduceWithInlineResultsOperation<TResult> operation) {
            this.operation = operation;
        }

        public void executeAsync(AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<TResult>> callback) {
            this.operation.executeAsync(binding, new SingleResultCallback<MapReduceAsyncBatchCursor<TResult>>(){

                public void onResult(MapReduceAsyncBatchCursor<TResult> batchCursor, Throwable t) {
                    callback.onResult(batchCursor, t);
                }
            });
        }
    }
}

