/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.event.CommandListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;

@Immutable
public final class MongoClientSettings {
    private final ReadPreference readPreference;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final ReadConcern readConcern;
    private final List<MongoCredential> credentialList;
    private final StreamFactoryFactory streamFactoryFactory;
    private final List<CommandListener> commandListeners;
    private final CodecRegistry codecRegistry;
    private final ClusterSettings clusterSettings;
    private final SocketSettings socketSettings;
    private final SocketSettings heartbeatSocketSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final ServerSettings serverSettings;
    private final SslSettings sslSettings;
    private final String applicationName;
    private final List<MongoCompressor> compressorList;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoClientSettings settings) {
        return new Builder(settings);
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Deprecated
    public List<MongoCredential> getCredentialList() {
        return this.credentialList;
    }

    public MongoCredential getCredential() {
        Assertions.isTrue((String)"Single or no credential", (this.credentialList.size() <= 1 ? 1 : 0) != 0);
        return this.credentialList.isEmpty() ? null : this.credentialList.get(0);
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean getRetryWrites() {
        return this.retryWrites;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public StreamFactoryFactory getStreamFactoryFactory() {
        return this.streamFactoryFactory;
    }

    public List<CommandListener> getCommandListeners() {
        return Collections.unmodifiableList(this.commandListeners);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public List<MongoCompressor> getCompressorList() {
        return this.compressorList;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public SslSettings getSslSettings() {
        return this.sslSettings;
    }

    public SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    public SocketSettings getHeartbeatSocketSettings() {
        return this.heartbeatSocketSettings;
    }

    public ConnectionPoolSettings getConnectionPoolSettings() {
        return this.connectionPoolSettings;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    private MongoClientSettings(Builder builder) {
        this.readPreference = builder.readPreference;
        this.writeConcern = builder.writeConcern;
        this.retryWrites = builder.retryWrites;
        this.readConcern = builder.readConcern;
        this.credentialList = builder.credentialList;
        this.streamFactoryFactory = builder.streamFactoryFactory;
        this.codecRegistry = builder.codecRegistry;
        this.commandListeners = builder.commandListeners;
        this.applicationName = builder.applicationName;
        this.clusterSettings = builder.clusterSettings;
        this.serverSettings = builder.serverSettings;
        this.socketSettings = builder.socketSettings;
        this.heartbeatSocketSettings = builder.heartbeatSocketSettings;
        this.connectionPoolSettings = builder.connectionPoolSettings;
        this.sslSettings = builder.sslSettings;
        this.compressorList = builder.compressorList;
    }

    @NotThreadSafe
    public static final class Builder {
        private ReadPreference readPreference = ReadPreference.primary();
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        private boolean retryWrites;
        private ReadConcern readConcern = ReadConcern.DEFAULT;
        private CodecRegistry codecRegistry = MongoClients.getDefaultCodecRegistry();
        private StreamFactoryFactory streamFactoryFactory;
        private final List<CommandListener> commandListeners = new ArrayList<CommandListener>();
        private ClusterSettings clusterSettings;
        private SocketSettings socketSettings = SocketSettings.builder().build();
        private SocketSettings heartbeatSocketSettings = SocketSettings.builder().build();
        private ConnectionPoolSettings connectionPoolSettings = ConnectionPoolSettings.builder().maxSize(100).maxWaitQueueSize(500).build();
        private ServerSettings serverSettings = ServerSettings.builder().build();
        private SslSettings sslSettings = SslSettings.builder().build();
        private List<MongoCredential> credentialList = Collections.emptyList();
        private String applicationName;
        private List<MongoCompressor> compressorList = Collections.emptyList();

        private Builder() {
        }

        private Builder(MongoClientSettings settings) {
            this.readPreference = settings.getReadPreference();
            this.writeConcern = settings.getWriteConcern();
            this.retryWrites = settings.getRetryWrites();
            this.readConcern = settings.getReadConcern();
            this.credentialList = settings.getCredentialList();
            this.codecRegistry = settings.getCodecRegistry();
            this.streamFactoryFactory = settings.getStreamFactoryFactory();
            this.commandListeners.addAll(settings.commandListeners);
            this.clusterSettings = settings.getClusterSettings();
            this.serverSettings = settings.getServerSettings();
            this.socketSettings = settings.getSocketSettings();
            this.heartbeatSocketSettings = settings.getHeartbeatSocketSettings();
            this.connectionPoolSettings = settings.getConnectionPoolSettings();
            this.sslSettings = settings.getSslSettings();
            this.applicationName = settings.getApplicationName();
            this.compressorList = settings.getCompressorList();
        }

        public Builder clusterSettings(ClusterSettings clusterSettings) {
            this.clusterSettings = (ClusterSettings)Assertions.notNull((String)"clusterSettings", (Object)clusterSettings);
            return this;
        }

        public Builder socketSettings(SocketSettings socketSettings) {
            this.socketSettings = (SocketSettings)Assertions.notNull((String)"socketSettings", (Object)socketSettings);
            return this;
        }

        public Builder heartbeatSocketSettings(SocketSettings heartbeatSocketSettings) {
            this.heartbeatSocketSettings = (SocketSettings)Assertions.notNull((String)"heartbeatSocketSettings", (Object)heartbeatSocketSettings);
            return this;
        }

        public Builder connectionPoolSettings(ConnectionPoolSettings connectionPoolSettings) {
            this.connectionPoolSettings = (ConnectionPoolSettings)Assertions.notNull((String)"connectionPoolSettings", (Object)connectionPoolSettings);
            return this;
        }

        public Builder serverSettings(ServerSettings serverSettings) {
            this.serverSettings = (ServerSettings)Assertions.notNull((String)"serverSettings", (Object)serverSettings);
            return this;
        }

        public Builder sslSettings(SslSettings sslSettings) {
            this.sslSettings = (SslSettings)Assertions.notNull((String)"sslSettings", (Object)sslSettings);
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
            return this;
        }

        public Builder retryWrites(boolean retryWrites) {
            this.retryWrites = retryWrites;
            return this;
        }

        public Builder readConcern(ReadConcern readConcern) {
            this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
            return this;
        }

        @Deprecated
        public Builder credentialList(List<MongoCredential> credentialList) {
            this.credentialList = Collections.unmodifiableList((List)Assertions.notNull((String)"credentialList", credentialList));
            return this;
        }

        public Builder credential(MongoCredential credential) {
            this.credentialList = Collections.singletonList(Assertions.notNull((String)"credential", (Object)credential));
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
            return this;
        }

        public Builder streamFactoryFactory(StreamFactoryFactory streamFactoryFactory) {
            this.streamFactoryFactory = (StreamFactoryFactory)Assertions.notNull((String)"streamFactoryFactory", (Object)streamFactoryFactory);
            return this;
        }

        public Builder addCommandListener(CommandListener commandListener) {
            Assertions.notNull((String)"commandListener", (Object)commandListener);
            this.commandListeners.add(commandListener);
            return this;
        }

        public Builder applicationName(String applicationName) {
            if (applicationName != null) {
                Assertions.isTrueArgument((String)"applicationName UTF-8 encoding length <= 128", (applicationName.getBytes(Charset.forName("UTF-8")).length <= 128 ? 1 : 0) != 0);
            }
            this.applicationName = applicationName;
            return this;
        }

        public Builder compressorList(List<MongoCompressor> compressorList) {
            Assertions.notNull((String)"compressorList", compressorList);
            this.compressorList = compressorList;
            return this;
        }

        public MongoClientSettings build() {
            return new MongoClientSettings(this);
        }
    }
}

