/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.gridfs.GridFSDownloadStream;
import com.mongodb.async.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.lang.Nullable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;

final class GridFSDownloadStreamImpl
implements GridFSDownloadStream {
    private static final Logger LOGGER = Loggers.getLogger((String)"client.gridfs");
    private final ClientSession clientSession;
    private final GridFSFindIterable fileInfoIterable;
    private final MongoCollection<Document> chunksCollection;
    private final ConcurrentLinkedQueue<Document> resultsQueue = new ConcurrentLinkedQueue();
    private final Object closeAndReadingLock = new Object();
    private boolean reading;
    private boolean closed;
    private GridFSFile fileInfo;
    private int numberOfChunks;
    private AsyncBatchCursor<Document> cursor;
    private int batchSize;
    private int chunkIndex;
    private int bufferOffset;
    private long currentPosition;
    private byte[] buffer = null;

    GridFSDownloadStreamImpl(@Nullable ClientSession clientSession, GridFSFindIterable fileInfoIterable, MongoCollection<Document> chunksCollection) {
        this.clientSession = clientSession;
        this.fileInfoIterable = (GridFSFindIterable)Assertions.notNull((String)"file information", (Object)fileInfoIterable);
        this.chunksCollection = (MongoCollection)Assertions.notNull((String)"chunks collection", chunksCollection);
    }

    @Override
    public void getGridFSFile(SingleResultCallback<GridFSFile> callback) {
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        if (this.hasFileInfo()) {
            errHandlingCallback.onResult((Object)this.fileInfo, null);
            return;
        }
        if (!this.tryGetReadingLock(errHandlingCallback)) {
            return;
        }
        this.fileInfoIterable.first(new SingleResultCallback<GridFSFile>(){

            public void onResult(GridFSFile result, Throwable t) {
                GridFSDownloadStreamImpl.this.releaseReadingLock();
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else if (result == null) {
                    errHandlingCallback.onResult(null, (Throwable)new MongoGridFSException("File not found"));
                } else {
                    GridFSDownloadStreamImpl.this.fileInfo = result;
                    GridFSDownloadStreamImpl.this.numberOfChunks = (int)Math.ceil((double)GridFSDownloadStreamImpl.this.fileInfo.getLength() / (double)GridFSDownloadStreamImpl.this.fileInfo.getChunkSize());
                    errHandlingCallback.onResult((Object)result, null);
                }
            }
        });
    }

    @Override
    public GridFSDownloadStream batchSize(int batchSize) {
        Assertions.isTrueArgument((String)"batchSize cannot be negative", (batchSize >= 0 ? 1 : 0) != 0);
        this.batchSize = batchSize;
        this.discardCursor();
        return this;
    }

    @Override
    public void read(final ByteBuffer dst, SingleResultCallback<Integer> callback) {
        Assertions.notNull((String)"dst", (Object)dst);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        if (!this.hasFileInfo()) {
            this.getGridFSFile(new SingleResultCallback<GridFSFile>(){

                public void onResult(GridFSFile result, Throwable t) {
                    if (t != null) {
                        errHandlingCallback.onResult(null, t);
                    } else {
                        GridFSDownloadStreamImpl.this.read(dst, (SingleResultCallback<Integer>)errHandlingCallback);
                    }
                }
            });
            return;
        }
        if (!this.tryGetReadingLock(errHandlingCallback)) {
            return;
        }
        if (this.currentPosition == this.fileInfo.getLength()) {
            this.releaseReadingLock();
            errHandlingCallback.onResult((Object)-1, null);
            return;
        }
        this.checkAndFetchResults(0, dst, new SingleResultCallback<Integer>(){

            public void onResult(Integer result, Throwable t) {
                GridFSDownloadStreamImpl.this.releaseReadingLock();
                errHandlingCallback.onResult((Object)result, t);
            }
        });
    }

    private void checkAndFetchResults(final int amountRead, final ByteBuffer dst, final SingleResultCallback<Integer> callback) {
        if (this.currentPosition == this.fileInfo.getLength() || dst.remaining() == 0) {
            callback.onResult((Object)amountRead, null);
        } else if (this.hasResultsToProcess()) {
            this.processResults(amountRead, dst, callback);
        } else if (this.cursor == null) {
            Document filter = new Document("files_id", (Object)this.fileInfo.getId()).append("n", (Object)new Document("$gte", (Object)this.chunkIndex));
            FindIterable<Document> findIterable = this.clientSession != null ? this.chunksCollection.find(this.clientSession, (Bson)filter) : this.chunksCollection.find((Bson)filter);
            findIterable.batchSize(this.batchSize).sort((Bson)new Document("n", (Object)1)).batchCursor(new SingleResultCallback<AsyncBatchCursor<Document>>(){

                public void onResult(AsyncBatchCursor<Document> result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        GridFSDownloadStreamImpl.this.cursor = result;
                        GridFSDownloadStreamImpl.this.checkAndFetchResults(amountRead, dst, (SingleResultCallback<Integer>)callback);
                    }
                }
            });
        } else {
            this.cursor.next((SingleResultCallback)new SingleResultCallback<List<Document>>(){

                public void onResult(List<Document> result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else if (result == null || result.isEmpty()) {
                        callback.onResult(null, (Throwable)GridFSDownloadStreamImpl.this.chunkNotFound(GridFSDownloadStreamImpl.this.chunkIndex));
                    } else {
                        GridFSDownloadStreamImpl.this.resultsQueue.addAll(result);
                        if (GridFSDownloadStreamImpl.this.batchSize == 1) {
                            GridFSDownloadStreamImpl.this.discardCursor();
                        }
                        GridFSDownloadStreamImpl.this.processResults(amountRead, dst, (SingleResultCallback<Integer>)callback);
                    }
                }
            });
        }
    }

    private void processResults(int previousAmountRead, ByteBuffer dst, SingleResultCallback<Integer> callback) {
        try {
            int amountRead = previousAmountRead;
            int amountToCopy = dst.remaining();
            while (this.currentPosition < this.fileInfo.getLength() && amountToCopy > 0) {
                if (this.getBufferFromResultsQueue()) {
                    this.buffer = this.getBufferFromChunk(this.resultsQueue.poll(), this.chunkIndex);
                    this.bufferOffset = 0;
                    ++this.chunkIndex;
                }
                if (amountToCopy > this.buffer.length - this.bufferOffset) {
                    amountToCopy = this.buffer.length - this.bufferOffset;
                }
                if (amountToCopy <= 0) continue;
                dst.put(this.buffer, this.bufferOffset, amountToCopy);
                this.bufferOffset += amountToCopy;
                this.currentPosition += (long)amountToCopy;
                amountRead += amountToCopy;
                amountToCopy = dst.remaining();
            }
            this.checkAndFetchResults(amountRead, dst, callback);
        }
        catch (MongoGridFSException e) {
            callback.onResult(null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"callback", callback);
        SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        if (this.checkClosed()) {
            errHandlingCallback.onResult(null, null);
        } else if (!this.getReadingLock()) {
            this.callbackIsReadingException(callback);
        } else {
            Object object = this.closeAndReadingLock;
            synchronized (object) {
                if (!this.closed) {
                    this.closed = true;
                }
            }
            this.discardCursor();
            errHandlingCallback.onResult(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFileInfo() {
        boolean hasInfo = false;
        Object object = this.closeAndReadingLock;
        synchronized (object) {
            hasInfo = this.fileInfo != null;
        }
        return hasInfo;
    }

    private MongoGridFSException chunkNotFound(int chunkIndex) {
        return new MongoGridFSException(String.format("Could not find file chunk for files_id: %s at chunk index %s.", this.fileInfo.getId(), chunkIndex));
    }

    private byte[] getBufferFromChunk(Document chunk, int expectedChunkIndex) {
        long expectedDataLength;
        if (chunk == null || chunk.getInteger((Object)"n") != expectedChunkIndex) {
            throw this.chunkNotFound(expectedChunkIndex);
        }
        if (!(chunk.get((Object)"data") instanceof Binary)) {
            throw new MongoGridFSException("Unexpected data format for the chunk");
        }
        byte[] data = ((Binary)chunk.get((Object)"data", Binary.class)).getData();
        long l = expectedDataLength = expectedChunkIndex + 1 == this.numberOfChunks ? this.fileInfo.getLength() - (long)expectedChunkIndex * (long)this.fileInfo.getChunkSize() : (long)this.fileInfo.getChunkSize();
        if ((long)data.length != expectedDataLength) {
            throw new MongoGridFSException(String.format("Chunk size data length is not the expected size. The size was %s for file_id: %s chunk index %s it should be %s bytes.", data.length, this.fileInfo.getId(), expectedChunkIndex, expectedDataLength));
        }
        return data;
    }

    private boolean getBufferFromResultsQueue() {
        return !this.resultsQueue.isEmpty() && (this.buffer == null || this.bufferOffset == this.buffer.length);
    }

    private boolean hasResultsToProcess() {
        return !this.resultsQueue.isEmpty() || this.buffer != null && this.bufferOffset < this.buffer.length;
    }

    private <A> boolean tryGetReadingLock(SingleResultCallback<A> callback) {
        if (this.checkClosed()) {
            this.callbackClosedException(callback);
            return false;
        }
        if (!this.getReadingLock()) {
            this.callbackIsReadingException(callback);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkClosed() {
        Object object = this.closeAndReadingLock;
        synchronized (object) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getReadingLock() {
        boolean gotLock = false;
        Object object = this.closeAndReadingLock;
        synchronized (object) {
            if (!this.reading) {
                this.reading = true;
                gotLock = true;
            }
        }
        return gotLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReadingLock() {
        Object object = this.closeAndReadingLock;
        synchronized (object) {
            this.reading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardCursor() {
        Object object = this.closeAndReadingLock;
        synchronized (object) {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        }
    }

    private <T> void callbackClosedException(SingleResultCallback<T> callback) {
        callback.onResult(null, (Throwable)new MongoGridFSException("The AsyncInputStream has been closed"));
    }

    private <T> void callbackIsReadingException(SingleResultCallback<T> callback) {
        callback.onResult(null, (Throwable)new MongoGridFSException("The AsyncInputStream does not support concurrent reading."));
    }
}

