/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.client.ClientSession;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.binding.TransactionContext;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import org.bson.assertions.Assertions;

public class ClientSessionBinding
implements ReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, ClusterAwareReadWriteBinding wrapped) {
        this.wrapped = wrapped;
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.ownsSession = ownsSession;
        this.sessionContext = new SyncClientSessionContext(session);
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    public void release() {
        this.wrapped.release();
        this.closeSessionIfCountIsZero();
    }

    private void closeSessionIfCountIsZero() {
        if (this.getCount() == 0 && this.ownsSession) {
            this.session.close();
        }
    }

    public ConnectionSource getReadConnectionSource() {
        if (this.isConnectionSourcePinningRequired()) {
            return new SessionBindingConnectionSource(this.getPinnedConnectionSource(true));
        }
        return new SessionBindingConnectionSource(this.wrapped.getReadConnectionSource());
    }

    public ConnectionSource getWriteConnectionSource() {
        if (this.isConnectionSourcePinningRequired()) {
            return new SessionBindingConnectionSource(this.getPinnedConnectionSource(false));
        }
        return new SessionBindingConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    private boolean isConnectionSourcePinningRequired() {
        ClusterType clusterType = this.wrapped.getCluster().getDescription().getType();
        return this.session.hasActiveTransaction() && (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED);
    }

    private ConnectionSource getPinnedConnectionSource(boolean isRead) {
        ConnectionSource source;
        TransactionContext transactionContext = TransactionContext.get((com.mongodb.session.ClientSession)this.session);
        if (transactionContext == null) {
            source = isRead ? this.wrapped.getReadConnectionSource() : this.wrapped.getWriteConnectionSource();
            transactionContext = new TransactionContext(this.wrapped.getCluster().getDescription().getType());
            this.session.setTransactionContext(source.getServerDescription().getAddress(), transactionContext);
            transactionContext.release();
        } else {
            source = this.wrapped.getConnectionSource(this.session.getPinnedServerAddress());
        }
        return source;
    }

    private final class SyncClientSessionContext
    extends ClientSessionContext
    implements SessionContext {
        private final ClientSession clientSession;

        SyncClientSessionContext(ClientSession clientSession) {
            super((com.mongodb.session.ClientSession)clientSession);
            this.clientSession = clientSession;
        }

        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return this.clientSession.getTransactionOptions().getReadConcern();
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingConnectionSource
    implements ConnectionSource {
        private ConnectionSource wrapped;

        SessionBindingConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        public ServerApi getServerApi() {
            return this.wrapped.getServerApi();
        }

        public Connection getConnection() {
            TransactionContext transactionContext = TransactionContext.get((com.mongodb.session.ClientSession)ClientSessionBinding.this.session);
            if (transactionContext != null && transactionContext.isConnectionPinningRequired()) {
                Connection pinnedConnection = (Connection)transactionContext.getPinnedConnection();
                if (pinnedConnection == null) {
                    Connection connection = this.wrapped.getConnection();
                    transactionContext.pinConnection((ReferenceCounted)connection, Connection::markAsPinned);
                    return connection;
                }
                return pinnedConnection.retain();
            }
            return this.wrapped.getConnection();
        }

        public ConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public void release() {
            this.wrapped.release();
            ClientSessionBinding.this.closeSessionIfCountIsZero();
        }
    }
}

