/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.google.common.base.Preconditions;
import com.mongodb.client.MongoCursor;
import com.mongodb.jdbc.BsonTypeInfo;
import com.mongodb.jdbc.MongoBsonValue;
import com.mongodb.jdbc.MongoColumnInfo;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.MongoResultSetMetaData;
import com.mongodb.jdbc.MongoStatement;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.types.Decimal128;

@AutoLoggable
public class MongoResultSet
implements ResultSet,
LoggingAspect$ajcMightHaveAspect {
    private static final TimeZone UTC;
    protected SimpleDateFormat dateFormat;
    protected BsonDocument current;
    protected MongoCursor<BsonDocument> cursor;
    protected int rowNum;
    protected boolean closed;
    protected MongoStatement statement;
    protected boolean wasNull;
    protected MongoResultSetMetaData rsMetaData;
    protected MongoLogger logger;
    protected boolean extJsonMode;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_81;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_82;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_83;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_84;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_85;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_86;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_87;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_88;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_89;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_90;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_91;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_92;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_93;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_94;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_95;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_96;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_97;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_98;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_99;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_100;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_101;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_102;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_103;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_104;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_105;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_106;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_107;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_108;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_109;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_110;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_111;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_112;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_113;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_114;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_115;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_116;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_117;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_118;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_119;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_120;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_121;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_122;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_123;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_124;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_125;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_126;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_127;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_128;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_129;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_130;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_131;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_132;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_133;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_134;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_135;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_136;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_137;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_138;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_139;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_140;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_141;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_142;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_143;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_144;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_145;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_146;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_147;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_148;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_149;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_150;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_151;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_152;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_153;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_154;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_155;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_156;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_157;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_158;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_159;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_160;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_161;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_162;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_163;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_164;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_165;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_166;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_167;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_168;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_169;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_170;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_171;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_172;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_173;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_174;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_175;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_176;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_177;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_178;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_179;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_180;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_181;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_182;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_183;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_184;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_185;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_186;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_187;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_188;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_189;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_190;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_191;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_192;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_193;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_194;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_195;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_196;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_197;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_198;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_199;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_200;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_201;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_202;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_203;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_204;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_205;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_206;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_207;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_208;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_209;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_210;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_211;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_212;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_213;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_214;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_215;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_216;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_217;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_218;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_219;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_220;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_221;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_222;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_223;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_224;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_225;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoResultSet.ajc$preClinit();
        UTC = TimeZone.getTimeZone("UTC");
    }

    public MongoResultSet(MongoStatement statement, MongoCursor<BsonDocument> cursor, MongoJsonSchema schema, List<List<String>> selectOrder, boolean extJsonMode) throws SQLException {
        LoggingAspect.ajc$perObjectBind(this);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.rowNum = 0;
        this.closed = false;
        this.wasNull = false;
        Preconditions.checkNotNull((Object)statement);
        this.statement = statement;
        MongoLogger mongoLogger = new MongoLogger(this.getClass().getCanonicalName(), statement.getParentLogger(), statement.getStatementId());
        MongoResultSet mongoResultSet = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoResultSet.logger_aroundBody1$advice(this, mongoResultSet, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoResultSet.logger = mongoLogger;
        }
        this.extJsonMode = extJsonMode;
        this.setUpResultset(cursor, schema, selectOrder, true, statement.getParentLogger(), statement.getStatementId());
    }

    public MongoResultSet(MongoLogger parentLogger, MongoCursor<BsonDocument> cursor, MongoJsonSchema schema) throws SQLException {
        LoggingAspect.ajc$perObjectBind(this);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.rowNum = 0;
        this.closed = false;
        this.wasNull = false;
        MongoLogger mongoLogger = new MongoLogger(this.getClass().getCanonicalName(), parentLogger);
        MongoResultSet mongoResultSet = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoResultSet.logger_aroundBody3$advice(this, mongoResultSet, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoResultSet.logger = mongoLogger;
        }
        this.setUpResultset(cursor, schema, null, false, parentLogger, null);
    }

    private void setUpResultset(MongoCursor<BsonDocument> cursor, MongoJsonSchema schema, List<List<String>> selectOrder, boolean sortFieldsAlphabetically, MongoLogger parentLogger, Integer statementId) throws SQLException {
        try {
            Preconditions.checkNotNull(cursor);
            this.dateFormat.setTimeZone(UTC);
            this.cursor = cursor;
            this.rsMetaData = new MongoResultSetMetaData(schema, selectOrder, sortFieldsAlphabetically, parentLogger, statementId);
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    BsonDocument getCurrent() {
        try {
            return this.current;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    private void checkBounds(int i) throws SQLException {
        try {
            this.checkClosed();
            if (this.current == null) {
                throw new SQLException("No current row in the result set. Make sure to call next().");
            }
            if (i > this.rsMetaData.getColumnCount()) {
                throw new SQLException("Index out of bounds: '" + i + "'.");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            this.checkClosed();
            boolean result = this.cursor.hasNext();
            if (result) {
                this.current = (BsonDocument)this.cursor.next();
                ++this.rowNum;
            }
            return result;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this));
            }
            if (this.closed) {
                return;
            }
            this.cursor.close();
            this.closed = true;
            if (this.statement != null && !this.statement.isClosed && this.statement.isCloseOnCompletion()) {
                this.statement.close();
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this));
            }
            this.checkClosed();
            return !this.cursor.hasNext();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    private BsonValue getBsonValue(int columnIndex) throws SQLException {
        try {
            this.checkBounds(columnIndex);
            MongoColumnInfo columnInfo = this.rsMetaData.getColumnInfo(columnIndex);
            BsonDocument datasource = this.current.get((Object)columnInfo.getTableName()).asDocument();
            return datasource.get((Object)columnInfo.getColumnName());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    private BsonValue getBsonValue(String columnLabel) throws SQLException {
        try {
            if (this.rsMetaData.hasColumnWithLabel(columnLabel)) {
                try {
                    int columnIndex = this.rsMetaData.getColumnPositionFromLabel(columnLabel);
                    return this.getBsonValue(columnIndex + 1);
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage());
                }
            }
            throw new SQLException(String.format("column label '%s' not found", columnLabel));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    private void checkClosed() throws SQLException {
        try {
            if (this.closed) {
                throw new SQLException("MongoResultSet is closed.");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.wasNull;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    private boolean checkNull(BsonValue obj) throws SQLException {
        try {
            this.wasNull = false;
            if (obj == null) {
                this.wasNull = true;
                return true;
            }
            switch (BsonTypeInfo.getBsonTypeInfoFromBsonValue(obj).getBsonType()) {
                case UNDEFINED: 
                case NULL: {
                    this.wasNull = true;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        int n = columnIndex;
        int n2 = scale;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    private byte[] handleBytesConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to blob.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    private byte[] getBytes(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            BsonTypeInfo bsonType = BsonTypeInfo.getBsonTypeInfoFromBsonValue(o);
            switch (bsonType.getBsonType()) {
                case BINARY: {
                    return o.asBinary().getData();
                }
                case NULL: {
                    return null;
                }
                case UNDEFINED: {
                    return null;
                }
            }
            return this.handleBytesConversionFailure(bsonType.getBsonName());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getBytes(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getBytes(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    protected static ByteArrayInputStream getNewByteArrayInputStream(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            try {
                return MongoResultSet.getNewByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("The JVM claims not to support the encoding: ASCII.");
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string));
            }
            try {
                return MongoResultSet.getNewByteArrayInputStream(this.getString(columnLabel).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("The JVM claims not to support the encoding: ASCII.");
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            try {
                return MongoResultSet.getNewByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("The JVM claims not to support the encoding: UTF-8.");
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string));
            }
            try {
                return MongoResultSet.getNewByteArrayInputStream(this.getString(columnLabel).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("The JVM claims not to support the encoding: UTF-8.");
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return MongoResultSet.getNewByteArrayInputStream(this.getBytes(columnIndex));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string));
            }
            return MongoResultSet.getNewByteArrayInputStream(this.getBytes(columnLabel));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    private String handleStringConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to string.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    private String getString(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            return new MongoBsonValue(o, this.extJsonMode).toString();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getString(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getString(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_25);
            }
            throw exception;
        }
    }

    private boolean handleBooleanConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to boolean.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_26);
            }
            throw exception;
        }
    }

    private boolean getBoolean(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return false;
            }
            BsonTypeInfo bsonType = BsonTypeInfo.getBsonTypeInfoFromBsonValue(o);
            switch (bsonType.getBsonType()) {
                case BOOLEAN: {
                    return o.asBoolean().getValue();
                }
                case DECIMAL128: {
                    Decimal128 v = o.asDecimal128().getValue();
                    return !Objects.equals(v, Decimal128.POSITIVE_ZERO) && !Objects.equals(v, Decimal128.NEGATIVE_ZERO);
                }
                case DOUBLE: {
                    return o.asDouble().getValue() != 0.0;
                }
                case INT32: {
                    return o.asInt32().getValue() != 0;
                }
                case INT64: {
                    return o.asInt64().getValue() != 0L;
                }
                case UNDEFINED: 
                case NULL: {
                    return false;
                }
                case STRING: {
                    return true;
                }
            }
            return this.handleBooleanConversionFailure(bsonType.getBsonName());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_27);
            }
            throw exception;
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getBoolean(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_28);
            }
            throw exception;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getBoolean(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_29);
            }
            throw exception;
        }
    }

    protected byte getByte(BsonValue o) throws SQLException {
        try {
            return (byte)this.getLong(o);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_30);
            }
            throw exception;
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getByte(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_31);
            }
            throw exception;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getByte(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_32);
            }
            throw exception;
        }
    }

    private short getShort(BsonValue o) throws SQLException {
        try {
            return (short)this.getLong(o);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_33);
            }
            throw exception;
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getShort(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_34);
            }
            throw exception;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getShort(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_35);
            }
            throw exception;
        }
    }

    private int getInt(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return 0;
            }
            return (int)this.getLong(o);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_36);
            }
            throw exception;
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getInt(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_37);
            }
            throw exception;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getInt(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_38);
            }
            throw exception;
        }
    }

    private long handleLongConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to integral type.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_39);
            }
            throw exception;
        }
    }

    private long getLong(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return 0L;
            }
            BsonTypeInfo bsonType = BsonTypeInfo.getBsonTypeInfoFromBsonValue(o);
            switch (o.getBsonType()) {
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? 1 : 0;
                }
                case DATE_TIME: {
                    return o.asDateTime().getValue();
                }
                case DECIMAL128: {
                    return o.asDecimal128().longValue();
                }
                case DOUBLE: {
                    return (long)o.asDouble().getValue();
                }
                case INT32: {
                    return o.asInt32().getValue();
                }
                case INT64: {
                    return o.asInt64().getValue();
                }
                case NULL: {
                    return 0L;
                }
                case STRING: {
                    try {
                        return Long.parseLong(o.asString().getValue());
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException(e);
                    }
                }
                case UNDEFINED: {
                    return 0L;
                }
            }
            return this.handleLongConversionFailure(bsonType.getBsonName());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_40);
            }
            throw exception;
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getLong(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_41);
            }
            throw exception;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getLong(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_42);
            }
            throw exception;
        }
    }

    private float getFloat(BsonValue o) throws SQLException {
        try {
            return (float)this.getDouble(o);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_43);
            }
            throw exception;
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getFloat(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_44);
            }
            throw exception;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getFloat(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_45);
            }
            throw exception;
        }
    }

    private double handleDoubleConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to double.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_46);
            }
            throw exception;
        }
    }

    private double getDouble(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return 0.0;
            }
            BsonTypeInfo bsonType = BsonTypeInfo.getBsonTypeInfoFromBsonValue(o);
            switch (o.getBsonType()) {
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? 1.0 : 0.0;
                }
                case DATE_TIME: {
                    return o.asDateTime().getValue();
                }
                case DECIMAL128: {
                    return o.asDecimal128().doubleValue();
                }
                case DOUBLE: {
                    return o.asDouble().getValue();
                }
                case INT32: {
                    return o.asInt32().getValue();
                }
                case INT64: {
                    return o.asInt64().getValue();
                }
                case STRING: {
                    try {
                        return Double.parseDouble(o.asString().getValue());
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException(e);
                    }
                }
                case UNDEFINED: 
                case NULL: {
                    return 0.0;
                }
            }
            return this.handleDoubleConversionFailure(bsonType.getBsonName());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_47);
            }
            throw exception;
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getDouble(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_48);
            }
            throw exception;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getDouble(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_49);
            }
            throw exception;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        String string = columnLabel;
        int n = scale;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_50);
            }
            throw exception;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this));
            }
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_51);
            }
            throw exception;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this));
            }
            this.checkClosed();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_52);
            }
            throw exception;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_53);
            }
            throw exception;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.rsMetaData;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_54);
            }
            throw exception;
        }
    }

    private Object getObject(BsonValue o, int columnType) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            switch (columnType) {
                case -5: {
                    return this.getLong(o);
                }
                case -6: 
                case 4: 
                case 5: {
                    return this.getInt(o);
                }
                case -4: 
                case -3: 
                case -2: {
                    return o.asBinary().getData();
                }
                case -7: 
                case 16: {
                    return this.getBoolean(o);
                }
                case 6: 
                case 8: {
                    return this.getDouble(o);
                }
                case 2: 
                case 3: {
                    return o.asDecimal128().decimal128Value().bigDecimalValue();
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(o);
                }
                case 7: {
                    return Float.valueOf(this.getFloat(o));
                }
                case 93: {
                    return new Timestamp(o.asDateTime().getValue());
                }
                case 0: {
                    return null;
                }
                case 1111: {
                    if (o.getBsonType() == BsonType.NULL) {
                        return null;
                    }
                    return new MongoBsonValue(o, this.extJsonMode);
                }
            }
            throw new SQLException("getObject not supported for column type " + columnType);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_55);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            int columnType = this.rsMetaData.getColumnType(columnIndex);
            return this.getObject(out, columnType);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_56);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)string));
            }
            int columnIndex = this.findColumn(columnLabel);
            return this.getObject(columnIndex);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_57);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        int n = columnIndex;
        Map<String, Class<?>> map2 = map;
        try {
            BsonValue out;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), map2));
            }
            if (this.checkNull(out = this.getBsonValue(columnIndex))) {
                return null;
            }
            String columnTypeName = this.rsMetaData.getColumnTypeName(columnIndex);
            Class<?> type = map.get(columnTypeName);
            if (type == null) {
                return null;
            }
            return type.cast(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_58);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        String string = columnLabel;
        Map<String, Class<?>> map2 = map;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object)string, map2));
            }
            return this.getObject(this.findColumn(columnLabel), map);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_59);
            }
            throw exception;
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        int n = columnIndex;
        Class<T> clazz = type;
        try {
            BsonValue out;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), clazz));
            }
            if (this.checkNull(out = this.getBsonValue(columnIndex))) {
                return null;
            }
            return type.cast(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_60);
            }
            throw exception;
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        String string = columnLabel;
        Class<T> clazz = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this, (Object)string, clazz));
            }
            return this.getObject(this.findColumn(columnLabel), type);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_61);
            }
            throw exception;
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this, (Object)string));
            }
            this.checkClosed();
            if (!this.rsMetaData.hasColumnWithLabel(columnLabel)) {
                throw new SQLException("No such column: '" + columnLabel + "'.");
            }
            try {
                return this.rsMetaData.getColumnPositionFromLabel(columnLabel) + 1;
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_62);
            }
            throw exception;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_63);
            }
            throw exception;
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_64);
            }
            throw exception;
        }
    }

    private BigDecimal handleBigDecimalConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to BigDecimal.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_65);
            }
            throw exception;
        }
    }

    private BigDecimal getBigDecimal(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return BigDecimal.ZERO;
            }
            BsonTypeInfo bsonType = BsonTypeInfo.getBsonTypeInfoFromBsonValue(o);
            switch (o.getBsonType()) {
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? BigDecimal.ONE : BigDecimal.ZERO;
                }
                case DATE_TIME: {
                    return new BigDecimal(o.asDateTime().getValue());
                }
                case DECIMAL128: {
                    return o.asDecimal128().decimal128Value().bigDecimalValue();
                }
                case DOUBLE: {
                    return new BigDecimal(o.asDouble().getValue());
                }
                case INT32: {
                    return new BigDecimal(o.asInt32().getValue());
                }
                case INT64: {
                    return new BigDecimal(o.asInt64().getValue());
                }
                case UNDEFINED: 
                case NULL: {
                    return BigDecimal.ZERO;
                }
                case STRING: {
                    try {
                        return new BigDecimal(o.asString().getValue());
                    }
                    catch (ArithmeticException | NumberFormatException e) {
                        throw new SQLException(e);
                    }
                }
            }
            return this.handleBigDecimalConversionFailure(bsonType.getBsonName());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_66);
            }
            throw exception;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getBigDecimal(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_67);
            }
            throw exception;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getBigDecimal(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_68);
            }
            throw exception;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_69);
            }
            throw exception;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_70);
            }
            throw exception;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_71, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.rowNum == 1;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_71);
            }
            throw exception;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_72, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_72);
            }
            throw exception;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_73, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_73);
            }
            throw exception;
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_74, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_74);
            }
            throw exception;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_75, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_75);
            }
            throw exception;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_76, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.rowNum;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_76);
            }
            throw exception;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        int n = row;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_77, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_77);
            }
            throw exception;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        int n = rows;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_78, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_78);
            }
            throw exception;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_79, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_79);
            }
            throw exception;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        int n = direction;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_80, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_80);
            }
            throw exception;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_81, (Object)this, (Object)this));
            }
            this.checkClosed();
            return 1000;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_81);
            }
            throw exception;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        int n = rows;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_82, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_82);
            }
            throw exception;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_83, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_83);
            }
            throw exception;
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_84, (Object)this, (Object)this));
            }
            this.checkClosed();
            return 1003;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_84);
            }
            throw exception;
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_85, (Object)this, (Object)this));
            }
            this.checkClosed();
            return 1007;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_85);
            }
            throw exception;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_86, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_86);
            }
            throw exception;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_87, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_87);
            }
            throw exception;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_88, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_88);
            }
            throw exception;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_89, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_89);
            }
            throw exception;
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        int n = columnIndex;
        boolean bl = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_90, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.booleanObject((boolean)bl)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_90);
            }
            throw exception;
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        int n = columnIndex;
        byte by = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_91, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.byteObject((byte)by)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_91);
            }
            throw exception;
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        int n = columnIndex;
        short s = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_92, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.shortObject((short)s)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_92);
            }
            throw exception;
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        int n = columnIndex;
        int n2 = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_93, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_93);
            }
            throw exception;
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        int n = columnIndex;
        long l = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_94, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.longObject((long)l)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_94);
            }
            throw exception;
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        int n = columnIndex;
        float f = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_95, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.floatObject((float)f)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_95);
            }
            throw exception;
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        int n = columnIndex;
        double d = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_96, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.doubleObject((double)d)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_96);
            }
            throw exception;
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        int n = columnIndex;
        BigDecimal bigDecimal = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_97, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)bigDecimal));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_97);
            }
            throw exception;
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        int n = columnIndex;
        String string = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_98, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_98);
            }
            throw exception;
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        int n = columnIndex;
        byte[] byArray = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_99, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)byArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_99);
            }
            throw exception;
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        int n = columnIndex;
        Date date = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_100, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)date));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_100);
            }
            throw exception;
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        int n = columnIndex;
        Time time = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_101, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)time));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_101);
            }
            throw exception;
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        int n = columnIndex;
        Timestamp timestamp = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_102, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)timestamp));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_102);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        int n2 = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream, Conversions.intObject((int)n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_103, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_103);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        int n2 = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream, Conversions.intObject((int)n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_104, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_104);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        int n2 = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader, Conversions.intObject((int)n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_105, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_105);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        int n = columnIndex;
        Object object = x;
        int n2 = scaleOrLength;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), object, Conversions.intObject((int)n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_106, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_106);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        int n = columnIndex;
        Object object = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_107, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)object));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_107);
            }
            throw exception;
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_108, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_108);
            }
            throw exception;
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        String string = columnLabel;
        boolean bl = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_109, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_109);
            }
            throw exception;
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        String string = columnLabel;
        byte by = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_110, (Object)this, (Object)this, (Object)string, (Object)Conversions.byteObject((byte)by)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_110);
            }
            throw exception;
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        String string = columnLabel;
        short s = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_111, (Object)this, (Object)this, (Object)string, (Object)Conversions.shortObject((short)s)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_111);
            }
            throw exception;
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        String string = columnLabel;
        int n = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_112, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_112);
            }
            throw exception;
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        String string = columnLabel;
        long l = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_113, (Object)this, (Object)this, (Object)string, (Object)Conversions.longObject((long)l)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_113);
            }
            throw exception;
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        String string = columnLabel;
        float f = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_114, (Object)this, (Object)this, (Object)string, (Object)Conversions.floatObject((float)f)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_114);
            }
            throw exception;
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        String string = columnLabel;
        double d = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_115, (Object)this, (Object)this, (Object)string, (Object)Conversions.doubleObject((double)d)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_115);
            }
            throw exception;
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        String string = columnLabel;
        BigDecimal bigDecimal = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_116, (Object)this, (Object)this, (Object)string, (Object)bigDecimal));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_116);
            }
            throw exception;
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        String string = columnLabel;
        String string2 = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_117, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_117);
            }
            throw exception;
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        String string = columnLabel;
        byte[] byArray = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_118, (Object)this, (Object)this, (Object)string, (Object)byArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_118);
            }
            throw exception;
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        String string = columnLabel;
        Date date = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_119, (Object)this, (Object)this, (Object)string, (Object)date));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_119);
            }
            throw exception;
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        String string = columnLabel;
        Time time = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_120, (Object)this, (Object)this, (Object)string, (Object)time));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_120);
            }
            throw exception;
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        String string = columnLabel;
        Timestamp timestamp = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_121, (Object)this, (Object)this, (Object)string, (Object)timestamp));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_121);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        int n = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream, Conversions.intObject((int)n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_122, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_122);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        int n = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream, Conversions.intObject((int)n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_123, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_123);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        int n = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.intObject((int)n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_124, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_124);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        String string = columnLabel;
        Object object = x;
        int n = scaleOrLength;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, object, Conversions.intObject((int)n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_125, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_125);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        String string = columnLabel;
        Object object = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_126, (Object)this, (Object)this, (Object)string, (Object)object));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_126);
            }
            throw exception;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_127, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_127);
            }
            throw exception;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_128, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_128);
            }
            throw exception;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_129, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_129);
            }
            throw exception;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_130, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_130);
            }
            throw exception;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_131, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_131);
            }
            throw exception;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_132, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_132);
            }
            throw exception;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_133, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_133);
            }
            throw exception;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_134, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.statement;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_134);
            }
            throw exception;
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_135, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_135);
            }
            throw exception;
        }
    }

    protected Blob getNewBlob(byte[] bytes) throws SQLException {
        try {
            if (bytes == null) {
                return null;
            }
            try {
                return new SerialBlob(bytes);
            }
            catch (SerialException e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_136);
            }
            throw exception;
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_137, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getNewBlob(this.getBytes(out));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_137);
            }
            throw exception;
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_138, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getNewBlob(this.getBytes(out));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_138);
            }
            throw exception;
        }
    }

    protected Clob getClob(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            return new SerialClob(this.getString(o).toCharArray());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_139);
            }
            throw exception;
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_140, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getClob(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_140);
            }
            throw exception;
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_141, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getClob(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_141);
            }
            throw exception;
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_142, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_142);
            }
            throw exception;
        }
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_143, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_143);
            }
            throw exception;
        }
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_144, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_144);
            }
            throw exception;
        }
    }

    private java.util.Date handleUtilDateConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to java.util.Date");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_145);
            }
            throw exception;
        }
    }

    private java.util.Date getUtilDate(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            BsonTypeInfo bsonType = BsonTypeInfo.getBsonTypeInfoFromBsonValue(o);
            switch (o.getBsonType()) {
                case DATE_TIME: {
                    return new java.util.Date(o.asDateTime().getValue());
                }
                case DECIMAL128: {
                    return new Date(o.asDecimal128().longValue());
                }
                case DOUBLE: {
                    return new Date((long)o.asDouble().getValue());
                }
                case INT32: {
                    return new Date(o.asInt32().getValue());
                }
                case INT64: {
                    return new Date(o.asInt64().getValue());
                }
                case UNDEFINED: 
                case NULL: {
                    return null;
                }
                case STRING: {
                    try {
                        return this.dateFormat.parse(o.asString().getValue());
                    }
                    catch (ParseException e) {
                        throw new SQLException(e);
                    }
                }
            }
            return this.handleUtilDateConversionFailure(bsonType.getBsonName());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_146);
            }
            throw exception;
        }
    }

    private Date getDate(BsonValue o) throws SQLException {
        try {
            java.util.Date utilDate = this.getUtilDate(o);
            return utilDate == null ? null : new Date(utilDate.getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_147);
            }
            throw exception;
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_148, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getDate(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_148);
            }
            throw exception;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_149, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getDate(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_149);
            }
            throw exception;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        int n = columnIndex;
        Calendar calendar = cal;
        try {
            Date d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_150, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)calendar));
            }
            if ((d = this.getDate(columnIndex)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Date(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_150);
            }
            throw exception;
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        String string = columnLabel;
        Calendar calendar = cal;
        try {
            Date d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_151, (Object)this, (Object)this, (Object)string, (Object)calendar));
            }
            if ((d = this.getDate(columnLabel)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Date(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_151);
            }
            throw exception;
        }
    }

    protected Time getTime(BsonValue o) throws SQLException {
        try {
            java.util.Date utilDate = this.getUtilDate(o);
            return utilDate == null ? null : new Time(utilDate.getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_152);
            }
            throw exception;
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_153, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getTime(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_153);
            }
            throw exception;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_154, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getTime(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_154);
            }
            throw exception;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        int n = columnIndex;
        Calendar calendar = cal;
        try {
            Time d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_155, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)calendar));
            }
            if ((d = this.getTime(columnIndex)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Time(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_155);
            }
            throw exception;
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        String string = columnLabel;
        Calendar calendar = cal;
        try {
            Time d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_156, (Object)this, (Object)this, (Object)string, (Object)calendar));
            }
            if ((d = this.getTime(columnLabel)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Time(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_156);
            }
            throw exception;
        }
    }

    protected Timestamp getTimestamp(BsonValue o) throws SQLException {
        try {
            java.util.Date utilDate = this.getUtilDate(o);
            return utilDate == null ? null : new Timestamp(utilDate.getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_157);
            }
            throw exception;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_158, (Object)this, (Object)this, (Object)string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getTimestamp(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_158);
            }
            throw exception;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_159, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getTimestamp(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_159);
            }
            throw exception;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        int n = columnIndex;
        Calendar calendar = cal;
        try {
            Timestamp d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_160, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)calendar));
            }
            if ((d = this.getTimestamp(columnIndex)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Timestamp(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_160);
            }
            throw exception;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        String string = columnLabel;
        Calendar calendar = cal;
        try {
            Timestamp d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_161, (Object)this, (Object)this, (Object)string, (Object)calendar));
            }
            if ((d = this.getTimestamp(columnLabel)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Timestamp(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_161);
            }
            throw exception;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_162, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_162);
            }
            throw exception;
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_163, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_163);
            }
            throw exception;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        int n = columnIndex;
        Ref ref = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_164, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)ref));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_164);
            }
            throw exception;
        }
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        String string = columnLabel;
        Ref ref = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_165, (Object)this, (Object)this, (Object)string, (Object)ref));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_165);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        int n = columnIndex;
        Blob blob = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_166, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)blob));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_166);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        String string = columnLabel;
        Blob blob = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_167, (Object)this, (Object)this, (Object)string, (Object)blob));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_167);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        int n = columnIndex;
        Clob clob = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_168, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)clob));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_168);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        String string = columnLabel;
        Clob clob = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_169, (Object)this, (Object)this, (Object)string, (Object)clob));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_169);
            }
            throw exception;
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        int n = columnIndex;
        Array array = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_170, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)array));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_170);
            }
            throw exception;
        }
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        String string = columnLabel;
        Array array = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_171, (Object)this, (Object)this, (Object)string, (Object)array));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_171);
            }
            throw exception;
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_172, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_172);
            }
            throw exception;
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_173, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_173);
            }
            throw exception;
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        int n = columnIndex;
        RowId rowId = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_174, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)rowId));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_174);
            }
            throw exception;
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        String string = columnLabel;
        RowId rowId = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_175, (Object)this, (Object)this, (Object)string, (Object)rowId));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_175);
            }
            throw exception;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_176, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_176);
            }
            throw exception;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_177, (Object)this, (Object)this));
            }
            return this.closed;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_177);
            }
            throw exception;
        }
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        int n = columnIndex;
        String string = nString;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_178, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_178);
            }
            throw exception;
        }
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        String string = columnLabel;
        String string2 = nString;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_179, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_179);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        int n = columnIndex;
        NClob nClob2 = nClob;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_180, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)nClob2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_180);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        String string = columnLabel;
        NClob nClob2 = nClob;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_181, (Object)this, (Object)this, (Object)string, (Object)nClob2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_181);
            }
            throw exception;
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_182, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_182);
            }
            throw exception;
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_183, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_183);
            }
            throw exception;
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_184, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_184);
            }
            throw exception;
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_185, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_185);
            }
            throw exception;
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        int n = columnIndex;
        SQLXML sQLXML = xmlObject;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_186, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)sQLXML));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_186);
            }
            throw exception;
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        String string = columnLabel;
        SQLXML sQLXML = xmlObject;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_187, (Object)this, (Object)this, (Object)string, (Object)sQLXML));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_187);
            }
            throw exception;
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_188, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return this.getString(columnIndex);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_188);
            }
            throw exception;
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_189, (Object)this, (Object)this, (Object)string));
            }
            return this.getString(columnLabel);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_189);
            }
            throw exception;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_190, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return new StringReader(this.getString(columnIndex));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_190);
            }
            throw exception;
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_191, (Object)this, (Object)this, (Object)string));
            }
            return new StringReader(this.getString(columnLabel));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_191);
            }
            throw exception;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_192, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_192);
            }
            throw exception;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_193, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_193);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_194, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_194);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_195, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_195);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_196, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_196);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_197, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_197);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_198, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_198);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_199, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_199);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream2 = inputStream;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), inputStream2, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_200, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_200);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream2 = inputStream;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream2, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_201, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_201);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        int n = columnIndex;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader2, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_202, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_202);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_203, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_203);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        int n = columnIndex;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), reader2, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_204, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_204);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.longObject((long)l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_205, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_205);
            }
            throw exception;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_206, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)reader));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_206);
            }
            throw exception;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_207, (Object)this, (Object)this, (Object)string, (Object)reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_207);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_208, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)inputStream));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_208);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_209, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)inputStream));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_209);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_210, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)reader));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_210);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_211, (Object)this, (Object)this, (Object)string, (Object)inputStream));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_211);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_212, (Object)this, (Object)this, (Object)string, (Object)inputStream));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_212);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_213, (Object)this, (Object)this, (Object)string, (Object)reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_213);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        int n = columnIndex;
        InputStream inputStream2 = inputStream;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_214, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)inputStream2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_214);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        String string = columnLabel;
        InputStream inputStream2 = inputStream;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_215, (Object)this, (Object)this, (Object)string, (Object)inputStream2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_215);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        int n = columnIndex;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_216, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_216);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_217, (Object)this, (Object)this, (Object)string, (Object)reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_217);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        int n = columnIndex;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_218, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_218);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_219, (Object)this, (Object)this, (Object)string, (Object)reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_219);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        int n = columnIndex;
        Object object = x;
        SQLType sQLType = targetSqlType;
        int n2 = scaleOrLength;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), object, sQLType, Conversions.intObject((int)n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_220, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_220);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        String string = columnLabel;
        Object object = x;
        SQLType sQLType = targetSqlType;
        int n = scaleOrLength;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, object, sQLType, Conversions.intObject((int)n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_221, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_221);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        int n = columnIndex;
        Object object = x;
        SQLType sQLType = targetSqlType;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), object, sQLType};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_222, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_222);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        String string = columnLabel;
        Object object = x;
        SQLType sQLType = targetSqlType;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, object, sQLType};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_223, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_223);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Class<?> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_224, (Object)this, (Object)this, clazz));
            }
            return iface.isInstance(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_224);
            }
            throw exception;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Class<T> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_225, (Object)this, (Object)this, clazz));
            }
            return (T)this;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_225);
            }
            throw exception;
        }
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(MongoResultSet ajc$this, MongoResultSet target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    private static final /* synthetic */ Object logger_aroundBody3$advice(MongoResultSet ajc$this, MongoResultSet target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoResultSet.java", MongoResultSet.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setUpResultset", "com.mongodb.jdbc.MongoResultSet", "com.mongodb.client.MongoCursor:com.mongodb.jdbc.MongoJsonSchema:java.util.List:boolean:com.mongodb.jdbc.logging.MongoLogger:java.lang.Integer", "cursor:schema:selectOrder:sortFieldsAlphabetically:parentLogger:statementId", "java.sql.SQLException", "void"), 130);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getCurrent", "com.mongodb.jdbc.MongoResultSet", "", "", "", "org.bson.BsonDocument"), 153);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkNull", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "obj", "java.sql.SQLException", "boolean"), 236);
        ajc$tjp_100 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateDate", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Date", "columnIndex:x", "java.sql.SQLException", "void"), 1034);
        ajc$tjp_101 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTime", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Time", "columnIndex:x", "java.sql.SQLException", "void"), 1040);
        ajc$tjp_102 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTimestamp", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Timestamp", "columnIndex:x", "java.sql.SQLException", "void"), 1046);
        ajc$tjp_103 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:int", "columnIndex:x:length", "java.sql.SQLException", "void"), 1052);
        ajc$tjp_104 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:int", "columnIndex:x:length", "java.sql.SQLException", "void"), 1059);
        ajc$tjp_105 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:int", "columnIndex:x:length", "java.sql.SQLException", "void"), 1066);
        ajc$tjp_106 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.Object:int", "columnIndex:x:scaleOrLength", "java.sql.SQLException", "void"), 1073);
        ajc$tjp_107 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.Object", "columnIndex:x", "java.sql.SQLException", "void"), 1079);
        ajc$tjp_108 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNull", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "void"), 1085);
        ajc$tjp_109 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBoolean", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:boolean", "columnLabel:x", "java.sql.SQLException", "void"), 1091);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBigDecimal", "com.mongodb.jdbc.MongoResultSet", "int:int", "columnIndex:scale", "java.sql.SQLException", "java.math.BigDecimal"), 254);
        ajc$tjp_110 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateByte", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:byte", "columnLabel:x", "java.sql.SQLException", "void"), 1097);
        ajc$tjp_111 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateShort", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:short", "columnLabel:x", "java.sql.SQLException", "void"), 1103);
        ajc$tjp_112 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateInt", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:int", "columnLabel:x", "java.sql.SQLException", "void"), 1109);
        ajc$tjp_113 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLong", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:long", "columnLabel:x", "java.sql.SQLException", "void"), 1115);
        ajc$tjp_114 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateFloat", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:float", "columnLabel:x", "java.sql.SQLException", "void"), 1121);
        ajc$tjp_115 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateDouble", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:double", "columnLabel:x", "java.sql.SQLException", "void"), 1127);
        ajc$tjp_116 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBigDecimal", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.math.BigDecimal", "columnLabel:x", "java.sql.SQLException", "void"), 1133);
        ajc$tjp_117 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateString", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.String", "columnLabel:x", "java.sql.SQLException", "void"), 1139);
        ajc$tjp_118 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBytes", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:[B", "columnLabel:x", "java.sql.SQLException", "void"), 1145);
        ajc$tjp_119 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateDate", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Date", "columnLabel:x", "java.sql.SQLException", "void"), 1151);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleBytesConversionFailure", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "from", "java.sql.SQLException", "[B"), 259);
        ajc$tjp_120 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTime", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Time", "columnLabel:x", "java.sql.SQLException", "void"), 1157);
        ajc$tjp_121 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTimestamp", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Timestamp", "columnLabel:x", "java.sql.SQLException", "void"), 1163);
        ajc$tjp_122 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:int", "columnLabel:x:length", "java.sql.SQLException", "void"), 1169);
        ajc$tjp_123 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:int", "columnLabel:x:length", "java.sql.SQLException", "void"), 1176);
        ajc$tjp_124 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:int", "columnLabel:reader:length", "java.sql.SQLException", "void"), 1183);
        ajc$tjp_125 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.Object:int", "columnLabel:x:scaleOrLength", "java.sql.SQLException", "void"), 1190);
        ajc$tjp_126 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.Object", "columnLabel:x", "java.sql.SQLException", "void"), 1196);
        ajc$tjp_127 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 1202);
        ajc$tjp_128 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 1208);
        ajc$tjp_129 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 1214);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getBytes", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "[B"), 263);
        ajc$tjp_130 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 1220);
        ajc$tjp_131 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelRowUpdates", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 1226);
        ajc$tjp_132 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "moveToInsertRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 1232);
        ajc$tjp_133 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "moveToCurrentRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 1238);
        ajc$tjp_134 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStatement", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "java.sql.Statement"), 1244);
        ajc$tjp_135 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRef", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Ref"), 1250);
        ajc$tjp_136 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getNewBlob", "com.mongodb.jdbc.MongoResultSet", "[B", "bytes", "java.sql.SQLException", "java.sql.Blob"), 1255);
        ajc$tjp_137 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBlob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Blob"), 1267);
        ajc$tjp_138 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBlob", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Blob"), 1273);
        ajc$tjp_139 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getClob", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.sql.Clob"), 1278);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBytes", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "[B"), 285);
        ajc$tjp_140 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Clob"), 1286);
        ajc$tjp_141 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClob", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Clob"), 1292);
        ajc$tjp_142 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getArray", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Array"), 1298);
        ajc$tjp_143 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRef", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Ref"), 1304);
        ajc$tjp_144 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getArray", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Array"), 1310);
        ajc$tjp_145 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleUtilDateConversionFailure", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "from", "java.sql.SQLException", "java.util.Date"), 1315);
        ajc$tjp_146 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getUtilDate", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.util.Date"), 1319);
        ajc$tjp_147 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDate", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.sql.Date"), 1350);
        ajc$tjp_148 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Date"), 1356);
        ajc$tjp_149 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Date"), 1362);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBytes", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "[B"), 291);
        ajc$tjp_150 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "com.mongodb.jdbc.MongoResultSet", "int:java.util.Calendar", "columnIndex:cal", "java.sql.SQLException", "java.sql.Date"), 1368);
        ajc$tjp_151 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.util.Calendar", "columnLabel:cal", "java.sql.SQLException", "java.sql.Date"), 1378);
        ajc$tjp_152 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getTime", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.sql.Time"), 1387);
        ajc$tjp_153 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTime", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Time"), 1393);
        ajc$tjp_154 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTime", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Time"), 1399);
        ajc$tjp_155 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTime", "com.mongodb.jdbc.MongoResultSet", "int:java.util.Calendar", "columnIndex:cal", "java.sql.SQLException", "java.sql.Time"), 1405);
        ajc$tjp_156 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTime", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.util.Calendar", "columnLabel:cal", "java.sql.SQLException", "java.sql.Time"), 1415);
        ajc$tjp_157 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.sql.Timestamp"), 1424);
        ajc$tjp_158 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Timestamp"), 1430);
        ajc$tjp_159 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Timestamp"), 1436);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAsciiStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.InputStream"), 304);
        ajc$tjp_160 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "int:java.util.Calendar", "columnIndex:cal", "java.sql.SQLException", "java.sql.Timestamp"), 1442);
        ajc$tjp_161 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.util.Calendar", "columnLabel:cal", "java.sql.SQLException", "java.sql.Timestamp"), 1452);
        ajc$tjp_162 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getURL", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.net.URL"), 1464);
        ajc$tjp_163 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getURL", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.net.URL"), 1470);
        ajc$tjp_164 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRef", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Ref", "columnIndex:x", "java.sql.SQLException", "void"), 1476);
        ajc$tjp_165 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRef", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Ref", "columnLabel:x", "java.sql.SQLException", "void"), 1482);
        ajc$tjp_166 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Blob", "columnIndex:x", "java.sql.SQLException", "void"), 1488);
        ajc$tjp_167 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Blob", "columnLabel:x", "java.sql.SQLException", "void"), 1494);
        ajc$tjp_168 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Clob", "columnIndex:x", "java.sql.SQLException", "void"), 1500);
        ajc$tjp_169 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Clob", "columnLabel:x", "java.sql.SQLException", "void"), 1506);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAsciiStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.InputStream"), 314);
        ajc$tjp_170 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateArray", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Array", "columnIndex:x", "java.sql.SQLException", "void"), 1512);
        ajc$tjp_171 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateArray", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Array", "columnLabel:x", "java.sql.SQLException", "void"), 1518);
        ajc$tjp_172 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRowId", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.RowId"), 1526);
        ajc$tjp_173 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRowId", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.RowId"), 1532);
        ajc$tjp_174 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRowId", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.RowId", "columnIndex:x", "java.sql.SQLException", "void"), 1538);
        ajc$tjp_175 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRowId", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.RowId", "columnLabel:x", "java.sql.SQLException", "void"), 1544);
        ajc$tjp_176 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHoldability", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 1550);
        ajc$tjp_177 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 1556);
        ajc$tjp_178 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNString", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.String", "columnIndex:nString", "java.sql.SQLException", "void"), 1561);
        ajc$tjp_179 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNString", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.String", "columnLabel:nString", "java.sql.SQLException", "void"), 1567);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnicodeStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.InputStream"), 325);
        ajc$tjp_180 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.NClob", "columnIndex:nClob", "java.sql.SQLException", "void"), 1573);
        ajc$tjp_181 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.NClob", "columnLabel:nClob", "java.sql.SQLException", "void"), 1579);
        ajc$tjp_182 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNClob", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.NClob"), 1585);
        ajc$tjp_183 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.NClob"), 1591);
        ajc$tjp_184 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSQLXML", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.SQLXML"), 1597);
        ajc$tjp_185 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSQLXML", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.SQLXML"), 1603);
        ajc$tjp_186 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateSQLXML", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.SQLXML", "columnIndex:xmlObject", "java.sql.SQLException", "void"), 1609);
        ajc$tjp_187 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateSQLXML", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.SQLXML", "columnLabel:xmlObject", "java.sql.SQLException", "void"), 1615);
        ajc$tjp_188 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNString", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.lang.String"), 1621);
        ajc$tjp_189 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNString", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.lang.String"), 1626);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnicodeStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.InputStream"), 336);
        ajc$tjp_190 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.Reader"), 1631);
        ajc$tjp_191 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.Reader"), 1636);
        ajc$tjp_192 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:long", "columnIndex:x:length", "java.sql.SQLException", "void"), 1641);
        ajc$tjp_193 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:long", "columnLabel:reader:length", "java.sql.SQLException", "void"), 1648);
        ajc$tjp_194 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:long", "columnIndex:x:length", "java.sql.SQLException", "void"), 1655);
        ajc$tjp_195 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:long", "columnIndex:x:length", "java.sql.SQLException", "void"), 1662);
        ajc$tjp_196 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:long", "columnIndex:x:length", "java.sql.SQLException", "void"), 1669);
        ajc$tjp_197 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:long", "columnLabel:x:length", "java.sql.SQLException", "void"), 1676);
        ajc$tjp_198 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:long", "columnLabel:x:length", "java.sql.SQLException", "void"), 1683);
        ajc$tjp_199 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:long", "columnLabel:reader:length", "java.sql.SQLException", "void"), 1690);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkBounds", "com.mongodb.jdbc.MongoResultSet", "int", "i", "java.sql.SQLException", "void"), 157);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBinaryStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.InputStream"), 346);
        ajc$tjp_200 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:long", "columnIndex:inputStream:length", "java.sql.SQLException", "void"), 1697);
        ajc$tjp_201 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:long", "columnLabel:inputStream:length", "java.sql.SQLException", "void"), 1704);
        ajc$tjp_202 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:long", "columnIndex:reader:length", "java.sql.SQLException", "void"), 1711);
        ajc$tjp_203 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:long", "columnLabel:reader:length", "java.sql.SQLException", "void"), 1717);
        ajc$tjp_204 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:long", "columnIndex:reader:length", "java.sql.SQLException", "void"), 1723);
        ajc$tjp_205 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:long", "columnLabel:reader:length", "java.sql.SQLException", "void"), 1729);
        ajc$tjp_206 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader", "columnIndex:x", "java.sql.SQLException", "void"), 1737);
        ajc$tjp_207 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader", "columnLabel:reader", "java.sql.SQLException", "void"), 1743);
        ajc$tjp_208 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream", "columnIndex:x", "java.sql.SQLException", "void"), 1750);
        ajc$tjp_209 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream", "columnIndex:x", "java.sql.SQLException", "void"), 1756);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBinaryStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.InputStream"), 351);
        ajc$tjp_210 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader", "columnIndex:x", "java.sql.SQLException", "void"), 1762);
        ajc$tjp_211 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream", "columnLabel:x", "java.sql.SQLException", "void"), 1768);
        ajc$tjp_212 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream", "columnLabel:x", "java.sql.SQLException", "void"), 1774);
        ajc$tjp_213 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader", "columnLabel:reader", "java.sql.SQLException", "void"), 1780);
        ajc$tjp_214 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream", "columnIndex:inputStream", "java.sql.SQLException", "void"), 1787);
        ajc$tjp_215 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream", "columnLabel:inputStream", "java.sql.SQLException", "void"), 1793);
        ajc$tjp_216 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader", "columnIndex:reader", "java.sql.SQLException", "void"), 1799);
        ajc$tjp_217 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader", "columnLabel:reader", "java.sql.SQLException", "void"), 1805);
        ajc$tjp_218 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader", "columnIndex:reader", "java.sql.SQLException", "void"), 1811);
        ajc$tjp_219 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader", "columnLabel:reader", "java.sql.SQLException", "void"), 1817);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleStringConversionFailure", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "from", "java.sql.SQLException", "java.lang.String"), 355);
        ajc$tjp_220 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.Object:java.sql.SQLType:int", "columnIndex:x:targetSqlType:scaleOrLength", "java.sql.SQLException", "void"), 1825);
        ajc$tjp_221 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.Object:java.sql.SQLType:int", "columnLabel:x:targetSqlType:scaleOrLength", "java.sql.SQLException", "void"), 1832);
        ajc$tjp_222 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.Object:java.sql.SQLType", "columnIndex:x:targetSqlType", "java.sql.SQLException", "void"), 1839);
        ajc$tjp_223 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.Object:java.sql.SQLType", "columnLabel:x:targetSqlType", "java.sql.SQLException", "void"), 1845);
        ajc$tjp_224 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWrapperFor", "com.mongodb.jdbc.MongoResultSet", "java.lang.Class", "iface", "java.sql.SQLException", "boolean"), 1853);
        ajc$tjp_225 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unwrap", "com.mongodb.jdbc.MongoResultSet", "java.lang.Class", "iface", "java.sql.SQLException", "java.lang.Object"), 1859);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getString", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.lang.String"), 359);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getString", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.lang.String"), 367);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getString", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.lang.String"), 373);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleBooleanConversionFailure", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "from", "java.sql.SQLException", "boolean"), 378);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getBoolean", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "boolean"), 382);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBoolean", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "boolean"), 416);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBoolean", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "boolean"), 422);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "next", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 168);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getByte", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "byte"), 427);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getByte", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "byte"), 434);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getByte", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "byte"), 440);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getShort", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "short"), 445);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getShort", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "short"), 452);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getShort", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "short"), 458);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getInt", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "int"), 463);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getInt", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "int"), 471);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getInt", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "int"), 477);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleLongConversionFailure", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "from", "java.sql.SQLException", "long"), 482);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 181);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getLong", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "long"), 486);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLong", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "long"), 523);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLong", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "long"), 529);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFloat", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "float"), 534);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFloat", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "float"), 539);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFloat", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "float"), 545);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleDoubleConversionFailure", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "from", "java.sql.SQLException", "double"), 550);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDouble", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "double"), 554);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDouble", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "double"), 590);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDouble", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "double"), 596);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isLast", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 193);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBigDecimal", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:int", "columnLabel:scale", "java.sql.SQLException", "java.math.BigDecimal"), 603);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWarnings", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "java.sql.SQLWarning"), 611);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearWarnings", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 617);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCursorName", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "java.lang.String"), 622);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetaData", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "java.sql.ResultSetMetaData"), 628);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getObject", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue:int", "o:columnType", "java.sql.SQLException", "java.lang.Object"), 633);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.lang.Object"), 704);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.lang.Object"), 711);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoResultSet", "int:java.util.Map", "columnIndex:map", "java.sql.SQLException", "java.lang.Object"), 717);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.util.Map", "columnLabel:map", "java.sql.SQLException", "java.lang.Object"), 732);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getBsonValue", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "org.bson.BsonValue"), 198);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.Class", "columnIndex:type", "java.sql.SQLException", "java.lang.Object"), 738);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.Class", "columnLabel:type", "java.sql.SQLException", "java.lang.Object"), 747);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findColumn", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "int"), 754);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.Reader"), 773);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.Reader"), 779);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleBigDecimalConversionFailure", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "from", "java.sql.SQLException", "java.math.BigDecimal"), 784);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getBigDecimal", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.math.BigDecimal"), 788);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBigDecimal", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.math.BigDecimal"), 824);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBigDecimal", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.math.BigDecimal"), 830);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isBeforeFirst", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 840);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getBsonValue", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "org.bson.BsonValue"), 205);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAfterLast", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 846);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isFirst", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 852);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "beforeFirst", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 858);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterLast", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 864);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "first", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 870);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "last", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 876);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 882);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "absolute", "com.mongodb.jdbc.MongoResultSet", "int", "row", "java.sql.SQLException", "boolean"), 888);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "relative", "com.mongodb.jdbc.MongoResultSet", "int", "rows", "java.sql.SQLException", "boolean"), 894);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "previous", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 900);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkClosed", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 219);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchDirection", "com.mongodb.jdbc.MongoResultSet", "int", "direction", "java.sql.SQLException", "void"), 910);
        ajc$tjp_81 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchDirection", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 916);
        ajc$tjp_82 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchSize", "com.mongodb.jdbc.MongoResultSet", "int", "rows", "java.sql.SQLException", "void"), 922);
        ajc$tjp_83 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchSize", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 928);
        ajc$tjp_84 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 934);
        ajc$tjp_85 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConcurrency", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 940);
        ajc$tjp_86 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rowUpdated", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 950);
        ajc$tjp_87 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rowInserted", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 956);
        ajc$tjp_88 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rowDeleted", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 962);
        ajc$tjp_89 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNull", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "void"), 968);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "wasNull", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 224);
        ajc$tjp_90 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBoolean", "com.mongodb.jdbc.MongoResultSet", "int:boolean", "columnIndex:x", "java.sql.SQLException", "void"), 974);
        ajc$tjp_91 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateByte", "com.mongodb.jdbc.MongoResultSet", "int:byte", "columnIndex:x", "java.sql.SQLException", "void"), 980);
        ajc$tjp_92 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateShort", "com.mongodb.jdbc.MongoResultSet", "int:short", "columnIndex:x", "java.sql.SQLException", "void"), 986);
        ajc$tjp_93 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateInt", "com.mongodb.jdbc.MongoResultSet", "int:int", "columnIndex:x", "java.sql.SQLException", "void"), 992);
        ajc$tjp_94 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLong", "com.mongodb.jdbc.MongoResultSet", "int:long", "columnIndex:x", "java.sql.SQLException", "void"), 998);
        ajc$tjp_95 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateFloat", "com.mongodb.jdbc.MongoResultSet", "int:float", "columnIndex:x", "java.sql.SQLException", "void"), 1004);
        ajc$tjp_96 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateDouble", "com.mongodb.jdbc.MongoResultSet", "int:double", "columnIndex:x", "java.sql.SQLException", "void"), 1010);
        ajc$tjp_97 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBigDecimal", "com.mongodb.jdbc.MongoResultSet", "int:java.math.BigDecimal", "columnIndex:x", "java.sql.SQLException", "void"), 1016);
        ajc$tjp_98 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateString", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.String", "columnIndex:x", "java.sql.SQLException", "void"), 1022);
        ajc$tjp_99 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBytes", "com.mongodb.jdbc.MongoResultSet", "int:[B", "columnIndex:x", "java.sql.SQLException", "void"), 1028);
    }
}

