/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.logging;

import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.runtime.internal.AroundClosure;
import org.bson.BsonValue;

@Aspect(value="perthis(execution(com.mongodb.jdbc.*.new(..)))")
public class LoggingAspect {
    private MongoLogger logger = null;

    @Pointcut(value="(set(com.mongodb.jdbc.logging.MongoLogger *) && (args(logger) && !within(com.mongodb.jdbc.logging.LoggingAspect)))", argNames="logger")
    /* synthetic */ void ajc$pointcut$$setLogger$17b(MongoLogger mongoLogger) {
    }

    @Around(value="setLogger(arg)", argNames="arg,ajc$aroundClosure")
    public Object ajc$around$com_mongodb_jdbc_logging_LoggingAspect$1$43703b69(MongoLogger arg, AroundClosure ajc$aroundClosure) {
        this.logger = arg;
        return ajc$aroundClosure.run(new Object[]{arg});
    }

    @Before(value="((execution(public * (@(AutoLoggable) com.mongodb.jdbc.*).*(..)) || execution(@(AutoLoggable) public * com.mongodb.jdbc.*.*(..))) && (!@annotation(com.mongodb.jdbc.logging.DisableAutoLogging) && !within(LoggingAspect)))", argNames="")
    public void ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(JoinPoint thisJoinPoint) {
        if (this.logger != null) {
            StringBuilder b = new StringBuilder(thisJoinPoint.getSignature().getName());
            Object[] params = thisJoinPoint.getArgs();
            if (params.length > 0) {
                b.append("(");
                int i = 0;
                while (i < params.length) {
                    if (params[i] instanceof String) {
                        b.append("***");
                    } else if (params[i] instanceof BsonValue) {
                        b.append("Bson");
                        char[] bsonTypeName = ((BsonValue)params[i]).getBsonType().toString().toLowerCase().toCharArray();
                        bsonTypeName[0] = Character.toUpperCase(bsonTypeName[0]);
                        b.append(bsonTypeName.toString());
                        b.append("{***}");
                    } else if (params[i] instanceof Properties) {
                        b.append(((Properties)params[i]).stringPropertyNames());
                    } else {
                        b.append(params[i]);
                    }
                    b.append(", ");
                    ++i;
                }
                b.delete(b.length() - 2, b.length());
                b.append(")");
            } else {
                b.append("()");
            }
            this.logger.logMethodEntry(thisJoinPoint.getSignature().getDeclaringTypeName(), b.toString());
        }
    }

    @AfterThrowing(pointcut="(execution(* *.*(..)) && !within(LoggingAspect))", throwing="e", argNames="e")
    public void ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(Exception e, JoinPoint.StaticPart thisJoinPointStaticPart) {
        if (this.logger != null) {
            this.logger.logError(thisJoinPointStaticPart.getSignature().getDeclaringTypeName(), "Error in " + thisJoinPointStaticPart.getSignature().toShortString(), e);
        }
    }

    public static LoggingAspect aspectOf(Object object) {
        LoggingAspect loggingAspect;
        block3: {
            block2: {
                if (!(object instanceof LoggingAspect$ajcMightHaveAspect)) break block2;
                loggingAspect = ((LoggingAspect$ajcMightHaveAspect)object).ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet();
                if (loggingAspect != null) break block3;
            }
            throw new NoAspectBoundException();
        }
        return loggingAspect;
    }

    public static boolean hasAspect(Object object) {
        return object instanceof LoggingAspect$ajcMightHaveAspect && ((LoggingAspect$ajcMightHaveAspect)object).ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() != null;
    }

    public static synchronized /* synthetic */ void ajc$perObjectBind(Object object) {
        if (object instanceof LoggingAspect$ajcMightHaveAspect && ((LoggingAspect$ajcMightHaveAspect)object).ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() == null) {
            ((LoggingAspect$ajcMightHaveAspect)object).ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(new LoggingAspect());
        }
    }

    public static /* synthetic */ MongoLogger ajc$inlineAccessFieldGet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(LoggingAspect loggingAspect) {
        return loggingAspect.logger;
    }
}

