/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.oidc.manualtests;

import com.mongodb.MongoCredential;
import com.mongodb.jdbc.oidc.JdbcOidcCallbackContext;
import com.mongodb.jdbc.oidc.OidcAuthFlow;
import com.mongodb.jdbc.oidc.manualtests.TestOidcUtils;
import java.time.Duration;

public class TestOidcAuthFlowAndRefresh {
    public static void main(String[] args) {
        OidcAuthFlow authFlow = new OidcAuthFlow();
        Duration timeout = Duration.ofMinutes(5L);
        JdbcOidcCallbackContext callbackContext = new JdbcOidcCallbackContext(timeout, 1, null, TestOidcUtils.IDP_INFO, null);
        MongoCredential.OidcCallbackResult result = TestOidcUtils.testAuthCodeFlow(callbackContext, authFlow);
        if (result != null) {
            JdbcOidcCallbackContext refreshContext = new JdbcOidcCallbackContext(timeout, 1, result.getRefreshToken(), TestOidcUtils.IDP_INFO, null);
            try {
                MongoCredential.OidcCallbackResult refreshResult = authFlow.doRefresh(refreshContext);
                if (refreshResult != null) {
                    System.out.println("Refreshed Access Token: " + refreshResult.getAccessToken());
                    System.out.println("Refreshed Refresh Token: " + refreshResult.getRefreshToken());
                } else {
                    System.out.println("Refresh token flow failed.");
                }
            }
            catch (Exception e) {
                System.err.println("An error occurred while running the refresh token flow: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

