/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.oidc.manualtests;

import com.mongodb.MongoCredential;
import com.mongodb.jdbc.oidc.JdbcIdpInfo;
import com.mongodb.jdbc.oidc.OidcAuthFlow;
import java.util.Collections;
import java.util.List;

public class TestOidcUtils {
    public static String OIDC_ISSUER = "https://mongodb-dev.okta.com/oauth2/ausqrxbcr53xakaRR357";
    public static String OIDC_CLIENT_ID = "0oarvap2r7PmNIBsS357";
    public static final List<String> OPENID_SCOPE = Collections.singletonList("openid");
    public static final MongoCredential.IdpInfo IDP_INFO = new JdbcIdpInfo(OIDC_ISSUER, OIDC_CLIENT_ID, OPENID_SCOPE);

    public static MongoCredential.OidcCallbackResult testAuthCodeFlow(MongoCredential.OidcCallbackContext callbackContext, OidcAuthFlow authFlow) {
        try {
            MongoCredential.OidcCallbackResult result = authFlow.doAuthCodeFlow(callbackContext);
            if (result != null) {
                System.out.println("Access Token: " + result.getAccessToken());
                System.out.println("Refresh Token: " + result.getRefreshToken());
                return result;
            }
            System.out.println("Authentication failed.");
        }
        catch (Exception e) {
            System.err.println("An error occurred while running the OIDC authentication flow: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }
}

