/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.oidc;

import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.oidc.OidcResponse;
import com.mongodb.jdbc.oidc.OidcTimeoutException;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class RFC8252HttpServer {
    public static final int DEFAULT_REDIRECT_PORT = 27097;
    private static final String LOGIN_ERROR_URI = "https://www.mongodb.com/docs/atlas/security-oidc";
    private static final String PRODUCT_DOCS_LINK = "https://www.mongodb.com/docs/atlas/data-federation/query/sql/drivers/odbc/connect";
    private static final String PRODUCT_DOCS_NAME = "Atlas SQL ODBC Driver";
    private static final String CODE = "code";
    private static final String LOCATION = "Location";
    private static final String STATE = "state";
    private static final String PRODUCT_DOCS_LINK_KEY = "product_docs_link";
    private static final String PRODUCT_DOCS_NAME_KEY = "product_docs_name";
    private static final String ERROR_URI_KEY = "error_uri";
    private static final String ERROR_KEY = "error";
    private static final String ERROR_DESCRIPTION_KEY = "error_description";
    private static final String ACCEPTED_ENDPOINT = "/accepted";
    private static final String CALLBACK_ENDPOINT = "/callback";
    private static final String REDIRECT_ENDPOINT = "/redirect";
    private HttpServer server;
    private final TemplateEngine templateEngine = this.createTemplateEngine();
    private final BlockingQueue<OidcResponse> oidcResponseQueue = new LinkedBlockingQueue<OidcResponse>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public void start() throws IOException {
        try {
            this.server = HttpServer.create(new InetSocketAddress(27097), 0);
            this.server.createContext(CALLBACK_ENDPOINT, new CallbackHandler());
            this.server.createContext(REDIRECT_ENDPOINT, new CallbackHandler());
            this.server.createContext(ACCEPTED_ENDPOINT, new AcceptedHandler());
            this.server.setExecutor(null);
            this.server.start();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    public OidcResponse getOidcResponse() throws InterruptedException, OidcTimeoutException {
        try {
            return this.getOidcResponse(Duration.ofSeconds(300L));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    public OidcResponse getOidcResponse(Duration timeout) throws OidcTimeoutException, InterruptedException {
        try {
            if (timeout == null) {
                return this.getOidcResponse();
            }
            OidcResponse response = this.oidcResponseQueue.poll(timeout.getSeconds(), TimeUnit.SECONDS);
            if (response == null) {
                throw new OidcTimeoutException("Timeout waiting for OIDC response");
            }
            return response;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    public void stop() {
        try {
            if (this.server != null) {
                this.server.stop(0);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    private TemplateEngine createTemplateEngine() {
        try {
            TemplateEngine templateEngine = new TemplateEngine();
            ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
            templateResolver.setPrefix("/templates/");
            templateResolver.setSuffix(".html");
            templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
            return templateEngine;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    private Map<String, String> parseQueryParams(HttpExchange exchange) throws UnsupportedEncodingException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            String rawQuery = exchange.getRequestURI().getRawQuery();
            if (rawQuery != null) {
                String[] params;
                String[] stringArray = params = rawQuery.split("&");
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    String param = stringArray[n2];
                    int equalsIndex = param.indexOf(61);
                    if (equalsIndex > 0) {
                        String key = param.substring(0, equalsIndex);
                        String encodedValue = param.substring(equalsIndex + 1);
                        String value = URLDecoder.decode(encodedValue, "UTF-8");
                        queryParams.put(key, value);
                    } else {
                        queryParams.put(param, "");
                    }
                    ++n2;
                }
            }
            return queryParams;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    private boolean putOidcResponse(HttpExchange exchange, OidcResponse oidcResponse) throws IOException {
        try {
            try {
                this.oidcResponseQueue.put(oidcResponse);
                return true;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                this.sendResponse(exchange, "<html><body><h1>Internal Server Error</h1></body></html>", 500);
                return false;
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    private void sendResponse(HttpExchange exchange, String response, int statusCode) throws IOException {
        try {
            exchange.getResponseHeaders().set("Content-Type", "text/html; charset=utf-8");
            try {
                try {
                    exchange.sendResponseHeaders(statusCode, response.getBytes(StandardCharsets.UTF_8).length);
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (OutputStream os = exchange.getResponseBody();){
                        os.write(response.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Logger logger = Logger.getLogger(RFC8252HttpServer.class.getName());
                    logger.log(Level.SEVERE, "Error sending response", e);
                    throw e;
                }
            }
            finally {
                exchange.close();
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    static {
        RFC8252HttpServer.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RFC8252HttpServer.java", RFC8252HttpServer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.mongodb.jdbc.oidc.RFC8252HttpServer", "", "", "java.io.IOException", "void"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOidcResponse", "com.mongodb.jdbc.oidc.RFC8252HttpServer", "", "", "java.lang.InterruptedException:com.mongodb.jdbc.oidc.OidcTimeoutException", "com.mongodb.jdbc.oidc.OidcResponse"), 105);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOidcResponse", "com.mongodb.jdbc.oidc.RFC8252HttpServer", "java.time.Duration", "timeout", "com.mongodb.jdbc.oidc.OidcTimeoutException:java.lang.InterruptedException", "com.mongodb.jdbc.oidc.OidcResponse"), 118);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.mongodb.jdbc.oidc.RFC8252HttpServer", "", "", "", "void"), 130);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTemplateEngine", "com.mongodb.jdbc.oidc.RFC8252HttpServer", "", "", "", "org.thymeleaf.TemplateEngine"), 141);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "parseQueryParams", "com.mongodb.jdbc.oidc.RFC8252HttpServer", "com.sun.net.httpserver.HttpExchange", "exchange", "java.io.UnsupportedEncodingException", "java.util.Map"), 227);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "putOidcResponse", "com.mongodb.jdbc.oidc.RFC8252HttpServer", "com.sun.net.httpserver.HttpExchange:com.mongodb.jdbc.oidc.OidcResponse", "exchange:oidcResponse", "java.io.IOException", "boolean"), 258);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "sendResponse", "com.mongodb.jdbc.oidc.RFC8252HttpServer", "com.sun.net.httpserver.HttpExchange:java.lang.String:int", "exchange:response:statusCode", "java.io.IOException", "void"), 279);
    }

    private class AcceptedHandler
    implements HttpHandler {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private AcceptedHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                Context context = new Context();
                context.setVariable(RFC8252HttpServer.PRODUCT_DOCS_LINK_KEY, (Object)RFC8252HttpServer.PRODUCT_DOCS_LINK);
                context.setVariable(RFC8252HttpServer.PRODUCT_DOCS_NAME_KEY, (Object)RFC8252HttpServer.PRODUCT_DOCS_NAME);
                String acceptedHtml = RFC8252HttpServer.this.templateEngine.process("OIDCAcceptedTemplate", (IContext)context);
                RFC8252HttpServer.this.sendResponse(exchange, acceptedHtml, 200);
                return;
            }
            catch (Exception exception) {
                if (LoggingAspect.hasAspect(this)) {
                    LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
                }
                throw exception;
            }
        }

        static {
            AcceptedHandler.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("RFC8252HttpServer.java", AcceptedHandler.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handle", "com.mongodb.jdbc.oidc.RFC8252HttpServer$AcceptedHandler", "com.sun.net.httpserver.HttpExchange", "exchange", "java.io.IOException", "void"), 211);
        }
    }

    private class CallbackHandler
    implements HttpHandler {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private CallbackHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                Map queryParams = RFC8252HttpServer.this.parseQueryParams(exchange);
                OidcResponse oidcResponse = new OidcResponse();
                if (queryParams.containsKey(RFC8252HttpServer.CODE)) {
                    oidcResponse.setCode((String)queryParams.get(RFC8252HttpServer.CODE));
                    oidcResponse.setState(queryParams.getOrDefault(RFC8252HttpServer.STATE, ""));
                    if (!RFC8252HttpServer.this.putOidcResponse(exchange, oidcResponse)) {
                        return;
                    }
                    exchange.getResponseHeaders().set(RFC8252HttpServer.LOCATION, RFC8252HttpServer.ACCEPTED_ENDPOINT);
                    RFC8252HttpServer.this.sendResponse(exchange, "", 302);
                } else if (queryParams.containsKey(RFC8252HttpServer.ERROR_KEY)) {
                    oidcResponse.setError((String)queryParams.get(RFC8252HttpServer.ERROR_KEY));
                    oidcResponse.setErrorDescription(queryParams.getOrDefault(RFC8252HttpServer.ERROR_DESCRIPTION_KEY, "Unknown error"));
                    if (!RFC8252HttpServer.this.putOidcResponse(exchange, oidcResponse)) {
                        return;
                    }
                    Context context = new Context();
                    context.setVariable(RFC8252HttpServer.ERROR_URI_KEY, (Object)RFC8252HttpServer.LOGIN_ERROR_URI);
                    context.setVariable(RFC8252HttpServer.PRODUCT_DOCS_LINK_KEY, (Object)RFC8252HttpServer.PRODUCT_DOCS_LINK);
                    context.setVariable(RFC8252HttpServer.PRODUCT_DOCS_NAME_KEY, (Object)RFC8252HttpServer.PRODUCT_DOCS_NAME);
                    context.setVariable(RFC8252HttpServer.ERROR_KEY, queryParams.get(RFC8252HttpServer.ERROR_KEY));
                    context.setVariable(RFC8252HttpServer.ERROR_DESCRIPTION_KEY, (Object)queryParams.getOrDefault(RFC8252HttpServer.ERROR_DESCRIPTION_KEY, "Unknown error"));
                    String errorHtml = RFC8252HttpServer.this.templateEngine.process("OIDCErrorTemplate", (IContext)context);
                    RFC8252HttpServer.this.sendResponse(exchange, errorHtml, 400);
                } else {
                    oidcResponse.setError("Not found");
                    String allParams = queryParams.entrySet().stream().map(entry -> String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue()).reduce((param1, param2) -> String.valueOf(param1) + ", " + param2).orElse("No parameters");
                    oidcResponse.setErrorDescription("Not found. Parameters: " + allParams);
                    if (!RFC8252HttpServer.this.putOidcResponse(exchange, oidcResponse)) {
                        return;
                    }
                    Context context = new Context();
                    context.setVariable(RFC8252HttpServer.PRODUCT_DOCS_LINK_KEY, (Object)RFC8252HttpServer.PRODUCT_DOCS_LINK);
                    context.setVariable(RFC8252HttpServer.PRODUCT_DOCS_NAME_KEY, (Object)RFC8252HttpServer.PRODUCT_DOCS_NAME);
                    String notFoundHtml = RFC8252HttpServer.this.templateEngine.process("OIDCNotFoundTemplate", (IContext)context);
                    RFC8252HttpServer.this.sendResponse(exchange, notFoundHtml, 404);
                }
                return;
            }
            catch (Exception exception) {
                if (LoggingAspect.hasAspect(this)) {
                    LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
                }
                throw exception;
            }
        }

        static {
            CallbackHandler.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("RFC8252HttpServer.java", CallbackHandler.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handle", "com.mongodb.jdbc.oidc.RFC8252HttpServer$CallbackHandler", "com.sun.net.httpserver.HttpExchange", "exchange", "java.io.IOException", "void"), 154);
        }
    }
}

