/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.MuleCoreExtension;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.MuleDeploymentService;
import org.mule.module.launcher.MulePluginClassLoaderManager;
import org.mule.module.launcher.PluginClassLoaderManager;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.coreextension.DefaultMuleCoreExtensionManager;
import org.mule.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.mule.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyResolver;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;
import org.mule.util.StringUtils;

public class FakeMuleServer {
    protected static final int DEPLOYMENT_TIMEOUT = 20000;
    private File muleHome;
    private File appsDir;
    private File domainsDir;
    private File logsDir;
    private File pluginsDir;
    private final DeploymentService deploymentService;
    private final DeploymentListener deploymentListener;
    private final List<MuleCoreExtension> coreExtensions;
    public static final String FAKE_SERVER_DISABLE_LOG_REPOSITORY_SELECTOR = "fake.server.disablelogrepositoryselector";
    private DefaultMuleCoreExtensionManager coreExtensionManager;

    public FakeMuleServer(String muleHomePath) {
        this(muleHomePath, new LinkedList<MuleCoreExtension>());
    }

    public FakeMuleServer(String muleHomePath, List<MuleCoreExtension> intialCoreExtensions) {
        this.coreExtensions = intialCoreExtensions;
        this.muleHome = new File(muleHomePath);
        this.muleHome.deleteOnExit();
        try {
            System.setProperty("mule.home", this.getMuleHome().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.setMuleFolders();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deploymentService = new MuleDeploymentService((PluginClassLoaderManager)new MulePluginClassLoaderManager());
        this.deploymentListener = (DeploymentListener)Mockito.mock(DeploymentListener.class);
        this.deploymentService.addDeploymentListener(this.deploymentListener);
        this.coreExtensionManager = new DefaultMuleCoreExtensionManager(new MuleCoreExtensionDiscoverer(){

            public List<MuleCoreExtension> discover() throws DefaultMuleException {
                return FakeMuleServer.this.coreExtensions;
            }
        }, (MuleCoreExtensionDependencyResolver)new ReflectionMuleCoreExtensionDependencyResolver());
        this.coreExtensionManager.setDeploymentService(this.deploymentService);
    }

    public void stop() throws MuleException {
        this.deploymentService.stop();
        this.coreExtensionManager.stop();
        this.coreExtensionManager.dispose();
    }

    public void start() throws IOException, MuleException {
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.start();
        this.deploymentService.start();
    }

    public void assertDeploymentSuccess(String appName) {
        this.assertDeploymentSuccess(this.deploymentListener, appName);
    }

    public void assertDeploymentFailure(String appName) {
        this.assertDeploymentFailure(this.deploymentListener, appName);
    }

    public void assertUndeploymentSuccess(String appName) {
        this.assertUndeploymentSuccess(this.deploymentListener, appName);
    }

    private void assertDeploymentFailure(final DeploymentListener listener, final String appName) {
        PollingProber prober = new PollingProber(20000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onDeploymentFailure((String)Matchers.eq((Object)appName), (Throwable)Matchers.any(Throwable.class));
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "Failed to deploy application: " + appName;
            }
        });
    }

    private void assertDeploymentSuccess(final DeploymentListener listener, final String appName) {
        PollingProber prober = new PollingProber(20000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onDeploymentSuccess(appName);
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "Failed to deploy application: " + appName;
            }
        });
    }

    public void assertUndeploymentSuccess(final DeploymentListener listener, final String appName) {
        PollingProber prober = new PollingProber(20000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onUndeploymentSuccess(appName);
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "Failed to deploy application: " + appName;
            }
        });
    }

    private void setMuleFolders() throws IOException {
        this.appsDir = this.createFolder("apps");
        this.logsDir = this.createFolder("logs");
        this.pluginsDir = this.createFolder("plugins");
        this.domainsDir = this.createFolder("domains");
        File confDir = this.createFolder("conf");
        URL log4jFile = this.getClass().getResource("/log4j2-test.xml");
        FileUtils.copyURLToFile((URL)log4jFile, (File)new File(confDir, "log4j2-test.xml"));
        this.createFolder("lib/shared/default");
    }

    private File createFolder(String folderName) {
        File folder = new File(this.getMuleHome(), folderName);
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IllegalStateException(String.format("Unable to create folder '%s'", folderName));
        }
        return folder;
    }

    public void addAppArchive(URL url) throws IOException {
        this.addAppArchive(url, null);
    }

    public void deploy(String resource) throws IOException {
        int lastSeparator = resource.lastIndexOf(File.separator);
        String appName = StringUtils.removeEndIgnoreCase((String)resource.substring(lastSeparator + 1), (String)".zip");
        this.deploy(resource, appName);
    }

    public void deploy(String resource, String targetAppName) throws IOException {
        URL url = this.getClass().getResource(resource);
        this.addAppArchive(url, targetAppName + ".zip");
        this.assertDeploymentSuccess(targetAppName);
    }

    private void addAppArchive(URL url, String targetFile) throws IOException {
        String tempFileName = new File((targetFile == null ? url.getFile() : targetFile) + ".part").getName();
        File tempFile = new File(this.appsDir, tempFileName);
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        boolean renamed = tempFile.renameTo(new File(StringUtils.removeEnd((String)tempFile.getAbsolutePath(), (String)".part")));
        if (!renamed) {
            throw new IllegalStateException("Unable to add application archive");
        }
    }

    public void addZippedPlugin(String resource) throws IOException, URISyntaxException {
        URL url = this.getClass().getClassLoader().getResource(resource).toURI().toURL();
        String baseName = FilenameUtils.getName((String)url.getPath());
        File tempFile = new File(this.getPluginsDir(), baseName);
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
    }

    public File getMuleHome() {
        return this.muleHome;
    }

    public File getLogsDir() {
        return this.logsDir;
    }

    public File getAppsDir() {
        return this.appsDir;
    }

    private File getDomainsDir() {
        return this.domainsDir;
    }

    public File getPluginsDir() {
        return this.pluginsDir;
    }

    public void resetDeploymentListener() {
        Mockito.reset((Object[])new DeploymentListener[]{this.deploymentListener});
    }

    public void addCoreExtension(MuleCoreExtension coreExtension) {
        this.coreExtensions.add(coreExtension);
    }

    public void addDeploymentListener(DeploymentListener listener) {
        this.deploymentService.addDeploymentListener(listener);
    }

    public void removeDeploymentListener(DeploymentListener listener) {
        this.deploymentService.removeDeploymentListener(listener);
    }

    public Application findApplication(String appName) {
        return this.deploymentService.findApplication(appName);
    }

    public void deployDomainFromClasspathFolder(String domainFolder, String domainName) {
        this.copyExplodedArtifactFromClasspathFolderToDeployFolder(domainFolder, this.getDomainsDir(), domainName);
    }

    public void deployAppFromClasspathFolder(String appFolder, String appName) {
        this.copyExplodedArtifactFromClasspathFolderToDeployFolder(appFolder, this.getAppsDir(), appName);
    }

    private void copyExplodedArtifactFromClasspathFolderToDeployFolder(String artifactFolder, File artifactDirectory, String artifactName) {
        ReentrantLock lock = this.deploymentService.getLock();
        lock.lock();
        try {
            URL resource = this.getClass().getClassLoader().getResource(artifactFolder);
            FileUtils.copyDirectory((File)new File(resource.getFile()), (File)new File(artifactDirectory, artifactName));
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    static {
        if (!Boolean.getBoolean(FAKE_SERVER_DISABLE_LOG_REPOSITORY_SELECTOR)) {
            System.setProperty("mule.simpleLog", "true");
        }
    }
}

