/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.velocity;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.scripting.ScriptingException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.mybatis.scripting.velocity.VelocityLanguageDriverConfig;

public class VelocityFacade {
    private static final RuntimeInstance engine = new RuntimeInstance();
    private static final Map<String, Object> additionalCtxAttributes = new HashMap<String, Object>();

    private VelocityFacade() {
    }

    public static void initialize(VelocityLanguageDriverConfig driverConfig) {
        Properties properties = new Properties();
        driverConfig.getVelocitySettings().forEach(properties::setProperty);
        properties.setProperty("runtime.custom_directives", driverConfig.generateCustomDirectivesString());
        engine.init(properties);
        additionalCtxAttributes.putAll(driverConfig.getAdditionalContextAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> {
            try {
                return Resources.classForName((String)((String)v.getValue())).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ScriptingException("Cannot load additional context attribute class.", (Throwable)e);
            }
        })));
    }

    public static void destroy() {
        engine.reset();
        additionalCtxAttributes.clear();
    }

    public static Object compile(String script, String name) {
        try {
            StringReader reader = new StringReader(script);
            Template template = new Template();
            SimpleNode node = engine.parse((Reader)reader, template);
            template.setRuntimeServices((RuntimeServices)engine);
            template.setData((Object)node);
            template.setName(name);
            template.initDocument();
            return template;
        }
        catch (Exception ex) {
            throw new BuilderException("Error parsing velocity script '" + name + "'", (Throwable)ex);
        }
    }

    public static String apply(Object template, Map<String, Object> context) {
        StringWriter out = new StringWriter();
        context.putAll(additionalCtxAttributes);
        ((Template)template).merge((Context)new VelocityContext(context), (Writer)out);
        return out.toString();
    }
}

