/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver;

import java.util.Arrays;
import org.nd4j.aeron.ipc.NDArrayCallback;
import org.nd4j.aeron.ipc.NDArrayHolder;
import org.nd4j.aeron.ipc.NDArrayMessage;
import org.nd4j.aeron.ndarrayholder.InMemoryNDArrayHolder;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.parameterserver.updater.ParameterServerUpdater;
import org.nd4j.parameterserver.updater.SynchronousParameterUpdater;
import org.nd4j.parameterserver.updater.storage.NoUpdateStorage;

public class ParameterServerListener
implements NDArrayCallback {
    private ParameterServerUpdater updater;
    private boolean master;
    private int[] shape;

    public ParameterServerListener(int[] shape, int updatesPerEpoch) {
        this.updater = new SynchronousParameterUpdater(new NoUpdateStorage(), (NDArrayHolder)new InMemoryNDArrayHolder(shape), updatesPerEpoch);
    }

    public ParameterServerListener(int[] shape) {
        this(shape, Runtime.getRuntime().availableProcessors());
    }

    public ParameterServerListener(int[] shape, ParameterServerUpdater updater) {
        this.updater = updater;
        this.shape = shape;
    }

    public void onNDArrayMessage(NDArrayMessage message) {
        this.updater.update(message);
    }

    public synchronized void onNDArrayPartial(INDArray arr, long idx, int ... dimensions) {
        this.updater.partialUpdate(arr, this.updater.ndArrayHolder().get(), idx, dimensions);
    }

    public synchronized void onNDArray(INDArray arr) {
        if (this.shape == null) {
            this.updater.update(arr.reshape(1, arr.length()), this.updater.ndArrayHolder().get());
        } else {
            this.updater.update(arr, this.updater.ndArrayHolder().get());
        }
    }

    public synchronized void finish() {
        this.updater.ndArrayHolder().get().divi((Number)this.updater.numUpdates());
    }

    public ParameterServerUpdater getUpdater() {
        return this.updater;
    }

    public boolean isMaster() {
        return this.master;
    }

    public int[] getShape() {
        return this.shape;
    }

    public void setUpdater(ParameterServerUpdater updater) {
        this.updater = updater;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public void setShape(int[] shape) {
        this.shape = shape;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterServerListener)) {
            return false;
        }
        ParameterServerListener other = (ParameterServerListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ParameterServerUpdater this$updater = this.getUpdater();
        ParameterServerUpdater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !this$updater.equals(other$updater)) {
            return false;
        }
        if (this.isMaster() != other.isMaster()) {
            return false;
        }
        return Arrays.equals(this.getShape(), other.getShape());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterServerListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterServerUpdater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        result = result * 59 + (this.isMaster() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getShape());
        return result;
    }

    public String toString() {
        return "ParameterServerListener(updater=" + this.getUpdater() + ", master=" + this.isMaster() + ", shape=" + Arrays.toString(this.getShape()) + ")";
    }
}

