/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import io.aeron.Aeron;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.agrona.CloseHelper;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.json.JSONObject;
import org.nd4j.aeron.ipc.AeronNDArraySubscriber;
import org.nd4j.aeron.ipc.AeronUtil;
import org.nd4j.aeron.ipc.NDArrayCallback;
import org.nd4j.aeron.ipc.NDArrayHolder;
import org.nd4j.aeron.ipc.response.AeronNDArrayResponder;
import org.nd4j.aeron.ndarrayholder.InMemoryNDArrayHolder;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.parameterserver.ParameterServerListener;
import org.nd4j.parameterserver.PublishingListener;
import org.nd4j.parameterserver.model.MasterConnectionInfo;
import org.nd4j.parameterserver.model.ServerState;
import org.nd4j.parameterserver.model.SlaveConnectionInfo;
import org.nd4j.parameterserver.model.SubscriberState;
import org.nd4j.parameterserver.updater.ParameterServerUpdater;
import org.nd4j.parameterserver.updater.SoftSyncParameterUpdater;
import org.nd4j.parameterserver.updater.SynchronousParameterUpdater;
import org.nd4j.parameterserver.updater.storage.InMemoryUpdateStorage;
import org.nd4j.parameterserver.util.CheckSocket;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(separators=",")
public class ParameterServerSubscriber
implements AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(ParameterServerSubscriber.class);
    @Parameter(names={"-p", "--port"}, description="The port to listen on for the daemon", arity=1)
    private int port = 40123;
    @Parameter(names={"-id", "--streamId"}, description="The stream id to listen on", arity=1)
    private int streamId = 10;
    @Parameter(names={"-h", "--host"}, description="Host for the server to bind to", arity=1)
    private String host = "localhost";
    @Parameter(names={"-d", "--deleteDirectoryOnStart"}, description="Delete aeron directory on startup.", arity=1)
    private boolean deleteDirectoryOnStart = true;
    @Parameter(names={"-m", "--master"}, description="Whether this subscriber is a master node or not.", arity=1)
    private boolean master = false;
    @Parameter(names={"-pm", "--publishmaster"}, description="Publish master url: host:port - this is for peer nodes needing to publish to another peer.", arity=1)
    private String publishMasterUrl = "localhost:40123";
    @Parameter(names={"-md", "--mediadriverdirectory"}, description="The media driver directory opName. This is for when the media driver is started as a separate process.", arity=1)
    private String mediaDriverDirectoryName;
    @Parameter(names={"-sp", "--statusserverport"}, description="The status server port, defaults to 9000.", arity=1)
    private int statusServerPort = 9000;
    @Parameter(names={"-sh", "--statusserverhost"}, description="The status host, defaults to localhost.", arity=1)
    private String statusServerHost = "localhost";
    @Parameter(names={"-up", "--update"}, description="The update opType for this parameter server. Defaults to sync. You can specify custom and use a jvm argument -Dorg.nd4j.parameterserver.updatetype=your.fully.qualified.class if you want to use a custom class. This must be able to be instantiated from an empty constructor though.", arity=1)
    private String updateTypeString = UpdateType.SYNC.toString().toLowerCase();
    private UpdateType updateType = UpdateType.SYNC;
    @Parameter(names={"-s", "--shape"}, description="The shape of the ndarray", arity=1)
    private List<Integer> shape;
    @Parameter(names={"-hbi", "--heartbeatinterval"}, description="Heartbeat interval in ms", arity=1)
    private int heartbeatMs = 1000;
    private ObjectMapper objectMapper = new ObjectMapper();
    private ScheduledExecutorService scheduledExecutorService;
    @Parameter(names={"-u", "--updatesPerEpoch"}, description="The number of updates per epoch", arity=1, required=true)
    private int updatesPerEpoch;
    public static final String CUSTOM_UPDATE_TYPE = "org.nd4j.parameterserver.updatetype";
    private MediaDriver mediaDriver;
    private AeronNDArrayResponder responder;
    private AeronNDArraySubscriber subscriber;
    private NDArrayCallback callback;
    private ParameterServerListener parameterServerListener;
    private Aeron aeron;
    private ScheduledExecutorService heartbeat;

    public ParameterServerSubscriber(MediaDriver mediaDriver) {
        Preconditions.checkNotNull((Object)mediaDriver);
        this.mediaDriver = mediaDriver;
    }

    public SubscriberState asState() {
        return SubscriberState.builder().parameterUpdaterStatus(this.parameterServerListener == null ? Collections.emptyMap() : this.parameterServerListener.getUpdater().status()).isMaster(this.isMaster()).connectionInfo(this.isMaster() ? this.masterConnectionInfo().toString() : this.slaveConnectionInfo().toString()).isAsync(this.parameterServerListener.getUpdater().isAsync()).isReady(this.parameterServerListener.getUpdater().isReady()).totalUpdates(this.getResponder().getNdArrayHolder().totalUpdates()).streamId(this.streamId).serverState(this.subscriberLaunched() ? ServerState.STARTED.name().toLowerCase() : ServerState.STOPPED.name().toLowerCase()).build();
    }

    public SlaveConnectionInfo slaveConnectionInfo() {
        if (this.isMaster()) {
            throw new IllegalStateException("Unable to determine slave connection info. This is a master node");
        }
        return SlaveConnectionInfo.builder().connectionUrl(this.subscriber.connectionUrl()).masterUrl(this.publishMasterUrl).build();
    }

    public MasterConnectionInfo masterConnectionInfo() {
        if (!this.isMaster()) {
            throw new IllegalStateException("Unable to determine master connection info. This is a slave node");
        }
        return MasterConnectionInfo.builder().connectionUrl(this.subscriber.connectionUrl()).responderUrl(this.responder.connectionUrl()).slaveUrls(new ArrayList()).build();
    }

    public void run(String[] args) {
        JCommander jcmdr = new JCommander((Object)this);
        try {
            jcmdr.parse(args);
        }
        catch (ParameterException e) {
            e.printStackTrace();
            jcmdr.usage();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
        this.updateType = UpdateType.valueOf(this.updateTypeString.toUpperCase());
        if (this.publishMasterUrl == null && !this.master) {
            throw new IllegalStateException("Please specify a master url or set master to true");
        }
        if (this.mediaDriver == null && this.mediaDriverDirectoryName == null) {
            int ipcLength = ArrayUtil.prod((int[])Ints.toArray(this.shape)) * 4;
            ipcLength *= 2;
            System.setProperty("aeron.socket.so_rcvbuf", String.valueOf(ipcLength += 64));
            MediaDriver.Context mediaDriverCtx = new MediaDriver.Context().threadingMode(ThreadingMode.DEDICATED).dirsDeleteOnStart(this.deleteDirectoryOnStart).termBufferSparseFile(Boolean.valueOf(false)).ipcTermBufferLength(ipcLength).publicationTermBufferLength(ipcLength).maxTermBufferLength(ipcLength).conductorIdleStrategy((IdleStrategy)new BusySpinIdleStrategy()).receiverIdleStrategy((IdleStrategy)new BusySpinIdleStrategy()).senderIdleStrategy((IdleStrategy)new BusySpinIdleStrategy());
            this.mediaDriver = MediaDriver.launchEmbedded((MediaDriver.Context)mediaDriverCtx);
            this.mediaDriverDirectoryName = this.mediaDriver.aeronDirectoryName();
            log.info("Using media driver directory " + this.mediaDriver.aeronDirectoryName());
        }
        if (this.aeron == null) {
            this.aeron = Aeron.connect((Aeron.Context)this.getContext());
        }
        if (this.master) {
            if (this.callback == null) {
                ParameterServerUpdater updater = null;
                switch (this.updateType) {
                    case HOGWILD: {
                        break;
                    }
                    case SYNC: {
                        updater = new SynchronousParameterUpdater(new InMemoryUpdateStorage(), (NDArrayHolder)new InMemoryNDArrayHolder(Ints.toArray(this.shape)), this.updatesPerEpoch);
                        break;
                    }
                    case SOFTSYNC: {
                        updater = new SoftSyncParameterUpdater();
                        break;
                    }
                    case TIME_DELAYED: {
                        break;
                    }
                    case CUSTOM: {
                        try {
                            updater = (ParameterServerUpdater)Class.forName(System.getProperty(CUSTOM_UPDATE_TYPE)).newInstance();
                            break;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    default: {
                        throw new IllegalStateException("Illegal opType of updater");
                    }
                }
                this.callback = new ParameterServerListener(Ints.toArray(this.shape), updater);
                this.parameterServerListener = (ParameterServerListener)this.callback;
            }
            ParameterServerListener cast = (ParameterServerListener)this.callback;
            this.responder = AeronNDArrayResponder.startSubscriber((Aeron)this.aeron, (String)this.host, (int)(this.port + 1), (NDArrayHolder)cast.getUpdater().ndArrayHolder(), (int)(this.streamId + 1));
            log.info("Started responder on master node " + this.responder.connectionUrl());
        } else {
            String[] publishMasterUrlArr = this.publishMasterUrl.split(":");
            if (publishMasterUrlArr == null || publishMasterUrlArr.length < 2) {
                throw new IllegalStateException("Please specify publish master url as host:port");
            }
            this.callback = new PublishingListener(String.format("aeron:udp?endpoint=%s:%s", publishMasterUrlArr[0], publishMasterUrlArr[1]), Integer.parseInt(publishMasterUrlArr[2]), this.getContext());
        }
        log.info("Starting subscriber on " + this.host + ":" + this.port + " and stream " + this.streamId);
        AtomicBoolean running = new AtomicBoolean(true);
        this.subscriber = AeronNDArraySubscriber.startSubscriber((Aeron)this.aeron, (String)this.host, (int)this.port, (NDArrayCallback)this.callback, (int)this.streamId, (AtomicBoolean)running);
        while (!this.subscriber.launched()) {
            LockSupport.parkNanos(100000L);
        }
        if (CheckSocket.remotePortTaken(this.statusServerHost, this.statusServerPort, 10000)) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
            AtomicInteger failCount = new AtomicInteger(0);
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                block3: {
                    try {
                        if (failCount.get() >= 3) {
                            return;
                        }
                        SubscriberState subscriberState = this.asState();
                        JSONObject jsonObject = new JSONObject(this.objectMapper.writeValueAsString((Object)subscriberState));
                        String url = String.format("http://%s:%d/updatestatus/%d", this.statusServerHost, this.statusServerPort, this.streamId);
                        HttpResponse httpResponse = Unirest.post((String)url).header("Content-Type", "application/json").body(jsonObject).asString();
                    }
                    catch (Exception e) {
                        failCount.incrementAndGet();
                        if (failCount.get() < 3) break block3;
                        log.warn("Failed to send update, shutting down likely?", (Throwable)e);
                    }
                }
            }, 0L, this.heartbeatMs, TimeUnit.MILLISECONDS);
        } else {
            log.info("No status server found. Will not send heartbeats. Specified host was " + this.statusServerHost + " and port was " + this.statusServerPort);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.close()));
    }

    @Override
    public void close() {
        if (this.subscriber != null) {
            CloseHelper.quietClose((AutoCloseable)this.subscriber);
        }
        if (this.responder != null) {
            CloseHelper.quietClose((AutoCloseable)this.responder);
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    public Aeron.Context getContext() {
        Aeron.Context ctx = new Aeron.Context().publicationConnectionTimeout(-1L).availableImageHandler(AeronUtil::printAvailableImage).unavailableImageHandler(AeronUtil::printUnavailableImage).aeronDirectoryName(this.mediaDriverDirectoryName).keepAliveInterval(100000L).errorHandler(e -> log.error(e.toString(), e));
        return ctx;
    }

    public INDArray getMasterArray() {
        return this.parameterServerListener.getUpdater().ndArrayHolder().get();
    }

    public boolean subscriberLaunched() {
        return this.subscriber.launched();
    }

    public static void main(String[] args) {
        new ParameterServerSubscriber().run(args);
    }

    public ParameterServerSubscriber() {
    }

    public int getPort() {
        return this.port;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isDeleteDirectoryOnStart() {
        return this.deleteDirectoryOnStart;
    }

    public boolean isMaster() {
        return this.master;
    }

    public String getPublishMasterUrl() {
        return this.publishMasterUrl;
    }

    public String getMediaDriverDirectoryName() {
        return this.mediaDriverDirectoryName;
    }

    public int getStatusServerPort() {
        return this.statusServerPort;
    }

    public String getStatusServerHost() {
        return this.statusServerHost;
    }

    public String getUpdateTypeString() {
        return this.updateTypeString;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public List<Integer> getShape() {
        return this.shape;
    }

    public int getHeartbeatMs() {
        return this.heartbeatMs;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public int getUpdatesPerEpoch() {
        return this.updatesPerEpoch;
    }

    public MediaDriver getMediaDriver() {
        return this.mediaDriver;
    }

    public AeronNDArrayResponder getResponder() {
        return this.responder;
    }

    public AeronNDArraySubscriber getSubscriber() {
        return this.subscriber;
    }

    public NDArrayCallback getCallback() {
        return this.callback;
    }

    public ParameterServerListener getParameterServerListener() {
        return this.parameterServerListener;
    }

    public Aeron getAeron() {
        return this.aeron;
    }

    public ScheduledExecutorService getHeartbeat() {
        return this.heartbeat;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setDeleteDirectoryOnStart(boolean deleteDirectoryOnStart) {
        this.deleteDirectoryOnStart = deleteDirectoryOnStart;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public void setPublishMasterUrl(String publishMasterUrl) {
        this.publishMasterUrl = publishMasterUrl;
    }

    public void setMediaDriverDirectoryName(String mediaDriverDirectoryName) {
        this.mediaDriverDirectoryName = mediaDriverDirectoryName;
    }

    public void setStatusServerPort(int statusServerPort) {
        this.statusServerPort = statusServerPort;
    }

    public void setStatusServerHost(String statusServerHost) {
        this.statusServerHost = statusServerHost;
    }

    public void setUpdateTypeString(String updateTypeString) {
        this.updateTypeString = updateTypeString;
    }

    public void setUpdateType(UpdateType updateType) {
        this.updateType = updateType;
    }

    public void setShape(List<Integer> shape) {
        this.shape = shape;
    }

    public void setHeartbeatMs(int heartbeatMs) {
        this.heartbeatMs = heartbeatMs;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void setUpdatesPerEpoch(int updatesPerEpoch) {
        this.updatesPerEpoch = updatesPerEpoch;
    }

    public void setMediaDriver(MediaDriver mediaDriver) {
        this.mediaDriver = mediaDriver;
    }

    public void setResponder(AeronNDArrayResponder responder) {
        this.responder = responder;
    }

    public void setSubscriber(AeronNDArraySubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void setCallback(NDArrayCallback callback) {
        this.callback = callback;
    }

    public void setParameterServerListener(ParameterServerListener parameterServerListener) {
        this.parameterServerListener = parameterServerListener;
    }

    public void setAeron(Aeron aeron) {
        this.aeron = aeron;
    }

    public void setHeartbeat(ScheduledExecutorService heartbeat) {
        this.heartbeat = heartbeat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterServerSubscriber)) {
            return false;
        }
        ParameterServerSubscriber other = (ParameterServerSubscriber)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getStreamId() != other.getStreamId()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.isDeleteDirectoryOnStart() != other.isDeleteDirectoryOnStart()) {
            return false;
        }
        if (this.isMaster() != other.isMaster()) {
            return false;
        }
        String this$publishMasterUrl = this.getPublishMasterUrl();
        String other$publishMasterUrl = other.getPublishMasterUrl();
        if (this$publishMasterUrl == null ? other$publishMasterUrl != null : !this$publishMasterUrl.equals(other$publishMasterUrl)) {
            return false;
        }
        String this$mediaDriverDirectoryName = this.getMediaDriverDirectoryName();
        String other$mediaDriverDirectoryName = other.getMediaDriverDirectoryName();
        if (this$mediaDriverDirectoryName == null ? other$mediaDriverDirectoryName != null : !this$mediaDriverDirectoryName.equals(other$mediaDriverDirectoryName)) {
            return false;
        }
        if (this.getStatusServerPort() != other.getStatusServerPort()) {
            return false;
        }
        String this$statusServerHost = this.getStatusServerHost();
        String other$statusServerHost = other.getStatusServerHost();
        if (this$statusServerHost == null ? other$statusServerHost != null : !this$statusServerHost.equals(other$statusServerHost)) {
            return false;
        }
        String this$updateTypeString = this.getUpdateTypeString();
        String other$updateTypeString = other.getUpdateTypeString();
        if (this$updateTypeString == null ? other$updateTypeString != null : !this$updateTypeString.equals(other$updateTypeString)) {
            return false;
        }
        UpdateType this$updateType = this.getUpdateType();
        UpdateType other$updateType = other.getUpdateType();
        if (this$updateType == null ? other$updateType != null : !((Object)((Object)this$updateType)).equals((Object)other$updateType)) {
            return false;
        }
        List<Integer> this$shape = this.getShape();
        List<Integer> other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !((Object)this$shape).equals(other$shape)) {
            return false;
        }
        if (this.getHeartbeatMs() != other.getHeartbeatMs()) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        ScheduledExecutorService this$scheduledExecutorService = this.getScheduledExecutorService();
        ScheduledExecutorService other$scheduledExecutorService = other.getScheduledExecutorService();
        if (this$scheduledExecutorService == null ? other$scheduledExecutorService != null : !this$scheduledExecutorService.equals(other$scheduledExecutorService)) {
            return false;
        }
        if (this.getUpdatesPerEpoch() != other.getUpdatesPerEpoch()) {
            return false;
        }
        MediaDriver this$mediaDriver = this.getMediaDriver();
        MediaDriver other$mediaDriver = other.getMediaDriver();
        if (this$mediaDriver == null ? other$mediaDriver != null : !this$mediaDriver.equals(other$mediaDriver)) {
            return false;
        }
        AeronNDArrayResponder this$responder = this.getResponder();
        AeronNDArrayResponder other$responder = other.getResponder();
        if (this$responder == null ? other$responder != null : !this$responder.equals(other$responder)) {
            return false;
        }
        AeronNDArraySubscriber this$subscriber = this.getSubscriber();
        AeronNDArraySubscriber other$subscriber = other.getSubscriber();
        if (this$subscriber == null ? other$subscriber != null : !this$subscriber.equals(other$subscriber)) {
            return false;
        }
        NDArrayCallback this$callback = this.getCallback();
        NDArrayCallback other$callback = other.getCallback();
        if (this$callback == null ? other$callback != null : !this$callback.equals(other$callback)) {
            return false;
        }
        ParameterServerListener this$parameterServerListener = this.getParameterServerListener();
        ParameterServerListener other$parameterServerListener = other.getParameterServerListener();
        if (this$parameterServerListener == null ? other$parameterServerListener != null : !((Object)this$parameterServerListener).equals(other$parameterServerListener)) {
            return false;
        }
        Aeron this$aeron = this.getAeron();
        Aeron other$aeron = other.getAeron();
        if (this$aeron == null ? other$aeron != null : !this$aeron.equals(other$aeron)) {
            return false;
        }
        ScheduledExecutorService this$heartbeat = this.getHeartbeat();
        ScheduledExecutorService other$heartbeat = other.getHeartbeat();
        return !(this$heartbeat == null ? other$heartbeat != null : !this$heartbeat.equals(other$heartbeat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterServerSubscriber;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getStreamId();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + (this.isDeleteDirectoryOnStart() ? 79 : 97);
        result = result * 59 + (this.isMaster() ? 79 : 97);
        String $publishMasterUrl = this.getPublishMasterUrl();
        result = result * 59 + ($publishMasterUrl == null ? 43 : $publishMasterUrl.hashCode());
        String $mediaDriverDirectoryName = this.getMediaDriverDirectoryName();
        result = result * 59 + ($mediaDriverDirectoryName == null ? 43 : $mediaDriverDirectoryName.hashCode());
        result = result * 59 + this.getStatusServerPort();
        String $statusServerHost = this.getStatusServerHost();
        result = result * 59 + ($statusServerHost == null ? 43 : $statusServerHost.hashCode());
        String $updateTypeString = this.getUpdateTypeString();
        result = result * 59 + ($updateTypeString == null ? 43 : $updateTypeString.hashCode());
        UpdateType $updateType = this.getUpdateType();
        result = result * 59 + ($updateType == null ? 43 : ((Object)((Object)$updateType)).hashCode());
        List<Integer> $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : ((Object)$shape).hashCode());
        result = result * 59 + this.getHeartbeatMs();
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        ScheduledExecutorService $scheduledExecutorService = this.getScheduledExecutorService();
        result = result * 59 + ($scheduledExecutorService == null ? 43 : $scheduledExecutorService.hashCode());
        result = result * 59 + this.getUpdatesPerEpoch();
        MediaDriver $mediaDriver = this.getMediaDriver();
        result = result * 59 + ($mediaDriver == null ? 43 : $mediaDriver.hashCode());
        AeronNDArrayResponder $responder = this.getResponder();
        result = result * 59 + ($responder == null ? 43 : $responder.hashCode());
        AeronNDArraySubscriber $subscriber = this.getSubscriber();
        result = result * 59 + ($subscriber == null ? 43 : $subscriber.hashCode());
        NDArrayCallback $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
        ParameterServerListener $parameterServerListener = this.getParameterServerListener();
        result = result * 59 + ($parameterServerListener == null ? 43 : ((Object)$parameterServerListener).hashCode());
        Aeron $aeron = this.getAeron();
        result = result * 59 + ($aeron == null ? 43 : $aeron.hashCode());
        ScheduledExecutorService $heartbeat = this.getHeartbeat();
        result = result * 59 + ($heartbeat == null ? 43 : $heartbeat.hashCode());
        return result;
    }

    public String toString() {
        return "ParameterServerSubscriber(port=" + this.getPort() + ", streamId=" + this.getStreamId() + ", host=" + this.getHost() + ", deleteDirectoryOnStart=" + this.isDeleteDirectoryOnStart() + ", master=" + this.isMaster() + ", publishMasterUrl=" + this.getPublishMasterUrl() + ", mediaDriverDirectoryName=" + this.getMediaDriverDirectoryName() + ", statusServerPort=" + this.getStatusServerPort() + ", statusServerHost=" + this.getStatusServerHost() + ", updateTypeString=" + this.getUpdateTypeString() + ", updateType=" + (Object)((Object)this.getUpdateType()) + ", shape=" + this.getShape() + ", heartbeatMs=" + this.getHeartbeatMs() + ", objectMapper=" + this.getObjectMapper() + ", scheduledExecutorService=" + this.getScheduledExecutorService() + ", updatesPerEpoch=" + this.getUpdatesPerEpoch() + ", mediaDriver=" + this.getMediaDriver() + ", responder=" + this.getResponder() + ", subscriber=" + this.getSubscriber() + ", callback=" + this.getCallback() + ", parameterServerListener=" + this.getParameterServerListener() + ", aeron=" + this.getAeron() + ", heartbeat=" + this.getHeartbeat() + ")";
    }

    public static enum UpdateType {
        HOGWILD,
        SYNC,
        TIME_DELAYED,
        SOFTSYNC,
        CUSTOM;

    }
}

