/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver;

import io.aeron.Aeron;
import org.nd4j.aeron.ipc.AeronNDArrayPublisher;
import org.nd4j.aeron.ipc.NDArrayCallback;
import org.nd4j.aeron.ipc.NDArrayMessage;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingListener
implements NDArrayCallback {
    private static final Logger log = LoggerFactory.getLogger(PublishingListener.class);
    private String masterUrl;
    private int streamId;
    private Aeron.Context aeronContext;

    public void onNDArrayMessage(NDArrayMessage message) {
        try (AeronNDArrayPublisher publisher = AeronNDArrayPublisher.builder().streamId(this.streamId).ctx(this.aeronContext).channel(this.masterUrl).build();){
            publisher.publish(message);
            log.debug("NDArray PublishingListener publishing to channel " + this.masterUrl + ":" + this.streamId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onNDArrayPartial(INDArray arr, long idx, int ... dimensions) {
        try (AeronNDArrayPublisher publisher = AeronNDArrayPublisher.builder().streamId(this.streamId).ctx(this.aeronContext).channel(this.masterUrl).build();){
            publisher.publish(NDArrayMessage.builder().arr(arr).dimensions(dimensions).index(idx).build());
            log.debug("NDArray PublishingListener publishing to channel " + this.masterUrl + ":" + this.streamId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onNDArray(INDArray arr) {
        try (AeronNDArrayPublisher publisher = AeronNDArrayPublisher.builder().streamId(this.streamId).ctx(this.aeronContext).channel(this.masterUrl).build();){
            publisher.publish(arr);
            log.debug("NDArray PublishingListener publishing to channel " + this.masterUrl + ":" + this.streamId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public Aeron.Context getAeronContext() {
        return this.aeronContext;
    }

    public void setMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public void setAeronContext(Aeron.Context aeronContext) {
        this.aeronContext = aeronContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublishingListener)) {
            return false;
        }
        PublishingListener other = (PublishingListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$masterUrl = this.getMasterUrl();
        String other$masterUrl = other.getMasterUrl();
        if (this$masterUrl == null ? other$masterUrl != null : !this$masterUrl.equals(other$masterUrl)) {
            return false;
        }
        if (this.getStreamId() != other.getStreamId()) {
            return false;
        }
        Aeron.Context this$aeronContext = this.getAeronContext();
        Aeron.Context other$aeronContext = other.getAeronContext();
        return !(this$aeronContext == null ? other$aeronContext != null : !this$aeronContext.equals(other$aeronContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublishingListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $masterUrl = this.getMasterUrl();
        result = result * 59 + ($masterUrl == null ? 43 : $masterUrl.hashCode());
        result = result * 59 + this.getStreamId();
        Aeron.Context $aeronContext = this.getAeronContext();
        result = result * 59 + ($aeronContext == null ? 43 : $aeronContext.hashCode());
        return result;
    }

    public String toString() {
        return "PublishingListener(masterUrl=" + this.getMasterUrl() + ", streamId=" + this.getStreamId() + ", aeronContext=" + this.getAeronContext() + ")";
    }

    public PublishingListener(String masterUrl, int streamId, Aeron.Context aeronContext) {
        this.masterUrl = masterUrl;
        this.streamId = streamId;
        this.aeronContext = aeronContext;
    }
}

