/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.PropertyLookup;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.util.Providers;

public class PropertyReader
implements PropertyLookup {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;

    public PropertyReader(PropertyStore propertyStore, NodeStore nodeStore) {
        this.propertyStore = propertyStore;
        this.nodeStore = nodeStore;
    }

    public List<PropertyBlock> propertyBlocks(NodeRecord nodeRecord) {
        Collection records = this.propertyStore.getPropertyRecordChain(nodeRecord.getNextProp());
        ArrayList<PropertyBlock> propertyBlocks = new ArrayList<PropertyBlock>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record) {
                propertyBlocks.add(block);
            }
        }
        return propertyBlocks;
    }

    public DefinedProperty propertyValue(PropertyBlock block) {
        return block.getType().readProperty(block.getKeyIndexId(), block, Providers.singletonProvider((Object)this.propertyStore));
    }

    public Property nodeProperty(long nodeId, int propertyKeyId) {
        try {
            NodeRecord nodeRecord = this.nodeStore.getRecord(nodeId);
            for (PropertyBlock block : this.propertyBlocks(nodeRecord)) {
                if (block.getKeyIndexId() != propertyKeyId) continue;
                return this.propertyValue(block);
            }
        }
        catch (InvalidRecordException e) {
            // empty catch block
        }
        return Property.noNodeProperty((long)nodeId, (int)propertyKeyId);
    }
}

