/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class PropertyReader
implements PropertyAccessor {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;

    PropertyReader(StoreAccess storeAccess) {
        this.propertyStore = storeAccess.getRawNeoStores().getPropertyStore();
        this.nodeStore = storeAccess.getRawNeoStores().getNodeStore();
    }

    Collection<PropertyRecord> getPropertyRecordChain(long firstPropertyRecordId) throws CircularPropertyRecordChainException {
        ArrayList<PropertyRecord> records = new ArrayList<PropertyRecord>();
        this.visitPropertyRecordChain(firstPropertyRecordId, (Visitor<PropertyRecord, RuntimeException>)((Visitor)record -> {
            records.add((PropertyRecord)record);
            return false;
        }));
        return records;
    }

    List<PropertyBlock> propertyBlocks(Collection<PropertyRecord> records) {
        ArrayList<PropertyBlock> propertyBlocks = new ArrayList<PropertyBlock>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record) {
                propertyBlocks.add(block);
            }
        }
        return propertyBlocks;
    }

    private boolean visitPropertyRecordChain(long firstPropertyRecordId, Visitor<PropertyRecord, RuntimeException> visitor) throws CircularPropertyRecordChainException {
        if (Record.NO_NEXT_PROPERTY.is(firstPropertyRecordId)) {
            return false;
        }
        PrimitiveLongSet visitedPropertyRecordIds = Primitive.longSet((int)8);
        visitedPropertyRecordIds.add(firstPropertyRecordId);
        long nextProp = firstPropertyRecordId;
        while (!Record.NO_NEXT_PROPERTY.is(nextProp)) {
            PropertyRecord propRecord = (PropertyRecord)this.propertyStore.getRecord(nextProp, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.FORCE);
            if (!Record.NO_NEXT_PROPERTY.is(nextProp = propRecord.getNextProp()) && !visitedPropertyRecordIds.add(nextProp)) {
                throw new CircularPropertyRecordChainException(propRecord);
            }
            if (!visitor.visit((Object)propRecord)) continue;
            return true;
        }
        return false;
    }

    public Value propertyValue(PropertyBlock block) {
        return block.getType().value(block, this.propertyStore);
    }

    public Value getPropertyValue(long nodeId, int propertyKeyId) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        if (((NodeRecord)this.nodeStore.getRecord(nodeId, (AbstractBaseRecord)nodeRecord, RecordLoad.FORCE)).inUse()) {
            SpecificValueVisitor visitor = new SpecificValueVisitor(propertyKeyId);
            try {
                if (this.visitPropertyRecordChain(nodeRecord.getNextProp(), visitor)) {
                    return visitor.foundPropertyValue;
                }
            }
            catch (CircularPropertyRecordChainException circularPropertyRecordChainException) {
                // empty catch block
            }
        }
        return Values.NO_VALUE;
    }

    static class CircularPropertyRecordChainException
    extends Exception {
        private final PropertyRecord propertyRecord;

        CircularPropertyRecordChainException(PropertyRecord propertyRecord) {
            this.propertyRecord = propertyRecord;
        }

        PropertyRecord propertyRecordClosingTheCircle() {
            return this.propertyRecord;
        }
    }

    private class SpecificValueVisitor
    implements Visitor<PropertyRecord, RuntimeException> {
        private final int propertyKeyId;
        private Value foundPropertyValue;

        SpecificValueVisitor(int propertyKeyId) {
            this.propertyKeyId = propertyKeyId;
        }

        public boolean visit(PropertyRecord element) throws RuntimeException {
            for (PropertyBlock block : element) {
                if (block.getKeyIndexId() != this.propertyKeyId) continue;
                this.foundPropertyValue = PropertyReader.this.propertyValue(block);
                return true;
            }
            return false;
        }
    }
}

