/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.IndexDefinition;

public class CypherResultSubGraph
implements SubGraph {
    private static final long REF_NODE_ID = 0L;
    private final SortedMap<Long, Node> nodes = new TreeMap<Long, Node>();
    private final SortedMap<Long, Relationship> relationships = new TreeMap<Long, Relationship>();

    public void add(Node node) {
        long id = node.getId();
        if (!this.nodes.containsKey(id)) {
            this.addNode(id, node);
        }
    }

    void addNode(long id, Node data) {
        this.nodes.put(id, data);
    }

    public void add(Relationship rel) {
        long id = rel.getId();
        if (!this.relationships.containsKey(id)) {
            this.addRel(id, rel);
            this.add(rel.getStartNode());
            this.add(rel.getEndNode());
        }
    }

    public static SubGraph from(ExecutionResult result, boolean addBetween) {
        CypherResultSubGraph graph = new CypherResultSubGraph();
        List<String> columns = result.columns();
        Iterator i$ = result.iterator();
        while (i$.hasNext()) {
            Map row = (Map)i$.next();
            for (String column : columns) {
                Object value = row.get(column);
                graph.addToGraph(value);
            }
        }
        if (addBetween) {
            graph.addRelationshipsBetweenNodes();
        }
        return graph;
    }

    private void addRelationshipsBetweenNodes() {
        HashSet<Node> newNodes = new HashSet<Node>();
        for (Node node : this.nodes.values()) {
            for (Relationship relationship : node.getRelationships()) {
                Node other;
                if (!this.relationships.containsKey(relationship.getId()) || this.nodes.containsKey((other = relationship.getOtherNode(node)).getId()) || newNodes.contains(other)) continue;
                newNodes.add(other);
            }
        }
        for (Node node : newNodes) {
            this.add(node);
        }
    }

    private void addToGraph(Object value) {
        if (value instanceof Node) {
            this.add((Node)value);
        }
        if (value instanceof Relationship) {
            this.add((Relationship)value);
        }
        if (value instanceof Iterable) {
            for (Object inner : (Iterable)value) {
                this.addToGraph(inner);
            }
        }
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.nodes.values();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.relationships.values();
    }

    void addRel(Long id, Relationship rel) {
        this.relationships.put(id, rel);
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.relationships.containsKey(relationship.getId());
    }

    @Override
    public Iterable<IndexDefinition> indexes() {
        return Collections.emptyList();
    }
}

