/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.cypher.javacompat.ExtendedExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IteratorUtil;

public class CypherResultSubGraph
implements SubGraph {
    private final SortedMap<Long, Node> nodes = new TreeMap<Long, Node>();
    private final SortedMap<Long, Relationship> relationships = new TreeMap<Long, Relationship>();
    private final Collection<Label> labels = new HashSet<Label>();
    private final Collection<IndexDefinition> indexes = new HashSet<IndexDefinition>();
    private final Collection<ConstraintDefinition> constraints = new HashSet<ConstraintDefinition>();

    public void add(Node node) {
        long id = node.getId();
        if (!this.nodes.containsKey(id)) {
            this.addNode(id, node);
        }
    }

    void addNode(long id, Node data) {
        this.nodes.put(id, data);
        this.labels.addAll(IteratorUtil.asCollection((Iterable)data.getLabels()));
    }

    public void add(Relationship rel) {
        long id = rel.getId();
        if (!this.relationships.containsKey(id)) {
            this.addRel(id, rel);
            this.add(rel.getStartNode());
            this.add(rel.getEndNode());
        }
    }

    public static SubGraph from(ExtendedExecutionResult result, GraphDatabaseService gds, boolean addBetween) {
        CypherResultSubGraph graph = new CypherResultSubGraph();
        List<String> columns2 = result.columns();
        Iterator i$ = result.iterator();
        while (i$.hasNext()) {
            Map row = (Map)i$.next();
            for (String column : columns2) {
                Object value = row.get(column);
                graph.addToGraph(value);
            }
        }
        for (IndexDefinition def : gds.schema().getIndexes()) {
            if (!graph.getLabels().contains(def.getLabel())) continue;
            graph.addIndex(def);
        }
        for (IndexDefinition def : gds.schema().getConstraints()) {
            if (!graph.getLabels().contains(def.getLabel())) continue;
            graph.addConstraint((ConstraintDefinition)def);
        }
        if (addBetween) {
            graph.addRelationshipsBetweenNodes();
        }
        return graph;
    }

    private void addIndex(IndexDefinition def) {
        this.indexes.add(def);
    }

    private void addConstraint(ConstraintDefinition def) {
        this.constraints.add(def);
    }

    private void addRelationshipsBetweenNodes() {
        HashSet<Node> newNodes = new HashSet<Node>();
        for (Node node : this.nodes.values()) {
            for (Relationship relationship : node.getRelationships()) {
                Node other;
                if (!this.relationships.containsKey(relationship.getId()) || this.nodes.containsKey((other = relationship.getOtherNode(node)).getId()) || newNodes.contains(other)) continue;
                newNodes.add(other);
            }
        }
        for (Node node : newNodes) {
            this.add(node);
        }
    }

    private void addToGraph(Object value) {
        if (value instanceof Node) {
            this.add((Node)value);
        }
        if (value instanceof Relationship) {
            this.add((Relationship)value);
        }
        if (value instanceof Iterable) {
            for (Object inner : (Iterable)value) {
                this.addToGraph(inner);
            }
        }
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.nodes.values();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.relationships.values();
    }

    public Collection<Label> getLabels() {
        return this.labels;
    }

    void addRel(Long id, Relationship rel) {
        this.relationships.put(id, rel);
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.relationships.containsKey(relationship.getId());
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        return this.indexes;
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        return this.constraints;
    }
}

