/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.neo4j.cypher.internal.codegen.CompiledEquivalenceUtils;
import org.neo4j.cypher.internal.codegen.NodeIdWrapperImpl;
import org.neo4j.cypher.internal.codegen.PrimitiveEntityStream;
import org.neo4j.cypher.internal.codegen.PrimitiveNodeStream;
import org.neo4j.cypher.internal.codegen.PrimitiveRelationshipStream;
import org.neo4j.cypher.internal.codegen.RelationshipIdWrapperImpl;
import org.neo4j.cypher.internal.compiler.v3_2.spi.NodeIdWrapper;
import org.neo4j.cypher.internal.compiler.v3_2.spi.RelationshipIdWrapper;
import org.neo4j.cypher.internal.frontend.v3_2.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v3_2.IncomparableValuesException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.NodeManager;

public abstract class CompiledConversionUtils {
    public static boolean coerceToPredicate(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        throw new CypherTypeException("Don't know how to treat that as a predicate: " + value.toString(), null);
    }

    public static Collection<?> toCollection(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        throw new CypherTypeException("Don't know how to create an iterable out of " + value.getClass().getSimpleName(), null);
    }

    public static CompositeKey compositeKey(long ... keys) {
        return new CompositeKey(keys);
    }

    public static Boolean equals(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (lhs instanceof NodeIdWrapper && !(rhs instanceof NodeIdWrapper) || rhs instanceof NodeIdWrapper && !(lhs instanceof NodeIdWrapper) || lhs instanceof RelationshipIdWrapper && !(rhs instanceof RelationshipIdWrapper) || rhs instanceof RelationshipIdWrapper && !(lhs instanceof RelationshipIdWrapper)) {
            throw new IncomparableValuesException(lhs.getClass().getSimpleName(), rhs.getClass().getSimpleName());
        }
        return CompiledEquivalenceUtils.equals(lhs, rhs);
    }

    public static Boolean or(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return null;
        }
        if (lhs == null && rhs instanceof Boolean) {
            return (Boolean)rhs != false ? Boolean.valueOf(true) : null;
        }
        if (rhs == null && lhs instanceof Boolean) {
            return (Boolean)lhs != false ? Boolean.valueOf(true) : null;
        }
        if (lhs instanceof Boolean && rhs instanceof Boolean) {
            return (Boolean)lhs != false || (Boolean)rhs != false;
        }
        throw new CypherTypeException("Don't know how to do or on: " + (lhs != null ? lhs.toString() : null) + " and " + (rhs != null ? rhs.toString() : null), null);
    }

    public static Boolean not(Object predicate) {
        if (predicate == null) {
            return null;
        }
        if (predicate instanceof Boolean) {
            return (Boolean)predicate == false;
        }
        throw new CypherTypeException("Don't know how to treat that as a boolean: " + predicate.toString(), null);
    }

    public static Object loadParameter(Object value) {
        if (value instanceof Node) {
            return new NodeIdWrapperImpl(((Node)value).getId());
        }
        if (value instanceof Relationship) {
            return new RelationshipIdWrapperImpl(((Relationship)value).getId());
        }
        return value;
    }

    public static final Object materializeAnyResult(NodeManager nodeManager, Object anyValue) {
        if (anyValue instanceof NodeIdWrapper) {
            return nodeManager.newNodeProxyById(((NodeIdWrapper)anyValue).id());
        }
        if (anyValue instanceof RelationshipIdWrapper) {
            return nodeManager.newRelationshipProxyById(((RelationshipIdWrapper)anyValue).id());
        }
        if (anyValue instanceof List) {
            return ((List)anyValue).stream().map(v -> CompiledConversionUtils.materializeAnyResult(nodeManager, v)).collect(Collectors.toList());
        }
        if (anyValue instanceof Map) {
            ((Map)anyValue).replaceAll((k, v) -> CompiledConversionUtils.materializeAnyResult(nodeManager, v));
            return anyValue;
        }
        if (anyValue instanceof PrimitiveNodeStream) {
            return ((PrimitiveNodeStream)anyValue).longStream().mapToObj(arg_0 -> ((NodeManager)nodeManager).newNodeProxyById(arg_0)).collect(Collectors.toList());
        }
        if (anyValue instanceof PrimitiveRelationshipStream) {
            return ((PrimitiveRelationshipStream)anyValue).longStream().mapToObj(arg_0 -> ((NodeManager)nodeManager).newRelationshipProxyById(arg_0)).collect(Collectors.toList());
        }
        if (anyValue instanceof LongStream) {
            return ((LongStream)anyValue).boxed().collect(Collectors.toList());
        }
        if (anyValue instanceof DoubleStream) {
            return ((DoubleStream)anyValue).boxed().collect(Collectors.toList());
        }
        if (anyValue instanceof IntStream) {
            return ((IntStream)anyValue).mapToObj(i -> i != 0).collect(Collectors.toList());
        }
        return anyValue;
    }

    public static final Iterator iteratorFrom(Object iterable) {
        if (iterable instanceof Iterable) {
            return ((Iterable)iterable).iterator();
        }
        if (iterable instanceof PrimitiveEntityStream) {
            return ((PrimitiveEntityStream)iterable).iterator();
        }
        if (iterable instanceof LongStream) {
            return ((LongStream)iterable).iterator();
        }
        if (iterable instanceof DoubleStream) {
            return ((DoubleStream)iterable).iterator();
        }
        if (iterable instanceof IntStream) {
            return ((IntStream)iterable).iterator();
        }
        if (iterable == null) {
            return Collections.emptyIterator();
        }
        throw new CypherTypeException("Don't know how to create an iterator out of " + iterable.getClass().getSimpleName(), null);
    }

    public static LongStream toLongStream(Object list) {
        if (list == null) {
            return LongStream.empty();
        }
        if (list instanceof List) {
            return ((List)list).stream().mapToLong(n -> ((Number)n).longValue());
        }
        if (Object[].class.isAssignableFrom(list.getClass())) {
            return Arrays.stream((Object[])list).mapToLong(n -> ((Number)n).longValue());
        }
        if (list instanceof byte[]) {
            byte[] array = (byte[])list;
            return IntStream.range(0, array.length).mapToLong(i -> array[i]);
        }
        if (list instanceof short[]) {
            short[] array = (short[])list;
            return IntStream.range(0, array.length).mapToLong(i -> array[i]);
        }
        if (list instanceof int[]) {
            return IntStream.of((int[])list).mapToLong(i -> i);
        }
        if (list instanceof long[]) {
            return LongStream.of((long[])list);
        }
        throw new IllegalArgumentException(String.format("Can not be converted to stream: %s", list.getClass().getName()));
    }

    public static DoubleStream toDoubleStream(Object list) {
        if (list == null) {
            return DoubleStream.empty();
        }
        if (list instanceof List) {
            return ((List)list).stream().mapToDouble(n -> ((Number)n).doubleValue());
        }
        if (Object[].class.isAssignableFrom(list.getClass())) {
            return Arrays.stream((Object[])list).mapToDouble(n -> ((Number)n).doubleValue());
        }
        if (list instanceof float[]) {
            float[] array = (float[])list;
            return IntStream.range(0, array.length).mapToDouble(i -> array[i]);
        }
        if (list instanceof double[]) {
            return DoubleStream.of((double[])list);
        }
        throw new IllegalArgumentException(String.format("Can not be converted to stream: %s", list.getClass().getName()));
    }

    public static IntStream toBooleanStream(Object list) {
        if (list == null) {
            return IntStream.empty();
        }
        if (list instanceof List) {
            return ((List)list).stream().mapToInt(n -> ((Number)n).intValue());
        }
        if (Object[].class.isAssignableFrom(list.getClass())) {
            return Arrays.stream((Object[])list).mapToInt(n -> ((Number)n).intValue());
        }
        if (list instanceof boolean[]) {
            boolean[] array = (boolean[])list;
            return IntStream.range(0, array.length).map(i -> array[i] ? 1 : 0);
        }
        throw new IllegalArgumentException(String.format("Can not be converted to stream: %s", list.getClass().getName()));
    }

    public static long unboxNodeOrNull(NodeIdWrapper value) {
        if (value == null) {
            return -1L;
        }
        return value.id();
    }

    public static long unboxRelationshipOrNull(RelationshipIdWrapper value) {
        if (value == null) {
            return -1L;
        }
        return value.id();
    }

    public static class CompositeKey {
        private final long[] key;

        private CompositeKey(long[] key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            return Arrays.equals(this.key, that.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }
    }
}

