/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.MathUtil;

public final class CompiledEquivalenceUtils {
    private CompiledEquivalenceUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean equals(Object lhs, Object rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            long right;
            if (lhs instanceof Double && rhs instanceof Float) {
                return CompiledEquivalenceUtils.mixedFloatEquality((Float)rhs, (Double)lhs);
            }
            if (lhs instanceof Float && rhs instanceof Double) {
                return CompiledEquivalenceUtils.mixedFloatEquality((Float)lhs, (Double)rhs);
            }
            if ((lhs instanceof Double || lhs instanceof Float) && (rhs instanceof Double || rhs instanceof Float)) {
                double right2;
                double left = ((Number)lhs).doubleValue();
                return left == (right2 = ((Number)rhs).doubleValue());
            }
            if (lhs instanceof Double || lhs instanceof Float) {
                double left = ((Number)lhs).doubleValue();
                long right3 = ((Number)rhs).longValue();
                return MathUtil.numbersEqual((double)left, (long)right3);
            }
            if (rhs instanceof Double || rhs instanceof Float) {
                long left = ((Number)lhs).longValue();
                double right4 = ((Number)rhs).doubleValue();
                return MathUtil.numbersEqual((double)right4, (long)left);
            }
            long left = ((Number)lhs).longValue();
            return left == (right = ((Number)rhs).longValue());
        }
        if (lhs instanceof Character && rhs instanceof String) {
            return lhs.toString().equals(rhs);
        }
        if (lhs instanceof String && rhs instanceof Character) {
            return lhs.equals(rhs.toString());
        }
        if (lhs.getClass().isArray() && rhs.getClass().isArray()) {
            int length = Array.getLength(lhs);
            if (length != Array.getLength(rhs)) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (CompiledEquivalenceUtils.equals(Array.get(lhs, i), Array.get(rhs, i))) continue;
                return false;
            }
            return true;
        }
        if (lhs.getClass().isArray() && rhs instanceof List) {
            return CompiledEquivalenceUtils.compareArrayAndList(lhs, (List)rhs);
        }
        if (lhs instanceof List && rhs.getClass().isArray()) {
            return CompiledEquivalenceUtils.compareArrayAndList(rhs, (List)lhs);
        }
        if (lhs instanceof List && rhs instanceof List) {
            List lhsList = (List)lhs;
            List rhsList = (List)rhs;
            if (lhsList.size() != rhsList.size()) {
                return false;
            }
            Iterator lhsIterator = lhsList.iterator();
            Iterator rhsIterator = rhsList.iterator();
            while (lhsIterator.hasNext()) {
                if (CompiledEquivalenceUtils.equals(lhsIterator.next(), rhsIterator.next())) continue;
                return false;
            }
            return true;
        }
        if (lhs instanceof Map && rhs instanceof Map) {
            Map rMap = (Map)rhs;
            Map lMap = (Map)lhs;
            if (rMap.size() != lMap.size()) {
                return false;
            }
            for (Map.Entry e : rMap.entrySet()) {
                String key = (String)e.getKey();
                Object value = e.getValue();
                if (!(value == null ? lMap.get(key) != null || !lMap.containsKey(key) : !CompiledEquivalenceUtils.equals(value, lMap.get(key)))) continue;
                return false;
            }
            return true;
        }
        return lhs.equals(rhs);
    }

    public static int hashCode(Object element) {
        if (element == null) {
            return 0;
        }
        if (element instanceof Number) {
            return CompiledEquivalenceUtils.hashCode(((Number)element).longValue());
        }
        if (element instanceof Character) {
            return CompiledEquivalenceUtils.hashCode(((Character)element).charValue());
        }
        if (element instanceof Boolean) {
            return CompiledEquivalenceUtils.hashCode((Boolean)element);
        }
        if (element instanceof List) {
            return CompiledEquivalenceUtils.hashCode((List)element);
        }
        if (element instanceof Map) {
            return CompiledEquivalenceUtils.hashCode((Map)element);
        }
        if (element instanceof Object[]) {
            return CompiledEquivalenceUtils.hashCode((Object[])element);
        }
        if (element instanceof byte[]) {
            return CompiledEquivalenceUtils.hashCode((byte[])element);
        }
        if (element instanceof short[]) {
            return CompiledEquivalenceUtils.hashCode((short[])element);
        }
        if (element instanceof int[]) {
            return CompiledEquivalenceUtils.hashCode((int[])element);
        }
        if (element instanceof long[]) {
            return CompiledEquivalenceUtils.hashCode((long[])element);
        }
        if (element instanceof char[]) {
            return CompiledEquivalenceUtils.hashCode((char[])element);
        }
        if (element instanceof float[]) {
            return CompiledEquivalenceUtils.hashCode((float[])element);
        }
        if (element instanceof double[]) {
            return CompiledEquivalenceUtils.hashCode((double[])element);
        }
        if (element instanceof boolean[]) {
            return CompiledEquivalenceUtils.hashCode((boolean[])element);
        }
        return element.hashCode();
    }

    public static int hashCode(Map<String, Object> map) {
        int h = 0;
        for (Map.Entry<String, Object> next2 : map.entrySet()) {
            String k = next2.getKey();
            Object v = next2.getValue();
            h += (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : CompiledEquivalenceUtils.hashCode(v));
        }
        return h;
    }

    public static int hashCode(long value) {
        return Long.hashCode(value);
    }

    public static int hashCode(boolean value) {
        return Boolean.hashCode(value);
    }

    public static int hashCode(char value) {
        return Character.hashCode(value);
    }

    public static int hashCode(char[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(List<?> list) {
        int len = list.size();
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(list.get(0));
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(list.get(0)) + CompiledEquivalenceUtils.hashCode(list.get(1));
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(list.get(0)) + CompiledEquivalenceUtils.hashCode(list.get(1))) * 31 + CompiledEquivalenceUtils.hashCode(list.get(2));
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(list.get(0)) + CompiledEquivalenceUtils.hashCode(list.get(len / 2)) * 31 + CompiledEquivalenceUtils.hashCode(list.get(len - 1)));
    }

    public static int hashCode(Object[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(byte[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(short[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(int[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(long[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(float[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode((long)array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[1])) * 31 + CompiledEquivalenceUtils.hashCode((long)array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode((long)array[len - 1]));
    }

    public static int hashCode(double[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode((long)array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[1])) * 31 + CompiledEquivalenceUtils.hashCode((long)array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode((long)array[len - 1]));
    }

    public static int hashCode(boolean[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    private static Boolean compareArrayAndList(Object array, List<?> list) {
        int length = Array.getLength(array);
        if (length != list.size()) {
            return false;
        }
        int i = 0;
        for (Object o : list) {
            if (CompiledEquivalenceUtils.equals(o, Array.get(array, i++))) continue;
            return false;
        }
        return true;
    }

    private static boolean mixedFloatEquality(Float a, Double b) {
        return a.floatValue() == b.floatValue();
    }
}

