/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.Exceptions;

public class MapRow
implements Result.ResultRow {
    private final Map<String, Object> map;

    public MapRow(Map<String, Object> map) {
        this.map = map;
    }

    private <T> T get(String key, Class<T> type) {
        Object value = this.map.get(key);
        if (value == null && !this.map.containsKey(key)) {
            throw new NoSuchElementException("No such entry: " + key);
        }
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw (NoSuchElementException)Exceptions.withCause((Throwable)new NoSuchElementException("Element '" + key + "' is not a " + type.getSimpleName()), (Throwable)e);
        }
    }

    public Node getNode(String key) {
        return this.get(key, Node.class);
    }

    public Relationship getRelationship(String key) {
        return this.get(key, Relationship.class);
    }

    public Object get(String key) {
        return this.get(key, Object.class);
    }

    public String getString(String key) {
        return this.get(key, String.class);
    }

    public Number getNumber(String key) {
        return this.get(key, Number.class);
    }

    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    public Path getPath(String key) {
        return this.get(key, Path.class);
    }
}

