/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.v3_1;

import org.neo4j.cypher.internal.compiler.v3_1.spi.SchemaTypes;
import org.neo4j.cypher.internal.spi.v3_1.SchemaDescriptorTranslation;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;

public abstract class SchemaDescriptorTranslation$class {
    public static SchemaIndexDescriptor toKernel(SchemaDescriptorTranslation $this, SchemaTypes.IndexDescriptor index) {
        return SchemaIndexDescriptorFactory.forLabel((int)index.labelId(), (int[])new int[]{index.propertyId()});
    }

    public static SchemaTypes.IndexDescriptor toCypher(SchemaDescriptorTranslation $this, SchemaIndexDescriptor index) {
        $this.assertSingleProperty((SchemaDescriptor)index.schema());
        return new SchemaTypes.IndexDescriptor(index.schema().getLabelId(), index.schema().getPropertyId());
    }

    public static UniquenessConstraintDescriptor toKernel(SchemaDescriptorTranslation $this, SchemaTypes.UniquenessConstraint constraint) {
        return ConstraintDescriptorFactory.uniqueForLabel((int)constraint.labelId(), (int[])new int[]{constraint.propertyId()});
    }

    public static SchemaTypes.UniquenessConstraint toCypher(SchemaDescriptorTranslation $this, UniquenessConstraintDescriptor constraint) {
        $this.assertSingleProperty((SchemaDescriptor)constraint.schema());
        return new SchemaTypes.UniquenessConstraint(constraint.schema().getLabelId(), constraint.schema().getPropertyId());
    }

    public static SchemaTypes.NodePropertyExistenceConstraint toCypher(SchemaDescriptorTranslation $this, NodeExistenceConstraintDescriptor constraint) {
        $this.assertSingleProperty((SchemaDescriptor)constraint.schema());
        return new SchemaTypes.NodePropertyExistenceConstraint(constraint.schema().getLabelId(), constraint.schema().getPropertyId());
    }

    public static SchemaTypes.RelationshipPropertyExistenceConstraint toCypher(SchemaDescriptorTranslation $this, RelExistenceConstraintDescriptor constraint) {
        $this.assertSingleProperty((SchemaDescriptor)constraint.schema());
        return new SchemaTypes.RelationshipPropertyExistenceConstraint(constraint.schema().getRelTypeId(), constraint.schema().getPropertyId());
    }

    public static void assertSingleProperty(SchemaDescriptorTranslation $this, SchemaDescriptor schema) {
        if (schema.getPropertyIds().length != 1) {
            throw new UnsupportedOperationException("Cypher 3.1 does not support composite indexes or constraints");
        }
    }

    public static void $init$(SchemaDescriptorTranslation $this) {
    }
}

