/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.time.Clock;
import org.neo4j.cypher.ParameterNotFoundException;
import org.neo4j.cypher.exceptionHandler;
import org.neo4j.cypher.internal.CacheDisabled;
import org.neo4j.cypher.internal.CacheHit;
import org.neo4j.cypher.internal.CacheLookup;
import org.neo4j.cypher.internal.CacheMiss;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CacheableExecutableQuery;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.compatibility.CypherCacheFlushingMonitor$class;
import org.neo4j.cypher.internal.compatibility.CypherCacheHitMonitor$class;
import org.neo4j.cypher.internal.runtime.interpreted.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.ResultBuffer;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#\u0001\u0007rk\u0016\u0014\u0018pU3sm&\u001cW-F\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004lKJtW\r\\\u0005\u00035]\u0011\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r:\u0012AC7p]&$xN]5oO&\u0011QE\t\u0002\t\u001b>t\u0017\u000e^8sg\"Aq\u0005\u0001B\u0001B\u0003%\u0001%A\blKJtW\r\\'p]&$xN]:!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013A\u0002;sC\u000e,'/F\u0001,!\tas&D\u0001.\u0015\tq#!A\u0004ue\u0006\u001c\u0017N\\4\n\u0005Aj#!E\"p[BLG.\u0019;j_:$&/Y2fe\"A!\u0007\u0001B\u0001B\u0003%1&A\u0004ue\u0006\u001cWM\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n1bY1dQ\u0016$&/Y2feV\ta\u0007E\u00028qij\u0011AA\u0005\u0003s\t\u00111bQ1dQ\u0016$&/Y2feB\u00111H\u0010\b\u0003\u001bqJ!!\u0010\b\u0002\rA\u0013X\rZ3g\u0013\ty\u0004I\u0001\u0004TiJLgn\u001a\u0006\u0003{9A\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAN\u0001\rG\u0006\u001c\u0007.\u001a+sC\u000e,'\u000f\t\u0005\t\t\u0002\u0011)\u0019!C\u0001\u000b\u000611m\u001c8gS\u001e,\u0012A\u0012\t\u0003o\u001dK!\u0001\u0013\u0002\u0003'\rK\b\u000f[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011)\u0003!\u0011!Q\u0001\n\u0019\u000bqaY8oM&<\u0007\u0005\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0001N\u0003Q\u0019w.\u001c9bi&\u0014\u0017\u000e\\5us\u001a\u000b7\r^8ssV\ta\n\u0005\u00028\u001f&\u0011\u0001K\u0001\u0002\u0010\u0007>l\u0007/\u001b7fe\u001a\u000b7\r^8ss\"A!\u000b\u0001B\u0001B\u0003%a*A\u000bd_6\u0004\u0018\r^5cS2LG/\u001f$bGR|'/\u001f\u0011\t\u0011Q\u0003!Q1A\u0005\u0002U\u000b1\u0002\\8h!J|g/\u001b3feV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z\r\u00059An\\4hS:<\u0017BA.Y\u0005-aun\u001a)s_ZLG-\u001a:\t\u0011u\u0003!\u0011!Q\u0001\nY\u000bA\u0002\\8h!J|g/\u001b3fe\u0002B\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0001Y\u0001\u0006G2|7m[\u000b\u0002CB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0005i&lWMC\u0001g\u0003\u0011Q\u0017M^1\n\u0005!\u001c'!B\"m_\u000e\\\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B1\u0002\r\rdwnY6!\u0011\u0015a\u0007\u0001\"\u0001n\u0003\u0019a\u0014N\\5u}QIan\u001c9reN$XO\u001e\t\u0003o\u0001AQaE6A\u0002UAQAH6A\u0002\u0001BQ!K6A\u0002-BQ\u0001N6A\u0002YBQ\u0001R6A\u0002\u0019CQ\u0001T6A\u00029CQ\u0001V6A\u0002YCqaX6\u0011\u0002\u0003\u0007\u0011\rC\u0004y\u0001\t\u0007I\u0011B=\u0002\u0013A\u0014X\rU1sg\u0016\u0014X#\u0001>\u0011\u0005]Z\u0018B\u0001?\u0003\u0005%\u0001&/\u001a)beN,'\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA_\u0001\u000baJ,\u0007+\u0019:tKJ\u0004\u0003\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0003ea\u0017m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\fS:$XM\u001d9sKR,GMC\u0002\u0002\u0010\t\tqA];oi&lW-\u0003\u0003\u0002\u0014\u0005%!!\u0007'bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJD\u0001\"a\u0006\u0001A\u0003%\u0011QA\u0001\u001bY\u0006\u001cHoQ8n[&$H/\u001a3Uq&#\u0007K]8wS\u0012,'\u000f\t\u0005\b\u00037\u0001A\u0011BA\u000f\u0003A\u0001H.\u00198SKV\u001c\u0018MY5mSRL\u0017\u0010\u0006\u0004\u0002 \u0005\u0015\u0012q\u0006\t\u0004o\u0005\u0005\u0012bAA\u0012\u0005\t\u0001\"+Z;tC\nLG.\u001b;z'R\fG/\u001a\u0005\t\u0003O\tI\u00021\u0001\u0002*\u0005)2-Y2iK\u0012,\u00050Z2vi\u0006\u0014G.Z)vKJL\bcA\u001c\u0002,%\u0019\u0011Q\u0006\u0002\u00031\r\u000b7\r[3bE2,W\t_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010\u0003\u0005\u00022\u0005e\u0001\u0019AA\u001a\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yiB!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!B9vKJL(bAA\u001f/\u0005!\u0011.\u001c9m\u0013\u0011\t\t%a\u000e\u0003)Q\u0013\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u\u0011%\t)\u0005\u0001b\u0001\n\u0013\t9%A\u0002m_\u001e,\"!!\u0013\u0011\u0007]\u000bY%C\u0002\u0002Na\u00131\u0001T8h\u0011!\t\t\u0006\u0001Q\u0001\n\u0005%\u0013\u0001\u00027pO\u0002B\u0011\"!\u0016\u0001\u0005\u0004%I!a\u0016\u0002'Ad\u0017M\\*uC2,g.Z:t\u0007\u0006dG.\u001a:\u0016\u0005\u0005e\u0003#B\u001c\u0002\\\u0005%\u0012bAA/\u0005\t\u0019\u0002\u000b\\1o'R\fG.\u001a8fgN\u001c\u0015\r\u001c7fe\"A\u0011\u0011\r\u0001!\u0002\u0013\tI&\u0001\u000bqY\u0006t7\u000b^1mK:,7o]\"bY2,'\u000f\t\u0005\n\u0003K\u0002!\u0019!C\u0005\u0003O\n!\"];fef\u001c\u0015m\u00195f+\t\tI\u0007\u0005\u00048\u0003WR\u0014\u0011F\u0005\u0004\u0003[\u0012!AC)vKJL8)Y2iK\"A\u0011\u0011\u000f\u0001!\u0002\u0013\tI'A\u0006rk\u0016\u0014\u0018pQ1dQ\u0016\u0004\u0003\"CA;\u0001\t\u0007I\u0011BA<\u00039i\u0017m\u001d;fe\u000e{W\u000e]5mKJ,\"!!\u001f\u0011\u0007]\nY(C\u0002\u0002~\t\u0011a\"T1ti\u0016\u00148i\\7qS2,'\u000f\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0011BA=\u0003=i\u0017m\u001d;fe\u000e{W\u000e]5mKJ\u0004\u0003\"CAC\u0001\t\u0007I\u0011BAD\u00031\u00198\r[3nC\"+G\u000e]3s+\t\tI\tE\u00028\u0003\u0017K1!!$\u0003\u00051\u00196\r[3nC\"+G\u000e]3s\u0011!\t\t\n\u0001Q\u0001\n\u0005%\u0015!D:dQ\u0016l\u0017\rS3ma\u0016\u0014\b\u0005C\u0004\u0002\u0016\u0002!\t!a&\u0002\u000fA\u0014xNZ5mKRA\u0011\u0011TAS\u0003O\u000bY\f\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\tyJB\u0001\bOJ\f\u0007\u000f\u001b3c\u0013\u0011\t\u0019+!(\u0003\rI+7/\u001e7u\u0011\u001d\tI$a%A\u0002iB\u0001\"!+\u0002\u0014\u0002\u0007\u00111V\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u00055\u0016qW\u0007\u0003\u0003_SA!!-\u00024\u00069a/\u001b:uk\u0006d'bAA[\r\u00051a/\u00197vKNLA!!/\u00020\nAQ*\u00199WC2,X\r\u0003\u0005\u0002>\u0006M\u0005\u0019AA\u001a\u0003\u001d\u0019wN\u001c;fqRDq!!1\u0001\t\u0003\t\u0019-A\u0004fq\u0016\u001cW\u000f^3\u0015\u0015\u0005e\u0015QYAd\u0003\u0013\fY\rC\u0004\u0002:\u0005}\u0006\u0019\u0001\u001e\t\u0011\u0005%\u0016q\u0018a\u0001\u0003WC\u0001\"!0\u0002@\u0002\u0007\u00111\u0007\u0005\u000b\u0003+\u000by\f%AA\u0002\u00055\u0007cA\u0007\u0002P&\u0019\u0011\u0011\u001b\b\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005UGCCAl\u0003;\fy.a9\u0002fB!\u0011QGAm\u0013\u0011\tY.a\u000e\u0003\u001dE+XM]=Fq\u0016\u001cW\u000f^5p]\"9\u0011\u0011HAj\u0001\u0004Q\u0004\u0002CAq\u0003'\u0004\r!a+\u0002\u00135\f\u0007\u000fU1sC6\u001c\b\u0002CA_\u0003'\u0004\r!a\r\t\u0011\u0005\u001d\u00181\u001ba\u0001\u0003S\fAB]3tk2$()\u001e4gKJ\u0004B!!\u000e\u0002l&!\u0011Q^A\u001c\u00051\u0011Vm];mi\n+hMZ3s\u0011\u001d\t\t\u0010\u0001C\u0005\u0003g\fAbZ3u\u001fJ\u001cu.\u001c9jY\u0016$\u0002\"!\u000b\u0002v\u0006](\u0011\u0001\u0005\t\u0003{\u000by\u000f1\u0001\u00024!A\u0011\u0011`Ax\u0001\u0004\tY0\u0001\bqe\u0016\u0004\u0016M]:fIF+XM]=\u0011\u0007]\ni0C\u0002\u0002\u0000\n\u0011a\u0002\u0015:f!\u0006\u00148/\u001a3Rk\u0016\u0014\u0018\u0010C\u0004*\u0003_\u0004\rAa\u0001\u0011\t\t\u0015!Q\u0005\b\u0005\u0005\u000f\u0011\tC\u0004\u0003\u0003\n\t}a\u0002\u0002B\u0006\u0005;qAA!\u0004\u0003\u001c9!!q\u0002B\r\u001d\u0011\u0011\tBa\u0006\u000e\u0005\tM!b\u0001B\u000b\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011B\u0001\u0018\u0003\u0013\r\u0011\u0019#L\u0001\u0012\u0007>l\u0007/\u001b7bi&|g\u000e\u0016:bG\u0016\u0014\u0018\u0002\u0002B\u0014\u0005S\u0011Q#U;fef\u001cu.\u001c9jY\u0006$\u0018n\u001c8Fm\u0016tGOC\u0002\u0003$5BqA!\f\u0001\t\u0003\u0011y#\u0001\tdY\u0016\f'/U;fef\u001c\u0015m\u00195fgR\u0011!\u0011\u0007\t\u0004\u001b\tM\u0012b\u0001B\u001b\u001d\t!Aj\u001c8h\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005w\t\u0001#[:QKJLw\u000eZ5d\u0007>lW.\u001b;\u0015\t\u00055'Q\b\u0005\b\u0003s\u00119\u00041\u0001;\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007\nqb\u00195fG.\u0004\u0016M]1nKR,'o\u001d\u000b\t\u0005\u000b\u0012YE!\u0019\u0003fA\u0019QBa\u0012\n\u0007\t%cB\u0001\u0003V]&$\b\u0002\u0003B'\u0005\u007f\u0001\rAa\u0014\u0002\u0017E,XM]=QCJ\fWn\u001d\t\u0006\u0005#\u0012YF\u000f\b\u0005\u0005'\u00129F\u0004\u0003\u0003\u0012\tU\u0013\"A\b\n\u0007\tec\"A\u0004qC\u000e\\\u0017mZ3\n\t\tu#q\f\u0002\u0004'\u0016\f(b\u0001B-\u001d!A!1\rB \u0001\u0004\tY+A\u0006hSZ,g\u000eU1sC6\u001c\b\u0002\u0003B4\u0005\u007f\u0001\r!a+\u0002\u001f\u0015DHO]1di\u0016$\u0007+\u0019:b[NDcAa\u0010\u0003l\te\u0004#B\u0007\u0003n\tE\u0014b\u0001B8\u001d\t1A\u000f\u001b:poN\u0004BAa\u001d\u0003v5\tA!C\u0002\u0003x\u0011\u0011!\u0004U1sC6,G/\u001a:O_R4u.\u001e8e\u000bb\u001cW\r\u001d;j_:\u001c#A!\u001d\t\u0013\tu\u0004!%A\u0005\u0002\t}\u0014!E3yK\u000e,H/\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0011\u0016\u0005\u0003\u001b\u0014\u0019i\u000b\u0002\u0003\u0006B!!q\u0011BI\u001b\t\u0011II\u0003\u0003\u0003\f\n5\u0015!C;oG\",7m[3e\u0015\r\u0011yID\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BJ\u0005\u0013\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f\u001d\u00119J\u0001E\u0001\u00053\u000bq\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\t\u0004o\tmeAB\u0001\u0003\u0011\u0003\u0011ijE\u0002\u0003\u001c2Aq\u0001\u001cBN\t\u0003\u0011\t\u000b\u0006\u0002\u0003\u001a\"Q!Q\u0015BN\u0005\u0004%\tAa*\u0002'Ac\u0015IT0C+&cE)\u0013(H?R\u0013\u0016*R*\u0016\u0005\t%\u0006cA\u0007\u0003,&\u0019!Q\u0016\b\u0003\u0007%sG\u000fC\u0005\u00032\nm\u0005\u0015!\u0003\u0003*\u0006!\u0002\u000bT!O?\n+\u0016\n\u0014#J\u001d\u001e{FKU%F'\u0002B!B!.\u0003\u001cF\u0005I\u0011\u0001B\\\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!\u0011\u0018\u0016\u0004C\n\r\u0005")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<String> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerFactory compatibilityFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final PlanStalenessCaller<CacheableExecutableQuery> planStalenessCaller;
    private final QueryCache<String, CacheableExecutableQuery> queryCache;
    private final MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<String> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerFactory compatibilityFactory() {
        return this.compatibilityFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ReusabilityState org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(CacheableExecutableQuery cachedExecutableQuery, TransactionalContext transactionalContext) {
        return cachedExecutableQuery.plan().reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private PlanStalenessCaller<CacheableExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<String, CacheableExecutableQuery> queryCache() {
        return this.queryCache;
    }

    public MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public Result profile(String query, MapValue params, TransactionalContext context) {
        return this.execute(query, params, context, true);
    }

    /*
     * WARNING - void declaration
     */
    public Result execute(String query, MapValue params, TransactionalContext context, boolean profile) {
        Result result;
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        try {
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile);
            CacheableExecutableQuery cachedExecutableQuery = this.getOrCompile(context, preParsedQuery, queryTracer);
            String string = preParsedQuery.executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(cachedExecutableQuery.paramNames(), params, cachedExecutableQuery.extractedParams());
            }
            MapValue combinedParams = params.updatedWith(cachedExecutableQuery.extractedParams());
            context.executingQuery().planningCompleted(cachedExecutableQuery.plan().plannerInfo());
            result = cachedExecutableQuery.plan().run(context, preParsedQuery.executionMode(), combinedParams);
            queryTracer.close();
        }
        catch (Throwable throwable) {
            try {
                context.close(false);
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var5_5;
                var5_5.close();
                throw throwable2;
            }
        }
        return result;
    }

    public QueryExecution execute(String query, MapValue mapParams, TransactionalContext context, ResultBuffer resultBuffer) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean execute$default$4() {
        return false;
    }

    private CacheableExecutableQuery getOrCompile(TransactionalContext context, PreParsedQuery preParsedQuery, CompilationTracer.QueryCompilationEvent tracer) {
        String cacheKey = preParsedQuery.statementWithVersionAndPlanner();
        TransactionalContext tc = context.getOrBeginNewIfClosed();
        try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
            for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                BoxedUnit boxedUnit;
                long schemaToken = this.schemaHelper().readSchemaToken(tc);
                CacheLookup<CacheableExecutableQuery> cacheLookup = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, (Function0<CacheableExecutableQuery>)new Serializable(this, preParsedQuery, tracer, tc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionEngine $outer;
                    private final PreParsedQuery preParsedQuery$1;
                    private final CompilationTracer.QueryCompilationEvent tracer$1;
                    private final TransactionalContext tc$1;

                    public final CacheableExecutableQuery apply() {
                        return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1, this.tracer$1, this.tc$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.preParsedQuery$1 = preParsedQuery$1;
                        this.tracer$1 = tracer$1;
                        this.tc$1 = tc$1;
                    }
                }, preParsedQuery.rawStatement());
                CacheLookup<CacheableExecutableQuery> cacheLookup2 = cacheLookup;
                boolean bl = cacheLookup2 instanceof CacheHit ? true : cacheLookup2 instanceof CacheDisabled;
                if (bl) {
                    CacheableExecutableQuery executableQuery = cacheLookup.executableQuery();
                    if (this.schemaHelper().lockLabels(schemaToken, executableQuery.plan(), preParsedQuery.version(), tc)) {
                        tc.cleanForReuse();
                        return executableQuery;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (cacheLookup2 instanceof CacheMiss) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError(cacheLookup2);
            }
            throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
        }
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        return this.preParser().preParseQuery(query, false).isPeriodicCommit();
    }

    private void checkParameters(Seq<String> queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        Serializable x$1 = new Serializable(this, queryParams, givenParams, extractedParams){
            public static final long serialVersionUID = 0L;
            private final Seq queryParams$1;
            public final MapValue givenParams$1;
            public final MapValue extractedParams$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq missingKeys = (Seq)this.queryParams$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkParameters$1 $outer;

                    public final boolean apply(String key) {
                        return !this.$outer.givenParams$1.containsKey(key) && !this.$outer.extractedParams$1.containsKey(key);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (missingKeys.nonEmpty()) {
                    throw new ParameterNotFoundException(new StringBuilder().append((Object)"Expected parameter(s): ").append((Object)missingKeys.mkString(", ")).toString());
                }
            }
            {
                this.queryParams$1 = queryParams$1;
                this.givenParams$1 = givenParams$1;
                this.extractedParams$1 = extractedParams$1;
            }
        };
        Function1 x$2 = exceptionHandler.runSafely$.MODULE$.apply$default$2((Function0)x$1);
        exceptionHandler.runSafely$.MODULE$.apply((Function0)x$1, x$2);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<String> cacheTracer, CypherConfiguration config, CompilerFactory compatibilityFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compatibilityFactory = compatibilityFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't work with a null graph database";
            }
        });
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new StringCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor$class.cacheFlushDetected(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor$class.cacheHit(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor$class.cacheMiss(this, key);
            }

            public void cacheDiscard(String ignored, String query, int secondsSinceReplan) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Discarded stale query from the query cache after ", " seconds: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)secondsSinceReplan), query})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor$class.$init$(this);
                CypherCacheFlushingMonitor$class.$init$(this);
            }
        }, new String[0]);
        this.planStalenessCaller = new PlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;

            public final ReusabilityState apply(CacheableExecutableQuery cachedExecutableQuery, TransactionalContext transactionalContext) {
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(cachedExecutableQuery, transactionalContext);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.queryCache = new QueryCache<String, CacheableExecutableQuery>(config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler = new MasterCompiler(queryService, kernelMonitors, config, logProvider, new CompilerLibrary(compatibilityFactory));
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

