/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.helpers.collection.Pair;
import scala.collection.immutable.Map;

public class MonitoringCacheTracer
implements CacheTracer<Pair<String, Map<String, Class<?>>>> {
    private final StringCacheMonitor monitor;

    public MonitoringCacheTracer(StringCacheMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void queryCacheHit(Pair<String, Map<String, Class<?>>> queryKey, String metaData) {
        this.monitor.cacheHit(queryKey);
    }

    @Override
    public void queryCacheMiss(Pair<String, Map<String, Class<?>>> queryKey, String metaData) {
        this.monitor.cacheMiss(queryKey);
    }

    @Override
    public void queryCacheStale(Pair<String, Map<String, Class<?>>> queryKey, int secondsSincePlan, String metaData) {
        this.monitor.cacheDiscard(queryKey, metaData, secondsSincePlan);
    }

    @Override
    public void queryCacheFlush(long sizeOfCacheBeforeFlush) {
        this.monitor.cacheFlushDetected(sizeOfCacheBeforeFlush);
    }
}

