/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.cypher.internal.javacompat.MapRow;
import org.neo4j.cypher.internal.javacompat.QueryResultProvider;
import org.neo4j.cypher.internal.javacompat.UnstableSnapshotException;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;

class EagerResult
implements Result,
QueryResultProvider {
    private static final String ITEM_SEPARATOR = ", ";
    private final Result originalResult;
    private final VersionContext versionContext;
    private final List<Map<String, Object>> queryResult = new ArrayList<Map<String, Object>>();
    private int cursor;

    EagerResult(Result result, VersionContext versionContext) {
        this.originalResult = result;
        this.versionContext = versionContext;
    }

    public void consume() {
        while (this.originalResult.hasNext()) {
            this.queryResult.add(this.originalResult.next());
        }
    }

    public QueryExecutionType getQueryExecutionType() {
        return this.originalResult.getQueryExecutionType();
    }

    public List<String> columns() {
        return this.originalResult.columns();
    }

    public <T> ResourceIterator<T> columnAs(String name) {
        return new EagerResultResourceIterator(name);
    }

    public boolean hasNext() {
        return this.cursor < this.queryResult.size();
    }

    public Map<String, Object> next() {
        return this.queryResult.get(this.cursor++);
    }

    public void close() {
    }

    public QueryStatistics getQueryStatistics() {
        return this.originalResult.getQueryStatistics();
    }

    public ExecutionPlanDescription getExecutionPlanDescription() {
        return this.originalResult.getExecutionPlanDescription();
    }

    @Override
    public QueryResult queryResult() {
        return new EagerQueryResult();
    }

    public String resultAsString() {
        List columns = this.originalResult.columns();
        StringBuilder builder = new StringBuilder();
        builder.append(String.join((CharSequence)ITEM_SEPARATOR, columns));
        if (!this.queryResult.isEmpty()) {
            builder.append(System.lineSeparator());
            int numberOfColumns = columns.size();
            for (Map<String, Object> row : this.queryResult) {
                this.writeRow(columns, builder, numberOfColumns, row);
                builder.append(System.lineSeparator());
            }
        }
        return builder.toString();
    }

    public void writeAsStringTo(PrintWriter writer) {
        writer.print(this.resultAsString());
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    public Iterable<Notification> getNotifications() {
        return this.originalResult.getNotifications();
    }

    public <VisitationException extends Exception> void accept(Result.ResultVisitor<VisitationException> visitor) throws VisitationException {
        try {
            for (Map<String, Object> map : this.queryResult) {
                visitor.visit((Result.ResultRow)new MapRow(map));
            }
            this.checkIfDirty();
        }
        catch (NotFoundException e) {
            this.checkIfDirty();
            throw e;
        }
    }

    private void checkIfDirty() {
        if (this.versionContext.isDirty()) {
            throw new QueryExecutionKernelException((Throwable)((Object)new UnstableSnapshotException("Unable to get clean data snapshot for query serialisation.", new Object[0]))).asUserException();
        }
    }

    private void writeRow(List<String> columns, StringBuilder builder, int numberOfColumns, Map<String, Object> row) {
        for (int i = 0; i < numberOfColumns; ++i) {
            builder.append(row.get(columns.get(i)));
            if (i == numberOfColumns - 1) continue;
            builder.append(ITEM_SEPARATOR);
        }
    }

    private class EagerQueryResult
    implements QueryResult {
        private final String[] fields;

        EagerQueryResult() {
            this.fields = EagerResult.this.originalResult.columns().toArray(new String[0]);
        }

        public String[] fieldNames() {
            return this.fields;
        }

        public <E extends Exception> void accept(QueryResult.QueryResultVisitor<E> visitor) throws E {
            while (EagerResult.this.hasNext()) {
                Object row = EagerResult.this.next();
                AnyValue[] anyValues = new AnyValue[this.fields.length];
                for (int i = 0; i < this.fields.length; ++i) {
                    anyValues[i] = ValueUtils.of(row.get(this.fields[i]));
                }
                visitor.visit(() -> anyValues);
            }
        }

        public QueryExecutionType executionType() {
            return EagerResult.this.originalResult.getQueryExecutionType();
        }

        public QueryStatistics queryStatistics() {
            return EagerResult.this.originalResult.getQueryStatistics();
        }

        public ExecutionPlanDescription executionPlanDescription() {
            return EagerResult.this.originalResult.getExecutionPlanDescription();
        }

        public Iterable<Notification> getNotifications() {
            return EagerResult.this.originalResult.getNotifications();
        }

        public void close() {
        }
    }

    private class EagerResultResourceIterator<T>
    implements ResourceIterator<T> {
        private final String column;
        int cursor;

        EagerResultResourceIterator(String column) {
            this.column = column;
        }

        public boolean hasNext() {
            return this.cursor < EagerResult.this.queryResult.size();
        }

        public T next() {
            return (T)((Map)EagerResult.this.queryResult.get(this.cursor++)).get(this.column);
        }

        public void close() {
        }
    }
}

