/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.cypher.internal.CommunityCompilerFactory;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.compatibility.CypherRuntimeConfiguration;
import org.neo4j.cypher.internal.compiler.v3_5.CypherPlannerConfiguration;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.javacompat.GraphDatabaseCypherService;
import org.neo4j.cypher.internal.javacompat.SnapshotExecutionEngine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;

public class CommunityCypherEngineProvider
extends QueryEngineProvider {
    public CommunityCypherEngineProvider() {
        super("cypher");
    }

    protected int enginePriority() {
        return 42;
    }

    protected QueryExecutionEngine createEngine(Dependencies deps, GraphDatabaseAPI graphAPI) {
        GraphDatabaseCypherService queryService = new GraphDatabaseCypherService((GraphDatabaseService)graphAPI);
        deps.satisfyDependency((Object)queryService);
        DependencyResolver resolver = graphAPI.getDependencyResolver();
        LogService logService = (LogService)resolver.resolveDependency(LogService.class);
        Monitors monitors = (Monitors)resolver.resolveDependency(Monitors.class);
        Config config = (Config)resolver.resolveDependency(Config.class);
        CypherConfiguration cypherConfig = CypherConfiguration.fromConfig(config);
        CypherPlannerConfiguration plannerConfig = cypherConfig.toCypherPlannerConfiguration(config);
        CypherRuntimeConfiguration runtimeConfig = cypherConfig.toCypherRuntimeConfiguration();
        LogProvider logProvider = logService.getInternalLogProvider();
        CommunityCompilerFactory compilerFactory = new CommunityCompilerFactory((GraphDatabaseQueryService)queryService, monitors, logProvider, plannerConfig, runtimeConfig);
        deps.satisfyDependencies(new Object[]{compilerFactory});
        return this.createEngine(queryService, config, logProvider, compilerFactory);
    }

    private QueryExecutionEngine createEngine(GraphDatabaseCypherService queryService, Config config, LogProvider logProvider, CommunityCompilerFactory compilerFactory) {
        return (Boolean)config.get(GraphDatabaseSettings.snapshot_query) != false ? this.snapshotEngine(queryService, config, logProvider, compilerFactory) : this.standardEngine(queryService, logProvider, compilerFactory);
    }

    private SnapshotExecutionEngine snapshotEngine(GraphDatabaseCypherService queryService, Config config, LogProvider logProvider, CommunityCompilerFactory compilerFactory) {
        return new SnapshotExecutionEngine((GraphDatabaseQueryService)queryService, config, logProvider, compilerFactory);
    }

    private ExecutionEngine standardEngine(GraphDatabaseCypherService queryService, LogProvider logProvider, CommunityCompilerFactory compilerFactory) {
        return new ExecutionEngine((GraphDatabaseQueryService)queryService, logProvider, compilerFactory);
    }
}

