/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import org.neo4j.cypher.CypherPlannerOption;
import org.neo4j.cypher.CypherRuntimeOption;
import org.neo4j.cypher.CypherUpdateStrategy;
import org.neo4j.cypher.CypherVersion;
import org.neo4j.cypher.CypherVersion$v3_5$;
import org.neo4j.cypher.CypherVersion$v4_0$;
import org.neo4j.cypher.internal.CommunityAdministrationCommandRuntime;
import org.neo4j.cypher.internal.CommunityAdministrationCommandRuntime$;
import org.neo4j.cypher.internal.CommunityRuntimeContext;
import org.neo4j.cypher.internal.CommunityRuntimeContextManager;
import org.neo4j.cypher.internal.CommunityRuntimeFactory$;
import org.neo4j.cypher.internal.Compiler;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CypherCurrentCompiler;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.CypherRuntimeConfiguration;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler$;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.compiler.CypherPlannerConfiguration;
import org.neo4j.cypher.internal.planning.CypherPlanner;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u0017\tA2i\\7nk:LG/_\"p[BLG.\u001a:GC\u000e$xN]=\u000b\u0005\r!\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u00151\u0011AB2za\",'O\u0003\u0002\b\u0011\u0005)a.Z85U*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005=\u0019u.\u001c9jY\u0016\u0014h)Y2u_JL\b\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m1\u0011AB6fe:,G.\u0003\u0002\u001e5\tIrI]1qQ\u0012\u000bG/\u00192bg\u0016\fV/\u001a:z'\u0016\u0014h/[2f\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013AD6fe:,G.T8oSR|'o\u001d\t\u0003C\u0011j\u0011A\t\u0006\u0003G\u0019\t!\"\\8oSR|'/\u001b8h\u0013\t)#E\u0001\u0005N_:LGo\u001c:t\u0011!9\u0003A!A!\u0002\u0013A\u0013a\u00037pOB\u0013xN^5eKJ\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0004\u0002\u000f1|wmZ5oO&\u0011QF\u000b\u0002\f\u0019><\u0007K]8wS\u0012,'\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00035\u0001H.\u00198oKJ\u001cuN\u001c4jOB\u0011\u0011\u0007N\u0007\u0002e)\u00111GA\u0001\tG>l\u0007/\u001b7fe&\u0011QG\r\u0002\u001b\u0007f\u0004\b.\u001a:QY\u0006tg.\u001a:D_:4\u0017nZ;sCRLwN\u001c\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005i!/\u001e8uS6,7i\u001c8gS\u001e\u0004\"aE\u001d\n\u0005i\u0012!AG\"za\",'OU;oi&lWmQ8oM&<WO]1uS>t\u0007\"\u0002\u001f\u0001\t\u0003i\u0014A\u0002\u001fj]&$h\b\u0006\u0004?\u007f\u0001\u000b%i\u0011\t\u0003'\u0001AQaF\u001eA\u0002aAQaH\u001eA\u0002\u0001BQaJ\u001eA\u0002!BQaL\u001eA\u0002ABQaN\u001eA\u0002aBq!\u0012\u0001C\u0002\u0013%a)A\u0002m_\u001e,\u0012a\u0012\t\u0003S!K!!\u0013\u0016\u0003\u00071{w\r\u0003\u0004L\u0001\u0001\u0006IaR\u0001\u0005Y><\u0007\u0005C\u0003N\u0001\u0011\u0005c*\u0001\bde\u0016\fG/Z\"p[BLG.\u001a:\u0015\r=\u0013\u0006,\u00182h!\t\u0019\u0002+\u0003\u0002R\u0005\tA1i\\7qS2,'\u000fC\u0003T\u0019\u0002\u0007A+A\u0007dsBDWM\u001d,feNLwN\u001c\t\u0003+Zk\u0011\u0001B\u0005\u0003/\u0012\u0011QbQ=qQ\u0016\u0014h+\u001a:tS>t\u0007\"B-M\u0001\u0004Q\u0016!D2za\",'\u000f\u00157b]:,'\u000f\u0005\u0002V7&\u0011A\f\u0002\u0002\u0014\u0007f\u0004\b.\u001a:QY\u0006tg.\u001a:PaRLwN\u001c\u0005\u0006=2\u0003\raX\u0001\u000eGf\u0004\b.\u001a:Sk:$\u0018.\\3\u0011\u0005U\u0003\u0017BA1\u0005\u0005M\u0019\u0015\u0010\u001d5feJ+h\u000e^5nK>\u0003H/[8o\u0011\u0015\u0019G\n1\u0001e\u0003Q\u0019\u0017\u0010\u001d5feV\u0003H-\u0019;f'R\u0014\u0018\r^3hsB\u0011Q+Z\u0005\u0003M\u0012\u0011AcQ=qQ\u0016\u0014X\u000b\u001d3bi\u0016\u001cFO]1uK\u001eL\b\"\u00025M\u0001\u0004I\u0017aF3yK\u000e,H/[8o\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s!\ri!\u000e\\\u0005\u0003W:\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005Mi\u0017B\u00018\u0003\u0005=)\u00050Z2vi&|g.\u00128hS:,\u0007")
public class CommunityCompilerFactory
implements CompilerFactory {
    private final GraphDatabaseQueryService graph;
    private final Monitors kernelMonitors;
    private final CypherPlannerConfiguration plannerConfig;
    private final CypherRuntimeConfiguration runtimeConfig;
    private final Log log;

    private Log log() {
        return this.log;
    }

    @Override
    public Compiler createCompiler(CypherVersion cypherVersion, CypherPlannerOption cypherPlanner, CypherRuntimeOption cypherRuntime, CypherUpdateStrategy cypherUpdateStrategy, Function0<ExecutionEngine> executionEngineProvider) {
        boolean bl;
        CypherVersion cypherVersion2 = cypherVersion;
        if (CypherVersion$v3_5$.MODULE$.equals(cypherVersion2)) {
            bl = true;
        } else if (CypherVersion$v4_0$.MODULE$.equals(cypherVersion2)) {
            bl = false;
        } else {
            throw new MatchError((Object)cypherVersion2);
        }
        boolean compatibilityMode = bl;
        CypherPlanner planner = new CypherPlanner(this.plannerConfig, MasterCompiler$.MODULE$.CLOCK(), this.kernelMonitors, this.log(), cypherPlanner, cypherUpdateStrategy, (Function0<Object>)new LastCommittedTxIdProvider(this.graph), compatibilityMode);
        CypherRuntime<RuntimeContext> runtime = this.plannerConfig.planSystemCommands() ? new CommunityAdministrationCommandRuntime((ExecutionEngine)executionEngineProvider.apply(), this.graph.getDependencyResolver(), CommunityAdministrationCommandRuntime$.MODULE$.apply$default$3()) : CommunityRuntimeFactory$.MODULE$.getRuntime(cypherRuntime, this.plannerConfig.useErrorsOverWarnings());
        return new CypherCurrentCompiler<CommunityRuntimeContext>(planner, runtime, new CommunityRuntimeContextManager(this.log(), this.runtimeConfig), this.kernelMonitors);
    }

    public CommunityCompilerFactory(GraphDatabaseQueryService graph, Monitors kernelMonitors, LogProvider logProvider, CypherPlannerConfiguration plannerConfig, CypherRuntimeConfiguration runtimeConfig) {
        this.graph = graph;
        this.kernelMonitors = kernelMonitors;
        this.plannerConfig = plannerConfig;
        this.runtimeConfig = runtimeConfig;
        this.log = logProvider.getLog(this.getClass());
    }
}

