/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.internal.helpers.collection.Pair;
import scala.Option;

public class MonitoringCacheTracer
implements CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> {
    private final ExecutionEngineQueryCacheMonitor monitor;

    public MonitoringCacheTracer(ExecutionEngineQueryCacheMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void queryCacheHit(Pair<String, QueryCache.ParameterTypeMap> queryKey, String metaData) {
        this.monitor.cacheHit(queryKey);
    }

    @Override
    public void queryCacheMiss(Pair<String, QueryCache.ParameterTypeMap> queryKey, String metaData) {
        this.monitor.cacheMiss(queryKey);
    }

    @Override
    public void queryCompile(Pair<String, QueryCache.ParameterTypeMap> queryKey, String metaData) {
        this.monitor.cacheCompile(queryKey);
    }

    @Override
    public void queryCompileWithExpressionCodeGen(Pair<String, QueryCache.ParameterTypeMap> queryKey, String metaData) {
        this.monitor.cacheCompileWithExpressionCodeGen(queryKey);
    }

    @Override
    public void queryCacheStale(Pair<String, QueryCache.ParameterTypeMap> queryKey, int secondsSincePlan, String metaData, Option<String> maybeReason) {
        this.monitor.cacheDiscard(queryKey, metaData, secondsSincePlan, maybeReason);
    }

    @Override
    public void queryCacheFlush(long sizeOfCacheBeforeFlush) {
        this.monitor.cacheFlushDetected(sizeOfCacheBeforeFlush);
    }
}

