/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.util.List;
import org.neo4j.cypher.CypherExecutionMode;
import org.neo4j.cypher.CypherExecutionMode$explain$;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.DefaultPlanStalenessCaller;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.planning.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r\u0005e\u0001\u0002\u001c8\u0001\u0001C\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003S\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0011\"a\u0006\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0015\u0005e\u0001A!b\u0001\n\u0003\tY\u0002\u0003\u0006\u0002$\u0001\u0011\t\u0011)A\u0005\u0003;A!\"!\n\u0001\u0005\u000b\u0007I\u0011AA\u0014\u0011)\ty\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0006\u0005\u000b\u0003c\u0001!Q1A\u0005\u0002\u0005M\u0002BCA!\u0001\t\u0005\t\u0015!\u0003\u00026!Q\u00111\t\u0001\u0003\u0006\u0004%\t!!\u0012\t\u0015\u0005M\u0003A!A!\u0002\u0013\t9\u0005\u0003\u0006\u0002V\u0001\u0011)\u0019!C\u0001\u0003/B!\"!\u001b\u0001\u0005\u0003\u0005\u000b\u0011BA-\u0011\u001d\tY\u0007\u0001C\u0001\u0003[B\u0011\"a!\u0001\u0005\u0004%I!!\"\t\u0011\u0005]\u0005\u0001)A\u0005\u0003\u000fC\u0011\"!'\u0001\u0005\u0004%I!a'\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003;C\u0011\"!*\u0001\u0005\u0004%I!a*\t\u0011\u0005=\u0006\u0001)A\u0005\u0003SCq!!-\u0001\t\u0013\t\u0019\fC\u0005\u0002P\u0002\u0011\r\u0011\"\u0003\u0002R\"A\u0011\u0011\u001c\u0001!\u0002\u0013\t\u0019\u000eC\u0005\u0002\\\u0002\u0011\r\u0011\"\u0003\u0002^\"A\u0011Q\u001d\u0001!\u0002\u0013\ty\u000eC\u0005\u0002h\u0002\u0011\r\u0011\"\u0003\u0002j\"A\u0011\u0011\u001f\u0001!\u0002\u0013\tY\u000fC\u0005\u0002t\u0002\u0011\r\u0011\"\u0003\u0002v\"A\u0011Q \u0001!\u0002\u0013\t9\u0010C\u0005\u0002\u0000\u0002\u0011\r\u0011\"\u0003\u0003\u0002!A!\u0011\u0002\u0001!\u0002\u0013\u0011\u0019\u0001C\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\t-\u0001\u0001\"\u0001\u0003H!9!Q\u000e\u0001\u0005\u0002\t=\u0004b\u0002BA\u0001\u0011%!1\u0011\u0005\b\u0005\u0003\u0004A\u0011\u0002Bb\u0011\u001d\u0011i\u000e\u0001C\u0005\u0005?DqA!=\u0001\t\u0013\u0011\u0019\u0010C\u0004\u0003~\u0002!\tAa@\t\u000f\r\u001d\u0001\u0001\"\u0001\u0004\n!91Q\u0002\u0001\u0005\u0002\r=\u0001bBB\u0012\u0001\u0011%1QE\u0004\b\u0007+:\u0004\u0012AB,\r\u00191t\u0007#\u0001\u0004Z!9\u00111N\u0019\u0005\u0002\rm\u0003\"CB/c\t\u0007I\u0011AB0\u0011!\u00199'\rQ\u0001\n\r\u0005\u0004\"CB5cE\u0005I\u0011AB6\u0005=)\u00050Z2vi&|g.\u00128hS:,'B\u0001\u001d:\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001e<\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011A(P\u0001\u0006]\u0016|GG\u001b\u0006\u0002}\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\u0019E,XM]=TKJ4\u0018nY3\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001T\u001e\u0002\r-,'O\\3m\u0013\tq5JA\rHe\u0006\u0004\b\u000eR1uC\n\f7/Z)vKJL8+\u001a:wS\u000e,\u0017!D9vKJL8+\u001a:wS\u000e,\u0007%\u0001\blKJtW\r\\'p]&$xN]:\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!V\u001e\u0002\u00155|g.\u001b;pe&tw-\u0003\u0002X)\nAQj\u001c8ji>\u00148/A\blKJtW\r\\'p]&$xN]:!\u0003\u0019!(/Y2feV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_o\u00059AO]1dS:<\u0017B\u00011^\u0005E\u0019u.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM]\u0001\biJ\f7-\u001a:!\u0003-\u0019\u0017m\u00195f)J\f7-\u001a:\u0016\u0003\u0011\u00042!\u001a4i\u001b\u00059\u0014BA48\u0005-\u0019\u0015m\u00195f)J\f7-\u001a:\u0011\t%|\u0017\u000f`\u0007\u0002U*\u00111\u000e\\\u0001\u000bG>dG.Z2uS>t'BA7o\u0003\u001dAW\r\u001c9feNT!\u0001O\u001e\n\u0005AT'\u0001\u0002)bSJ\u0004\"A]=\u000f\u0005M<\bC\u0001;D\u001b\u0005)(B\u0001<@\u0003\u0019a$o\\8u}%\u0011\u0001pQ\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002y\u0007B\u0019Q0!\u0005\u000f\u0007y\fiAD\u0002\u0000\u0003\u0017qA!!\u0001\u0002\n9!\u00111AA\u0004\u001d\r!\u0018QA\u0005\u0002}%\u0011A(P\u0005\u0003umJ!\u0001O\u001d\n\u0007\u0005=q'\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016LA!a\u0005\u0002\u0016\t\u0001\u0002+\u0019:b[\u0016$XM\u001d+za\u0016l\u0015\r\u001d\u0006\u0004\u0003\u001f9\u0014\u0001D2bG\",GK]1dKJ\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002\u001eA\u0019Q-a\b\n\u0007\u0005\u0005rGA\nDsBDWM]\"p]\u001aLw-\u001e:bi&|g.A\u0004d_:4\u0017n\u001a\u0011\u0002\u001f\r|W\u000e]5mKJd\u0015N\u0019:bef,\"!!\u000b\u0011\u0007\u0015\fY#C\u0002\u0002.]\u0012qbQ8na&dWM\u001d'jEJ\f'/_\u0001\u0011G>l\u0007/\u001b7fe2K'M]1ss\u0002\nAbY1dQ\u00164\u0015m\u0019;pef,\"!!\u000e\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f8\u0003\u0015\u0019\u0017m\u00195f\u0013\u0011\ty$!\u000f\u0003)\r\u000bgMZ3j]\u0016\u001c\u0015m\u00195f\r\u0006\u001cGo\u001c:z\u00035\u0019\u0017m\u00195f\r\u0006\u001cGo\u001c:zA\u0005YAn\\4Qe>4\u0018\u000eZ3s+\t\t9\u0005\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\tieO\u0001\bY><w-\u001b8h\u0013\u0011\t\t&a\u0013\u0003\u00171{w\r\u0015:pm&$WM]\u0001\rY><\u0007K]8wS\u0012,'\u000fI\u0001\u0006G2|7m[\u000b\u0003\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0003uS6,'BAA2\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0014Q\f\u0002\u0006\u00072|7m[\u0001\u0007G2|7m\u001b\u0011\u0002\rqJg.\u001b;?)Q\ty'!\u001d\u0002t\u0005U\u0014qOA=\u0003w\ni(a \u0002\u0002B\u0011Q\r\u0001\u0005\u0006\u000fN\u0001\r!\u0013\u0005\u0006!N\u0001\rA\u0015\u0005\u00063N\u0001\ra\u0017\u0005\u0006EN\u0001\r\u0001\u001a\u0005\b\u00033\u0019\u0002\u0019AA\u000f\u0011\u001d\t)c\u0005a\u0001\u0003SAq!!\r\u0014\u0001\u0004\t)\u0004C\u0004\u0002DM\u0001\r!a\u0012\t\u0013\u0005U3\u0003%AA\u0002\u0005e\u0013\u0001\b3fM\u0006,H\u000e^)vKJLX\t_3dkRLwN\\'p]&$xN]\u000b\u0003\u0003\u000f\u0003B!!#\u0002\u00146\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)A\u0003rk\u0016\u0014\u0018PC\u0002\u0002\u0012.\u000bA![7qY&!\u0011QSAF\u0005U\tV/\u001a:z\u000bb,7-\u001e;j_:luN\\5u_J\fQ\u0004Z3gCVdG/U;fef,\u00050Z2vi&|g.T8oSR|'\u000fI\u0001\naJ,\u0007+\u0019:tKJ,\"!!(\u0011\u0007\u0015\fy*C\u0002\u0002\"^\u0012\u0011\u0002\u0015:f!\u0006\u00148/\u001a:\u0002\u0015A\u0014X\rU1sg\u0016\u0014\b%A\rmCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014XCAAU!\r)\u00171V\u0005\u0004\u0003[;$!\u0007'bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ\f!\u0004\\1ti\u000e{W.\\5ui\u0016$G\u000b_%e!J|g/\u001b3fe\u0002\n\u0001\u0003\u001d7b]J+Wo]1cS2LG/[=\u0015\r\u0005U\u00161XAc!\r)\u0017qW\u0005\u0004\u0003s;$\u0001\u0005*fkN\f'-\u001b7jif\u001cF/\u0019;f\u0011\u001d\tiL\u0007a\u0001\u0003\u007f\u000bq\"\u001a=fGV$\u0018M\u00197f#V,'/\u001f\t\u0004K\u0006\u0005\u0017bAAbo\tyQ\t_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010C\u0004\u0002Hj\u0001\r!!3\u0002)Q\u0014\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u!\u0011\tI)a3\n\t\u00055\u00171\u0012\u0002\u0015)J\fgn]1di&|g.\u00197D_:$X\r\u001f;\u0002\u00071|w-\u0006\u0002\u0002TB!\u0011\u0011JAk\u0013\u0011\t9.a\u0013\u0003\u00071{w-\u0001\u0003m_\u001e\u0004\u0013a\u00059mC:\u001cF/\u00197f]\u0016\u001c8oQ1mY\u0016\u0014XCAAp!\u0015)\u0017\u0011]A`\u0013\r\t\u0019o\u000e\u0002\u001b\t\u00164\u0017-\u001e7u!2\fgn\u0015;bY\u0016tWm]:DC2dWM]\u0001\u0015a2\fgn\u0015;bY\u0016tWm]:DC2dWM\u001d\u0011\u0002\u0015E,XM]=DC\u000eDW-\u0006\u0002\u0002lB9Q-!<rQ\u0006}\u0016bAAxo\tQ\u0011+^3ss\u000e\u000b7\r[3\u0002\u0017E,XM]=DC\u000eDW\rI\u0001\u000f[\u0006\u001cH/\u001a:D_6\u0004\u0018\u000e\\3s+\t\t9\u0010E\u0002f\u0003sL1!a?8\u00059i\u0015m\u001d;fe\u000e{W\u000e]5mKJ\fq\"\\1ti\u0016\u00148i\\7qS2,'\u000fI\u0001\rg\u000eDW-\\1IK2\u0004XM]\u000b\u0003\u0005\u0007\u00012!\u001aB\u0003\u0013\r\u00119a\u000e\u0002\r'\u000eDW-\\1IK2\u0004XM]\u0001\u000eg\u000eDW-\\1IK2\u0004XM\u001d\u0011\u0002\u000f\u0015DXmY;uKRq!q\u0002B\u000b\u0005/\u0011YCa\f\u0003:\tu\u0002\u0003BAE\u0005#IAAa\u0005\u0002\f\nq\u0011+^3ss\u0016CXmY;uS>t\u0007BBAGK\u0001\u0007\u0011\u000fC\u0004\u0003\u001a\u0015\u0002\rAa\u0007\u0002\rA\f'/Y7t!\u0011\u0011iBa\n\u000e\u0005\t}!\u0002\u0002B\u0011\u0005G\tqA^5siV\fGNC\u0002\u0003&m\naA^1mk\u0016\u001c\u0018\u0002\u0002B\u0015\u0005?\u0011\u0001\"T1q-\u0006dW/\u001a\u0005\b\u0005[)\u0003\u0019AAe\u0003\u001d\u0019wN\u001c;fqRDqA!\r&\u0001\u0004\u0011\u0019$A\u0004qe>4\u0017\u000e\\3\u0011\u0007\t\u0013)$C\u0002\u00038\r\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0003<\u0015\u0002\rAa\r\u0002\u0017A\u0014X\rU8qk2\fG/\u001a\u0005\b\u0005\u007f)\u0003\u0019\u0001B!\u0003)\u0019XOY:de&\u0014WM\u001d\t\u0005\u0003\u0013\u0013\u0019%\u0003\u0003\u0003F\u0005-%aD)vKJL8+\u001e2tGJL'-\u001a:\u0015!\t=!\u0011\nB)\u0005'\u0012)Fa\u0016\u0003h\t-\u0004bBAGM\u0001\u0007!1\n\t\u0004K\n5\u0013b\u0001B(o\t\u0001b)\u001e7msB\u000b'o]3e#V,'/\u001f\u0005\b\u000531\u0003\u0019\u0001B\u000e\u0011\u001d\u0011iC\na\u0001\u0003\u0013DqAa\u000f'\u0001\u0004\u0011\u0019\u0004C\u0004\u0003Z\u0019\u0002\rAa\u0017\u0002\u000b%t\u0007/\u001e;\u0011\t\tu#1M\u0007\u0003\u0005?R1A!\u00198\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u001a\u0003`\ty\u0011J\u001c9vi\u0012\u000bG/Y*ue\u0016\fW\u000eC\u0004\u0003j\u0019\u0002\r!a\"\u0002\u0019E,XM]=N_:LGo\u001c:\t\u000f\t}b\u00051\u0001\u0003B\u0005yQ\r_3dkR,7+\u001e2Rk\u0016\u0014\u0018\u0010\u0006\t\u0003\u0010\tE$1\u000fB;\u0005o\u0012YH! \u0003\u0000!1\u0011QR\u0014A\u0002EDqA!\u0007(\u0001\u0004\u0011Y\u0002C\u0004\u0003.\u001d\u0002\r!!3\t\u000f\tet\u00051\u0001\u00034\u0005\u0001\u0012n](vi\u0016\u0014Xn\\:u#V,'/\u001f\u0005\b\u0005c9\u0003\u0019\u0001B\u001a\u0011\u001d\u0011Yd\na\u0001\u0005gAqAa\u0010(\u0001\u0004\u0011\t%A\u0004dY>\u001c\u0018N\\4\u0016\t\t\u0015%Q\u0012\u000b\u0007\u0005\u000f\u0013IKa+\u0015\t\t%%q\u0014\t\u0005\u0005\u0017\u0013i\t\u0004\u0001\u0005\u000f\t=\u0005F1\u0001\u0003\u0012\n\tA+\u0005\u0003\u0003\u0014\ne\u0005c\u0001\"\u0003\u0016&\u0019!qS\"\u0003\u000f9{G\u000f[5oOB\u0019!Ia'\n\u0007\tu5IA\u0002B]fD\u0001B!))\t\u0003\u0007!1U\u0001\u0005G>$W\rE\u0003C\u0005K\u0013I)C\u0002\u0003(\u000e\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0005[A\u0003\u0019AAe\u0011\u001d\u0011i\u000b\u000ba\u0001\u0005_\u000b!\u0002\u001e:bG\u0016,e/\u001a8u!\u0011\u0011\tLa/\u000f\t\tM&q\u0017\b\u0004}\nU\u0016B\u000108\u0013\r\u0011I,X\u0001\u0012\u0007>l\u0007/\u001b7bi&|g\u000e\u0016:bG\u0016\u0014\u0018\u0002\u0002B_\u0005\u007f\u0013Q#U;fef\u001cu.\u001c9jY\u0006$\u0018n\u001c8Fm\u0016tGOC\u0002\u0003:v\u000b\u0011\u0002Z8Fq\u0016\u001cW\u000f^3\u0015)\t=!Q\u0019Bg\u0005\u001f\u0014\tNa5\u0003V\n]'\u0011\u001cBn\u0011\u001d\ti)\u000ba\u0001\u0005\u000f\u00042!\u001aBe\u0013\r\u0011Ym\u000e\u0002\u000b\u0013:\u0004X\u000f^)vKJL\bb\u0002B\rS\u0001\u0007!1\u0004\u0005\b\u0005[I\u0003\u0019AAe\u0011\u001d\u0011I(\u000ba\u0001\u0005gAqAa\u000f*\u0001\u0004\u0011\u0019\u0004C\u0004\u0003Z%\u0002\rAa\u0017\t\u000f\t%\u0014\u00061\u0001\u0002\b\"1\u0011,\u000ba\u0001\u0005_CqAa\u0010*\u0001\u0004\u0011\t%A\u0012d_6\u0004\u0018\u000e\\3s/&$\b.\u0012=qe\u0016\u001c8/[8o\u0007>$WmR3o\u001fB$\u0018n\u001c8\u0015\u0015\t\u0005(q\u001dBv\u0005[\u0014y\u000fE\u0003f\u0005G\fy,C\u0002\u0003f^\u00121eQ8na&dWM],ji\",\u0005\u0010\u001d:fgNLwN\\\"pI\u0016<UM\\(qi&|g\u000eC\u0004\u0003j*\u0002\rAa2\u0002\u0015%t\u0007/\u001e;Rk\u0016\u0014\u0018\u0010\u0003\u0004ZU\u0001\u0007!q\u0016\u0005\b\u0003\u000fT\u0003\u0019AAe\u0011\u001d\u0011IB\u000ba\u0001\u00057\tAbZ3u\u001fJ\u001cu.\u001c9jY\u0016$\"\"a0\u0003v\n](\u0011 B~\u0011\u001d\u0011ic\u000ba\u0001\u0003\u0013DqA!;,\u0001\u0004\u00119\r\u0003\u0004ZW\u0001\u0007!q\u0016\u0005\b\u00053Y\u0003\u0019\u0001B\u000e\u0003A\u0019G.Z1s#V,'/_\"bG\",7\u000f\u0006\u0002\u0004\u0002A\u0019!ia\u0001\n\u0007\r\u00151I\u0001\u0003M_:<\u0017\u0001E5t!\u0016\u0014\u0018n\u001c3jG\u000e{W.\\5u)\u0011\u0011\u0019da\u0003\t\r\u00055U\u00061\u0001r\u0003I9W\r^\"za\",'OR;oGRLwN\\:\u0016\u0005\rE\u0001CBB\n\u00073\u0019i\"\u0004\u0002\u0004\u0016)!1qCA1\u0003\u0011)H/\u001b7\n\t\rm1Q\u0003\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\n\u000e}\u0011\u0002BB\u0011\u0003\u0017\u00131CR;oGRLwN\\%oM>\u0014X.\u0019;j_:\fqb\u00195fG.\u0004\u0016M]1nKR,'o\u001d\u000b\t\u0007O\u0019ica\u000e\u0004<A\u0019!i!\u000b\n\u0007\r-2I\u0001\u0003V]&$\bbBB\u0018_\u0001\u00071\u0011G\u0001\fcV,'/\u001f)be\u0006l7\u000f\u0005\u0003C\u0007g\t\u0018bAB\u001b\u0007\n)\u0011I\u001d:bs\"91\u0011H\u0018A\u0002\tm\u0011aC4jm\u0016t\u0007+\u0019:b[NDqa!\u00100\u0001\u0004\u0011Y\"A\bfqR\u0014\u0018m\u0019;fIB\u000b'/Y7tQ\u0015y3\u0011IB*!\u0015\u001151IB$\u0013\r\u0019)e\u0011\u0002\u0007i\"\u0014xn^:\u0011\t\r%3qJ\u0007\u0003\u0007\u0017R1a!\u0014<\u0003))\u0007pY3qi&|gn]\u0005\u0005\u0007#\u001aYE\u0001\u000eQCJ\fW.\u001a;fe:{GOR8v]\u0012,\u0005pY3qi&|gn\t\u0002\u0004H\u0005yQ\t_3dkRLwN\\#oO&tW\r\u0005\u0002fcM\u0011\u0011'\u0011\u000b\u0003\u0007/\n1\u0003\u0015'B\u001d~\u0013U+\u0013'E\u0013:;u\f\u0016*J\u000bN+\"a!\u0019\u0011\u0007\t\u001b\u0019'C\u0002\u0004f\r\u00131!\u00138u\u0003Q\u0001F*\u0011(`\u0005VKE\nR%O\u000f~#&+S#TA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe*\"a!\u001c+\t\u0005e3qN\u0016\u0003\u0007c\u0002Baa\u001d\u0004~5\u00111Q\u000f\u0006\u0005\u0007o\u001aI(A\u0005v]\u000eDWmY6fI*\u001911P\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0000\rU$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerLibrary compilerLibrary;
    private final CaffeineCacheFactory cacheFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<String, Pair<String, QueryCache.ParameterTypeMap>, ExecutableQuery> queryCache;
    private final MasterCompiler masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$9() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$9();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerLibrary compilerLibrary() {
        return this.compilerLibrary;
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    private ReusabilityState planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<String, Pair<String, QueryCache.ParameterTypeMap>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        this.defaultQueryExecutionMonitor().startProcessing(context.executingQuery());
        return this.executeSubQuery(query, params, context, true, profile, prePopulate, subscriber);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber));
    }

    public QueryExecution executeSubQuery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.compilerLibrary().supportsAdministrativeCommands();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile, couldContainSensitiveFields);
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, this.defaultQueryExecutionMonitor(), queryTracer, subscriber);
        });
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable t) {
                context.rollback();
                throw t;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block4: {
            ExecutableQuery executableQuery2;
            try {
                executableQuery2 = this.getOrCompile(context, query, tracer, params);
            }
            catch (Throwable up) {
                if (isOutermostQuery) {
                    queryMonitor.endFailure(context.executingQuery(), up.getMessage());
                }
                throw up;
            }
            executableQuery = executableQuery2;
            String string = query.options().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block4;
            context.executingQuery().onObfuscatorReady(executableQuery.queryObfuscator());
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.queryType(), () -> executableQuery.planDescription());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        Function0 & Serializable & scala.Serializable compiledExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params);
        Function0 & Serializable & scala.Serializable interpretedExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0 ? (ExecutableQuery)this.compiledExpressionCompiler$1.apply() : (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount) {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() ? new Some(this.compiledExpressionCompiler$1.apply()) : None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        block5: {
            ExecutableQuery executableQuery;
            block4: {
                Pair cacheKey = Pair.of((Object)inputQuery.cacheKey(), (Object)QueryCache$.MODULE$.extractParameterTypeMap(params));
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params);
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale((Pair<String, QueryCache.ParameterTypeMap>)cacheKey, tc, compiler, inputQuery.options().replan(), inputQuery.description());
                        if (!this.schemaHelper().lockLabels(schemaToken, executableQuery2, inputQuery.options().version(), tc)) continue;
                        executableQuery = executableQuery2;
                        break block4;
                    }
                    break block5;
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2(), this.preParser().preParseQuery$default$3());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.options().executionMode();
        CypherExecutionMode$explain$ cypherExecutionMode$explain$ = CypherExecutionMode$explain$.MODULE$;
        return (cypherExecutionMode == null ? cypherExecutionMode$explain$ != null : !cypherExecutionMode.equals(cypherExecutionMode$explain$)) && preParsedQuery.options().isPeriodicCommit();
    }

    public List<FunctionInformation> getCypherFunctions() {
        Seq informations = (Seq)Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, List$.MODULE$.canBuildFrom());
        Seq predicateInformations = (Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, Seq$.MODULE$.canBuildFrom());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)informations.$plus$plus((GenTraversableOnce)predicateInformations, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key))))).distinct();
            throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missingKeys)).mkString(", ")).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> cacheTracer, CypherConfiguration config, CompilerLibrary compilerLibrary, CaffeineCacheFactory cacheFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compilerLibrary = compilerLibrary;
        this.cacheFactory = cacheFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0 & Serializable & scala.Serializable)() -> "Can't work with a null graph database");
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.expressionEngineOption(), config.operatorEngine(), config.interpretedPipesFallback(), config.queryCacheSize(), cacheFactory);
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new ExecutionEngineQueryCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor.cacheFlushDetected$(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.cacheHit$(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.cacheMiss$(this, key);
            }

            public void cacheCompile(Object key) {
                CypherCacheHitMonitor.cacheCompile$(this, key);
            }

            public void cacheCompileWithExpressionCodeGen(Object key) {
                CypherCacheHitMonitor.cacheCompileWithExpressionCodeGen$(this, key);
            }

            public void cacheDiscard(Pair<String, QueryCache.ParameterTypeMap> ignored, String query, int secondsSinceReplan, Option<String> maybeReason) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringBuilder(66).append("Discarded stale query from the query cache after ").append(secondsSinceReplan).append(" seconds").append(maybeReason.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)r -> new StringBuilder(10).append(". Reason: ").append((String)r).toString())).append(". Query: ").append(query).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.$init$(this);
                CypherCacheFlushingMonitor.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheDiscard$1(), $anonfun$cacheDiscard$2(java.lang.String )}, serializedLambda);
            }
        }, new String[0]);
        this.planStalenessCaller = new DefaultPlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), (Function2 & Serializable & scala.Serializable)(executableQuery, transactionalContext) -> this.planReusabilitiy((ExecutableQuery)executableQuery, (TransactionalContext)transactionalContext), this.org$neo4j$cypher$internal$ExecutionEngine$$log());
        this.queryCache = new QueryCache(cacheFactory, config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.masterCompiler = new MasterCompiler(compilerLibrary);
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

